/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.9
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGOCTAVE
#define SWIG_name_d      "CCMC"
#define SWIG_name        CCMC

#define SWIG_global_name      "cvar"
#define SWIG_op_prefix        "op_"


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



#include <cstdlib>
#include <iostream>
#include <octave/oct.h>
#include <octave/Cell.h>
#include <octave/dynamic-ld.h>
#include <octave/oct-env.h>
#include <octave/oct-map.h>
#include <octave/ov-fcn-handle.h>
#include <octave/parse.h>
#include <octave/toplev.h>
#include <octave/unwind-prot.h>

/* -----------------------------------------------------------------------------
 * swigrun.swg
 *
 * This file contains generic C API SWIG runtime support for pointer
 * type checking.
 * ----------------------------------------------------------------------------- */

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "4"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the SWIG runtime code.
  In 99.9% of the cases, SWIG just needs to declare them as 'static'.
  
  But only do this if strictly necessary, ie, if you have problems
  with your compiler or suchlike.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

/*  Generic buffer size */
#ifndef SWIG_BUFFER_SIZE
# define SWIG_BUFFER_SIZE 1024
#endif

/* Flags for pointer conversions */
#define SWIG_POINTER_DISOWN        0x1
#define SWIG_CAST_NEW_MEMORY       0x2

/* Flags for new pointer objects */
#define SWIG_POINTER_OWN           0x1


/* 
   Flags/methods for returning states.
   
   The SWIG conversion methods, as ConvertPtr, return an integer 
   that tells if the conversion was successful or not. And if not,
   an error code can be returned (see swigerrors.swg for the codes).
   
   Use the following macros/flags to set or process the returning
   states.
   
   In old versions of SWIG, code such as the following was usually written:

     if (SWIG_ConvertPtr(obj,vptr,ty.flags) != -1) {
       // success code
     } else {
       //fail code
     }

   Now you can be more explicit:

    int res = SWIG_ConvertPtr(obj,vptr,ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
    } else {
      // fail code
    }

   which is the same really, but now you can also do

    Type *ptr;
    int res = SWIG_ConvertPtr(obj,(void **)(&ptr),ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
      if (SWIG_IsNewObj(res) {
        ...
	delete *ptr;
      } else {
        ...
      }
    } else {
      // fail code
    }
    
   I.e., now SWIG_ConvertPtr can return new objects and you can
   identify the case and take care of the deallocation. Of course that
   also requires SWIG_ConvertPtr to return new result values, such as

      int SWIG_ConvertPtr(obj, ptr,...) {         
        if (<obj is ok>) {			       
          if (<need new object>) {		       
            *ptr = <ptr to new allocated object>; 
            return SWIG_NEWOBJ;		       
          } else {				       
            *ptr = <ptr to old object>;	       
            return SWIG_OLDOBJ;		       
          } 				       
        } else {				       
          return SWIG_BADOBJ;		       
        }					       
      }

   Of course, returning the plain '0(success)/-1(fail)' still works, but you can be
   more explicit by returning SWIG_BADOBJ, SWIG_ERROR or any of the
   SWIG errors code.

   Finally, if the SWIG_CASTRANK_MODE is enabled, the result code
   allows to return the 'cast rank', for example, if you have this

       int food(double)
       int fooi(int);

   and you call
 
      food(1)   // cast rank '1'  (1 -> 1.0)
      fooi(1)   // cast rank '0'

   just use the SWIG_AddCast()/SWIG_CheckState()
*/

#define SWIG_OK                    (0) 
#define SWIG_ERROR                 (-1)
#define SWIG_IsOK(r)               (r >= 0)
#define SWIG_ArgError(r)           ((r != SWIG_ERROR) ? r : SWIG_TypeError)  

/* The CastRankLimit says how many bits are used for the cast rank */
#define SWIG_CASTRANKLIMIT         (1 << 8)
/* The NewMask denotes the object was created (using new/malloc) */
#define SWIG_NEWOBJMASK            (SWIG_CASTRANKLIMIT  << 1)
/* The TmpMask is for in/out typemaps that use temporal objects */
#define SWIG_TMPOBJMASK            (SWIG_NEWOBJMASK << 1)
/* Simple returning values */
#define SWIG_BADOBJ                (SWIG_ERROR)
#define SWIG_OLDOBJ                (SWIG_OK)
#define SWIG_NEWOBJ                (SWIG_OK | SWIG_NEWOBJMASK)
#define SWIG_TMPOBJ                (SWIG_OK | SWIG_TMPOBJMASK)
/* Check, add and del mask methods */
#define SWIG_AddNewMask(r)         (SWIG_IsOK(r) ? (r | SWIG_NEWOBJMASK) : r)
#define SWIG_DelNewMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_NEWOBJMASK) : r)
#define SWIG_IsNewObj(r)           (SWIG_IsOK(r) && (r & SWIG_NEWOBJMASK))
#define SWIG_AddTmpMask(r)         (SWIG_IsOK(r) ? (r | SWIG_TMPOBJMASK) : r)
#define SWIG_DelTmpMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_TMPOBJMASK) : r)
#define SWIG_IsTmpObj(r)           (SWIG_IsOK(r) && (r & SWIG_TMPOBJMASK))

/* Cast-Rank Mode */
#if defined(SWIG_CASTRANK_MODE)
#  ifndef SWIG_TypeRank
#    define SWIG_TypeRank             unsigned long
#  endif
#  ifndef SWIG_MAXCASTRANK            /* Default cast allowed */
#    define SWIG_MAXCASTRANK          (2)
#  endif
#  define SWIG_CASTRANKMASK          ((SWIG_CASTRANKLIMIT) -1)
#  define SWIG_CastRank(r)           (r & SWIG_CASTRANKMASK)
SWIGINTERNINLINE int SWIG_AddCast(int r) { 
  return SWIG_IsOK(r) ? ((SWIG_CastRank(r) < SWIG_MAXCASTRANK) ? (r + 1) : SWIG_ERROR) : r;
}
SWIGINTERNINLINE int SWIG_CheckState(int r) { 
  return SWIG_IsOK(r) ? SWIG_CastRank(r) + 1 : 0; 
}
#else /* no cast-rank mode */
#  define SWIG_AddCast
#  define SWIG_CheckState(r) (SWIG_IsOK(r) ? 1 : 0)
#endif


#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *, int *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store information on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
  int                    owndata;		/* flag if the structure owns the clientdata */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (*f1 > *f2) ? 1 : -1;
  }
  return (int)((l1 - f1) - (l2 - f2));
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  if (ty) {
    swig_cast_info *iter = ty->cast;
    while (iter) {
      if (strcmp(iter->type->name, c) == 0) {
        if (iter == ty->cast)
          return iter;
        /* Move iter to the top of the linked list */
        iter->prev->next = iter->next;
        if (iter->next)
          iter->next->prev = iter->prev;
        iter->next = ty->cast;
        iter->prev = 0;
        if (ty->cast) ty->cast->prev = iter;
        ty->cast = iter;
        return iter;
      }
      iter = iter->next;
    }
  }
  return 0;
}

/* 
  Identical to SWIG_TypeCheck, except strcmp is replaced with a pointer comparison
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *ty) {
  if (ty) {
    swig_cast_info *iter = ty->cast;
    while (iter) {
      if (iter->type == from) {
        if (iter == ty->cast)
          return iter;
        /* Move iter to the top of the linked list */
        iter->prev->next = iter->next;
        if (iter->next)
          iter->next->prev = iter->prev;
        iter->next = ty->cast;
        iter->prev = 0;
        if (ty->cast) ty->cast->prev = iter;
        ty->cast = iter;
        return iter;
      }
      iter = iter->next;
    }
  }
  return 0;
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr, int *newmemory) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr, newmemory);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (!type) return NULL;
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}
SWIGRUNTIME void
SWIG_TypeNewClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientData(ti, clientdata);
  ti->owndata = 1;
}
  
/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13




#include <octave/version.h>
#ifndef OCTAVE_API_VERSION_NUMBER

  // Hack to distinguish between Octave 3.2 and earlier versions before OCTAVE_API_VERSION_NUMBER existed
  #define ComplexLU __ignore
  #include <octave/CmplxLU.h>
  #undef ComplexLU
  #ifdef octave_Complex_LU_h
  # define OCTAVE_API_VERSION_NUMBER 36
  #else
  # define OCTAVE_API_VERSION_NUMBER 37
  #endif

#endif

#if OCTAVE_API_VERSION_NUMBER < 37
#define SWIG_DEFUN(cname, wname, doc) DEFUNX_DLD(#cname, wname, FS ## cname, args, nargout, doc)
#else
#define SWIG_DEFUN(cname, wname, doc) DEFUNX_DLD(#cname, wname, G ## cname, args, nargout, doc)
#endif

SWIGRUNTIME bool SWIG_check_num_args(const char *func_name, int num_args, int max_args, int min_args, int varargs) {
  if (num_args > max_args && !varargs)
    error("function %s takes at most %i arguments", func_name, max_args);
  else if (num_args < min_args)
    error("function %s requires at least %i arguments", func_name, min_args);
  else
    return true;
  return false;
}

SWIGRUNTIME octave_value_list *SWIG_Octave_AppendOutput(octave_value_list *ovl, const octave_value &ov) {
  ovl->append(ov);
  return ovl;
}

SWIGRUNTIME octave_value SWIG_ErrorType(int code) {
  switch (code) {
  case SWIG_MemoryError:
    return "SWIG_MemoryError";
  case SWIG_IOError:
    return "SWIG_IOError";
  case SWIG_RuntimeError:
    return "SWIG_RuntimeError";
  case SWIG_IndexError:
    return "SWIG_IndexError";
  case SWIG_TypeError:
    return "SWIG_TypeError";
  case SWIG_DivisionByZero:
    return "SWIG_DivisionByZero";
  case SWIG_OverflowError:
    return "SWIG_OverflowError";
  case SWIG_SyntaxError:
    return "SWIG_SyntaxError";
  case SWIG_ValueError:
    return "SWIG_ValueError";
  case SWIG_SystemError:
    return "SWIG_SystemError";
  case SWIG_AttributeError:
    return "SWIG_AttributeError";
  }
  return "SWIG unknown error";
}

SWIGRUNTIME octave_value SWIG_Error(int code, const char *msg) {
  octave_value type(SWIG_ErrorType(code));
  std::string r = msg;
  r += " (" + type.string_value() + ")";
  error(r.c_str());
  return octave_value(r);
}

#define SWIG_fail                                       goto fail

#define SWIG_Octave_ConvertPtr(obj, pptr, type, flags)  SWIG_Octave_ConvertPtrAndOwn(obj, pptr, type, flags, 0)
#define SWIG_ConvertPtr(obj, pptr, type, flags)         SWIG_Octave_ConvertPtr(obj, pptr, type, flags)
#define SWIG_ConvertPtrAndOwn(obj,pptr,type,flags,own)  SWIG_Octave_ConvertPtrAndOwn(obj, pptr, type, flags, own)
#define SWIG_ConvertPtr(obj, pptr, type, flags)         SWIG_Octave_ConvertPtr(obj, pptr, type, flags)
#define SWIG_NewPointerObj(ptr, type, flags)            SWIG_Octave_NewPointerObj(ptr, type, flags)
#define swig_owntype                                    int

#define SWIG_ConvertPacked(obj, ptr, sz, ty)            SWIG_Octave_ConvertPacked(obj, ptr, sz, ty)
#define SWIG_NewPackedObj(ptr, sz, type)                SWIG_Octave_NewPackedObj(ptr, sz, type)

#define SWIG_ConvertFunctionPtr(obj, pptr, type)        SWIG_ConvertPtr(obj, pptr, type, 0)
#define SWIG_NewFunctionPtrObj(ptr, type)               SWIG_NewPointerObj(ptr, type, 0)

#define SWIG_ConvertMember(obj, ptr, sz, ty)            SWIG_Octave_ConvertPacked(obj, ptr, sz, ty)
#define SWIG_NewMemberObj(ptr, sz, type)                SWIG_Octave_NewPackedObj(ptr, sz, type)

#define SWIG_GetModule(clientdata) SWIG_Octave_GetModule(clientdata)
#define SWIG_SetModule(clientdata, pointer) SWIG_Octave_SetModule(clientdata,pointer);
#define SWIG_MODULE_CLIENTDATA_TYPE void*

#define Octave_Error_Occurred() 0
#define SWIG_Octave_AddErrorMsg(msg) {;}

SWIGRUNTIME swig_module_info *SWIG_Octave_GetModule(void *clientdata);
SWIGRUNTIME void SWIG_Octave_SetModule(void *clientdata, swig_module_info *pointer);

// For backward compatibility only
#define SWIG_POINTER_EXCEPTION  0
#define SWIG_arg_fail(arg)      0

// Runtime API implementation

#include <map>
#include <vector>
#include <string>

typedef octave_value_list(*octave_func) (const octave_value_list &, int);
class octave_swig_type;

namespace Swig {

#ifdef SWIG_DIRECTORS

  class Director;

  typedef std::map < void *, Director * > rtdir_map;
  SWIGINTERN rtdir_map* get_rtdir_map();
  SWIGINTERNINLINE void set_rtdir(void *vptr, Director *d);
  SWIGINTERNINLINE void erase_rtdir(void *vptr);
  SWIGINTERNINLINE Director *get_rtdir(void *vptr);

  SWIGRUNTIME void swig_director_destroyed(octave_swig_type *self, Director *d);
  SWIGRUNTIME octave_swig_type *swig_director_get_self(Director *d);
  SWIGRUNTIME void swig_director_set_self(Director *d, octave_swig_type *self);

#endif

  SWIGRUNTIME octave_base_value *swig_value_ref(octave_swig_type *ost);
  SWIGRUNTIME octave_swig_type *swig_value_deref(octave_value ov);
  SWIGRUNTIME octave_swig_type *swig_value_deref(const octave_base_value &ov);
}

#ifdef SWIG_DIRECTORS
SWIGRUNTIME void swig_acquire_ownership(void *vptr);
SWIGRUNTIME void swig_acquire_ownership_array(void *vptr);
SWIGRUNTIME void swig_acquire_ownership_obj(void *vptr, int own);
#endif

  struct swig_octave_member {
    const char *name;
    octave_func method;
    octave_func get_method;
    octave_func set_method;
    int flags;			// 1 static, 2 global
    const char *doc;
    bool is_static() const {
      return flags &1;
    } bool is_global() const {
      return flags &2;
    }
  };

  struct swig_octave_class {
    const char *name;
    swig_type_info **type;
    int director;
    octave_func constructor;
    const char *constructor_doc;
    octave_func destructor;
    const swig_octave_member *members;
    const char **base_names;
    const swig_type_info **base;
  };

  // octave_swig_type plays the role of both the shadow class and the class 
  // representation within Octave, since there is no support for classes.
  //
  // These should really be decoupled, with the class support added to Octave
  // and the shadow class given by an m-file script. That would dramatically 
  // reduce the runtime complexity, and be more in line w/ other modules.

  class octave_swig_type:public octave_base_value {
    struct cpp_ptr {
      void *ptr;
      bool destroyed;
      cpp_ptr(void *_ptr):ptr(_ptr), destroyed(false) {
      }};
    typedef std::pair < const swig_type_info *, cpp_ptr > type_ptr_pair;

    mutable swig_module_info *module;

    const swig_type_info *construct_type;	// type of special type object
    std::vector < type_ptr_pair > types;	// our c++ base classes
    int own;			// whether we call c++ destructors when we die

    typedef std::pair < const swig_octave_member *, octave_value > member_value_pair;
    typedef std::map < std::string, member_value_pair > member_map;
    member_map members;
    bool always_static;

    const swig_octave_member *find_member(const swig_type_info *type, const std::string &name) {
      if (!type->clientdata)
	return 0;
      swig_octave_class *c = (swig_octave_class *) type->clientdata;
      const swig_octave_member *m;
      for (m = c->members; m->name; ++m)
	if (m->name == name)
	  return m;
      for (int j = 0; c->base_names[j]; ++j) {
	if (!c->base[j]) {
	  if (!module)
	    module = SWIG_GetModule(0);
	  assert(module);
	  c->base[j] = SWIG_MangledTypeQueryModule(module, module, c->base_names[j]);
	}
	if (!c->base[j])
	  return 0;
	if ((m = find_member(c->base[j], name)))
	  return m;
      }
      return 0;
    }

    member_value_pair *find_member(const std::string &name, bool insert_if_not_found) {
      member_map::iterator it = members.find(name);
      if (it != members.end())
	return &it->second;
      const swig_octave_member *m;
      for (unsigned int j = 0; j < types.size(); ++j)
	if ((m = find_member(types[j].first, name)))
	  return &members.insert(std::make_pair(name, std::make_pair(m, octave_value()))).first->second;
      if (!insert_if_not_found)
	return 0;
      return &members[name];
    }

    const swig_type_info *find_base(const std::string &name, const swig_type_info *base) {
      if (!base) {
	for (unsigned int j = 0; j < types.size(); ++j) {
	  assert(types[j].first->clientdata);
	  swig_octave_class *cj = (swig_octave_class *) types[j].first->clientdata;
	  if (cj->name == name)
	    return types[j].first;
	}
	return 0;
      }
      assert(base->clientdata);
      swig_octave_class *c = (swig_octave_class *) base->clientdata;
      for (int j = 0; c->base_names[j]; ++j) {
	if (!c->base[j]) {
	  if (!module)
	    module = SWIG_GetModule(0);
	  assert(module);
	  c->base[j] = SWIG_MangledTypeQueryModule(module, module, c->base_names[j]);
	}
	if (!c->base[j])
	  return 0;
	assert(c->base[j]->clientdata);
	swig_octave_class *cj = (swig_octave_class *) c->base[j]->clientdata;
	if (cj->name == name)
	  return c->base[j];
      }
      return 0;
    }

    void load_members(const swig_octave_class* c,member_map& out) const {
      for (const swig_octave_member *m = c->members; m->name; ++m) {
	if (out.find(m->name) == out.end())
	  out.insert(std::make_pair(m->name, std::make_pair(m, octave_value())));
      }
      for (int j = 0; c->base_names[j]; ++j) {
	if (!c->base[j]) {
	  if (!module)
	    module = SWIG_GetModule(0);
	  assert(module);
	  c->base[j] = SWIG_MangledTypeQueryModule(module, module, c->base_names[j]);
	}
	if (!c->base[j])
	  continue;
	assert(c->base[j]->clientdata);
	const swig_octave_class *cj =
	  (const swig_octave_class *) c->base[j]->clientdata;
	load_members(cj,out);
      }
    }

    void load_members(member_map& out) const {
      out=members;
      for (unsigned int j = 0; j < types.size(); ++j)
	if (types[j].first->clientdata)
	  load_members((const swig_octave_class *) types[j].first->clientdata, out);
    }

    octave_value_list member_invoke(member_value_pair *m, const octave_value_list &args, int nargout) {
      if (m->second.is_defined())
	return m->second.subsref("(", std::list < octave_value_list > (1, args), nargout);
      else if (m->first && m->first->method)
	return m->first->method(args, nargout);
      error("member not defined or not invocable");
      return octave_value_list();
    }

    bool dispatch_unary_op(const std::string &symbol, octave_value &ret) {
      member_value_pair *m = find_member(symbol, false);
      if (!m || m->first->is_static() || m->first->is_global())
	return false;
      octave_value_list args;
      args.append(as_value());
      octave_value_list argout(member_invoke(m, args, 1));
      if (argout.length() < 1)
	return false;
      ret = argout(0);
      return true;
    }

    bool dispatch_binary_op(const std::string &symbol, const octave_base_value &rhs, octave_value &ret) {
      member_value_pair *m = find_member(symbol, false);
      if (!m || m->first->is_static() || m->first->is_global())
	return false;
      octave_value_list args;
      args.append(as_value());
      args.append(make_value_hack(rhs));
      octave_value_list argout(member_invoke(m, args, 1));
      if (argout.length() < 1)
	return false;
      ret = argout(0);
      return true;
    }

    bool dispatch_index_op(const std::string &symbol, const octave_value_list &rhs, octave_value_list &ret) {
      member_value_pair *m = find_member(symbol, false);
      if (!m || m->first->is_static() || m->first->is_global())
	return false;
      octave_value_list args;
      args.append(as_value());
      args.append(rhs);
      octave_value_list argout(member_invoke(m, args, 1));
      if (argout.length() >= 1)
	ret = argout(0);
      return true;
    }

    octave_value_list member_deref(member_value_pair *m, const octave_value_list &args) {
      if (m->second.is_defined())
	return m->second;
      else if (m->first) {
	if (m->first->get_method)
	  return m->first->get_method(args, 1);
	else if (m->first->method)
	  return octave_value(new octave_builtin(m->first->method));
      }
      error("undefined member");
      return octave_value_list();
    }

    static octave_value make_value_hack(const octave_base_value &x) {
      ((octave_swig_type &) x).count++;
      return octave_value((octave_base_value *) &x);
    }

    octave_swig_type(const octave_swig_type &x);
    octave_swig_type &operator=(const octave_swig_type &rhs);
  public:

    octave_swig_type(void *_ptr = 0, const swig_type_info *_type = 0, int _own = 0,
		     bool _always_static = false)
      :	module(0), construct_type(_ptr ? 0 : _type), own(_own), 
      always_static(_always_static) {
      if (_type || _ptr)
	types.push_back(std::make_pair(_type, _ptr));
#ifdef SWIG_DIRECTORS
      if (_ptr) {
	Swig::Director *d = Swig::get_rtdir(_ptr);
	if (d)
	  Swig::swig_director_set_self(d, this);
      }
#endif
    }

    ~octave_swig_type() {
      if (own) {
	++count;
	for (unsigned int j = 0; j < types.size(); ++j) {
	  if (!types[j].first || !types[j].first->clientdata)
	    continue;
	  swig_octave_class *c = (swig_octave_class *) types[j].first->clientdata;
	  if (c->destructor && !types[j].second.destroyed && types[j].second.ptr) {
	    c->destructor(as_value(), 0);
	  }
	}
      }
#ifdef SWIG_DIRECTORS
      for (unsigned int j = 0; j < types.size(); ++j)
	Swig::erase_rtdir(types[j].second.ptr);
#endif
    }

    dim_vector dims(void) const {
      octave_swig_type *nc_this = const_cast < octave_swig_type *>(this);
      
      // Find the __dims__ method of this object
      member_value_pair *m = nc_this->find_member("__dims__", false);

      if (!m) return dim_vector(1,1);
      
      // Call the __dims__ method of this object
      octave_value_list inarg;
      inarg.append(nc_this->as_value());
      octave_value_list outarg = nc_this->member_invoke(m, inarg, 1);

      // __dims__ should return (at least) one output argument
      if (outarg.length() < 1) return dim_vector(1,1);
      
      octave_value & out = outarg(0);

      // Return value should be cell or matrix of integers
      if (out.is_cell()) {
        const Cell & c=out.cell_value();
        int ndim = c.rows();
        if (ndim==1 && c.columns()!=1) ndim = c.columns();

        dim_vector d;
        d.resize(ndim < 2 ? 2 : ndim);
        d(0) = d(1) = 1;

        // Fill in dim_vector 
        for (int k=0;k<ndim;k++) {
          const octave_value& obj = c(k);
          d.elem(k) = obj.int_value();
          
          // __dims__ should return a cell filled with integers
          if (error_state) return dim_vector(1,1);
        }
        return d;
      } else if (out.is_matrix_type() || out.is_real_nd_array() || out.is_numeric_type() ) {
        if (out.rows()==1 || out.columns()==1) {
           Array<int> a = out.int_vector_value();
           if (error_state) return dim_vector(1,1);
           dim_vector d;
           d.resize(a.numel() < 2 ? 2 : a.numel());
           d(0) = d(1) = 1;
           for (int k=0;k<a.numel();k++) {
              d.elem(k) = a(k);
           }
           return d;
        } else {
          return dim_vector(1,1);
        }
      } else {
        return dim_vector(1,1);
      }
    }

    octave_value as_value() {
      ++count;
      return Swig::swig_value_ref(this);
    }

    void incref() {
      ++count;
    }

    void decref() {
      if (!--count)
	delete this;
    }

    long swig_this() const {
      if (!types.size())
	return (long) this;
      return (long) types[0].second.ptr;
    }
    const char* help_text() const {
      if (!types.size())
	return 0;
      if (!types[0].first->clientdata)
	return 0;
      swig_octave_class *c = (swig_octave_class *) types[0].first->clientdata;
      return c->constructor_doc;
    }

    std::string swig_type_name() const {
      // * need some way to manually name subclasses.
      // * eg optional first arg to subclass(), or named_subclass()
      std::string ret;
      for (unsigned int j = 0; j < types.size(); ++j) {
	if (j)
	  ret += "_";
	if (types[j].first->clientdata) {
	  swig_octave_class *c = (swig_octave_class *) types[j].first->clientdata;
	  ret += c->name;
	} else
	  ret += types[j].first->name;
      }
      return ret;
    }

    void merge(octave_swig_type &rhs) {
      rhs.own = 0;
      for (unsigned int j = 0; j < rhs.types.size(); ++j) {
	assert(!rhs.types[j].second.destroyed);
#ifdef SWIG_DIRECTORS
	Swig::Director *d = Swig::get_rtdir(rhs.types[j].second.ptr);
	if (d)
	  Swig::swig_director_set_self(d, this);
#endif
      }
      types.insert(types.end(), rhs.types.begin(), rhs.types.end());
      members.insert(rhs.members.begin(), rhs.members.end());
      rhs.types.clear();
      rhs.members.clear();
    }

    typedef member_map::const_iterator swig_member_const_iterator;
    swig_member_const_iterator swig_members_begin() { return members.begin(); }
    swig_member_const_iterator swig_members_end() { return members.end(); }

    void *cast(swig_type_info *type, int *_own, int flags) {
      if (_own)
	*_own = own;
      if (flags &SWIG_POINTER_DISOWN)
	own = 0;
      if (!type && types.size())
	return types[0].second.ptr;
      for (unsigned int j = 0; j < types.size(); ++j)
	if (type == types[j].first)
	  return types[j].second.ptr;
      for (unsigned int j = 0; j < types.size(); ++j) {
	swig_cast_info *tc = SWIG_TypeCheck(types[j].first->name, type);
	if (!tc)
	  continue;
	int newmemory = 0;
	void *vptr = SWIG_TypeCast(tc, types[j].second.ptr, &newmemory);
	assert(!newmemory);	// newmemory handling not yet implemented
	return vptr;
      }
      return 0;
    }

    bool is_owned() const {
      return own;
    }

#ifdef SWIG_DIRECTORS
    void director_destroyed(Swig::Director *d) {
      bool found = false;
      for (unsigned int j = 0; j < types.size(); ++j) {
	Swig::Director *dj = Swig::get_rtdir(types[j].second.ptr);
	if (dj == d) {
	  types[j].second.destroyed = true;
	  found = true;
	}
      }
      assert(found);
    }
#endif

    void assign(const std::string &name, const octave_value &ov) {
      members[name] = std::make_pair((const swig_octave_member *) 0, ov);
    }

    void assign(const std::string &name, const swig_octave_member *m) {
      members[name] = std::make_pair(m, octave_value());
    }

    octave_base_value *clone() const {
      // pass-by-value is probably not desired, and is harder;
      // requires calling copy constructors of contained types etc.
      assert(0);
      *(int *) 0 = 0;
      return 0;
    }

    octave_base_value *empty_clone() const {
      return new octave_swig_type();
    }

    bool is_defined() const {
      return true;
    }

    virtual bool is_map() const {
      return true;
    }

    virtual octave_value subsref(const std::string &ops, const std::list < octave_value_list > &idx) {
      octave_value_list ovl = subsref(ops, idx, 1);
      return ovl.length()? ovl(0) : octave_value();
    }

    virtual octave_value_list subsref(const std::string &ops, const std::list < octave_value_list > &idx, int nargout) {
      assert(ops.size() > 0);
      assert(ops.size() == idx.size());

      std::list < octave_value_list >::const_iterator idx_it = idx.begin();
      int skip = 0;
      octave_value_list sub_ovl;

      // constructor invocation
      if (ops[skip] == '(' && construct_type) {
	assert(construct_type->clientdata);
	swig_octave_class *c = (swig_octave_class *) construct_type->clientdata;
	if (!c->constructor) {
	  error("cannot create instance");
	  return octave_value_list();
	}
	octave_value_list args;
	if (c->director)
	  args.append(Swig::swig_value_ref(new octave_swig_type(this, 0, 0)));
	args.append(*idx_it++);
	++skip;
	sub_ovl = c->constructor(args, nargout);
      }
      // member dereference or invocation
      else if (ops[skip] == '.') {
	std::string subname;
	const swig_type_info *base = 0;	// eg, a.base.base_cpp_mem
	for (;;) {
	  octave_value_list subname_ovl(*idx_it++);
	  ++skip;
	  assert(subname_ovl.length() == 1 && subname_ovl(0).is_string());
	  subname = subname_ovl(0).string_value();

	  const swig_type_info *next_base = find_base(subname, base);
	  if (!next_base || skip >= (int) ops.size() || ops[skip] != '.')
	    break;
	  base = next_base;
	}

	member_value_pair tmp, *m = &tmp;
	if (!base || !(m->first = find_member(base, subname)))
	  m = find_member(subname, false);
	if (!m) {
	  error("member not found");
	  return octave_value_list();
	}

	octave_value_list args;
	if (!always_static &&
	    (!m->first || (!m->first->is_static() && !m->first->is_global())))
	  args.append(as_value());
	if (skip < (int) ops.size() && ops[skip] == '(' && 
	    ((m->first && m->first->method) || m->second.is_function() || 
	     m->second.is_function_handle())) {
	  args.append(*idx_it++);
	  ++skip;
	  sub_ovl = member_invoke(m, args, nargout);
	} else {
	  sub_ovl = member_deref(m, args);
	}
      }
      // index operator
      else {
	if (ops[skip] == '(' || ops[skip] == '{') {
	  const char *op_name = ops[skip] == '(' ? "__paren__" : "__brace__";
	  octave_value_list args;
	  args.append(*idx_it++);
	  ++skip;
	  if (!dispatch_index_op(op_name, args, sub_ovl)) {
	    error("error evaluating index operator");
	    return octave_value_list();
	  }
	} else {
	  error("unsupported subsref");
	  return octave_value_list();
	}
      }

      if (skip >= (int) ops.size())
	return sub_ovl;
      if (sub_ovl.length() < 1) {
	error("bad subs ref");
	return octave_value_list();
      }
      return sub_ovl(0).next_subsref(nargout, ops, idx, skip);
    }

    octave_value subsasgn(const std::string &ops, const std::list < octave_value_list > &idx, const octave_value &rhs) {
      assert(ops.size() > 0);
      assert(ops.size() == idx.size());

      std::list < octave_value_list >::const_iterator idx_it = idx.begin();
      int skip = 0;

      if (ops.size() > 1) {
	std::list < octave_value_list >::const_iterator last = idx.end();
	--last;
	std::list < octave_value_list > next_idx(idx.begin(), last);
	octave_value next_ov = subsref(ops.substr(0, ops.size() - 1), next_idx);
	next_ov.subsasgn(ops.substr(ops.size() - 1), std::list < octave_value_list > (1, *last), rhs);
      }

      else if (ops[skip] == '(' || ops[skip] == '{') {
	const char *op_name = ops[skip] == '(' ? "__paren_asgn__" : "__brace_asgn__";
	member_value_pair *m = find_member(op_name, false);
	if (m) {
	  octave_value_list args;
	  args.append(as_value());
	  args.append(*idx_it);
	  args.append(rhs);
	  member_invoke(m, args, 1);
	} else
	  error("%s member not found", op_name);
      }

      else if (ops[skip] == '.') {
	octave_value_list subname_ovl(*idx_it++);
	++skip;
	assert(subname_ovl.length() == 1 &&subname_ovl(0).is_string());
	std::string subname = subname_ovl(0).string_value();

	member_value_pair *m = find_member(subname, true);
	if (!m->first || !m->first->set_method) {
	  m->first = 0;
	  m->second = rhs;
	} else if (m->first->set_method) {
	  octave_value_list args;
	  if (!m->first->is_static() && !m->first->is_global())
	    args.append(as_value());
	  args.append(rhs);
	  m->first->set_method(args, 1);
	} else
	  error("member not assignable");
      } else
	error("unsupported subsasgn");

      return as_value();
    }

    virtual bool is_object() const {
      return true;
    }

    virtual bool is_string() const {
      octave_swig_type *nc_this = const_cast < octave_swig_type *>(this);
      return !!nc_this->find_member("__str__", false);
    }

    virtual std::string string_value(bool force = false) const {
      octave_swig_type *nc_this = const_cast < octave_swig_type *>(this);
      member_value_pair *m = nc_this->find_member("__str__", false);
      if (!m) {
	error("__str__ method not defined");
	return std::string();
      }
      octave_value_list outarg = nc_this->member_invoke(m, octave_value_list(nc_this->as_value()), 1);
      if (outarg.length() < 1 || !outarg(0).is_string()) {
	error("__str__ method did not return a string");
	return std::string();
      }
      return outarg(0).string_value();
    }

#if OCTAVE_API_VERSION_NUMBER >= 40
    virtual octave_map map_value() const {
      return octave_map();
    }
#else
    virtual Octave_map map_value() const {
      return Octave_map();
    }
#endif

    virtual string_vector map_keys() const {
      member_map tmp;
      load_members(tmp);

      string_vector keys(tmp.size());
      int k = 0;
      for (member_map::iterator it = tmp.begin(); it != tmp.end(); ++it)
	keys(k++) = it->first;

      return keys;
    }

    virtual bool save_ascii (std::ostream& os) {
      return true;
    }

    virtual bool load_ascii (std::istream& is) {
      return true;
    }

    virtual bool save_binary (std::ostream& os, bool& save_as_floats) {
      return true;
    }

    virtual bool load_binary (std::istream& is, bool swap, 
			      oct_mach_info::float_format fmt) {
      return true;
    }

#if defined (HAVE_HDF5)
    virtual bool
      save_hdf5 (hid_t loc_id, const char *name, bool save_as_floats) {
      return true;
    }

    virtual bool
      load_hdf5 (hid_t loc_id, const char *name, bool have_h5giterate_bug) {
      return true;
    }
#endif

    virtual octave_value convert_to_str(bool pad = false, bool force = false, char type = '"') const {
      return string_value();
    }

    virtual octave_value convert_to_str_internal(bool pad, bool force, char type) const {
      return string_value();
    }

    static bool dispatch_global_op(const std::string &symbol, const octave_value_list &args, octave_value &ret) {
      // we assume that SWIG_op_prefix-prefixed functions are installed in global namespace
      // (rather than any module namespace).

      octave_function *fcn = is_valid_function(symbol, std::string(), false);
      if (!fcn)
	return false;
      ret = fcn->do_multi_index_op(1, args)(0);
      return true;
    }

    static octave_value dispatch_unary_op(const octave_base_value &x, const char *op_name) {
      octave_swig_type *ost = Swig::swig_value_deref(x);
      assert(ost);

      octave_value ret;
      if (ost->dispatch_unary_op(std::string("__") + op_name + std::string("__"), ret))
	return ret;
      std::string symbol = SWIG_op_prefix + ost->swig_type_name() + "_" + op_name;
      octave_value_list args;
      args.append(make_value_hack(x));
      if (dispatch_global_op(symbol, args, ret))
	return ret;

      error("could not dispatch unary operator");
      return octave_value();
    }

    static octave_value dispatch_binary_op(const octave_base_value &lhs, const octave_base_value &rhs, const char *op_name) {
      octave_swig_type *lhs_ost = Swig::swig_value_deref(lhs);
      octave_swig_type *rhs_ost = Swig::swig_value_deref(rhs);

      octave_value ret;
      if (lhs_ost && lhs_ost->dispatch_binary_op(std::string("__") + op_name + std::string("__"), rhs, ret))
	return ret;
      if (rhs_ost) {
        if (strlen(op_name) == 2  && (op_name[1] == 't' || op_name[1] == 'e')) {
          if (op_name[0] == 'l' && rhs_ost->dispatch_binary_op(std::string("__g") + op_name[1] + std::string("__"), lhs, ret))
            return ret;
          if (op_name[0] == 'g' && rhs_ost->dispatch_binary_op(std::string("__l") + op_name[1] + std::string("__"), lhs, ret))
            return ret;
        }
        if (rhs_ost->dispatch_binary_op(std::string("__r") + op_name + std::string("__"), lhs, ret))
          return ret;
      }

      std::string symbol;
      octave_value_list args;
      args.append(make_value_hack(lhs));
      args.append(make_value_hack(rhs));

      symbol = SWIG_op_prefix;
      symbol += lhs_ost ? lhs_ost->swig_type_name() : lhs.type_name();
      symbol += "_";
      symbol += op_name;
      symbol += "_";
      symbol += rhs_ost ? rhs_ost->swig_type_name() : rhs.type_name();
      if (dispatch_global_op(symbol, args, ret))
	return ret;

      symbol = SWIG_op_prefix;
      symbol += lhs_ost ? lhs_ost->swig_type_name() : lhs.type_name();
      symbol += "_";
      symbol += op_name;
      symbol += "_";
      symbol += "any";
      if (dispatch_global_op(symbol, args, ret))
	return ret;

      symbol = SWIG_op_prefix;
      symbol += "any";
      symbol += "_";
      symbol += op_name;
      symbol += "_";
      symbol += rhs_ost ? rhs_ost->swig_type_name() : rhs.type_name();
      if (dispatch_global_op(symbol, args, ret))
	return ret;

      error("could not dispatch binary operator");
      return octave_value();
    }

    void print(std::ostream &os, bool pr_as_read_syntax = false) const {
      if (is_string()) {
	os << string_value();
	return;
      }

      member_map tmp;
      load_members(tmp);

      indent(os);
      os << "{"; newline(os);
      increment_indent_level();
      for (unsigned int j = 0; j < types.size(); ++j) {
        indent(os);
	if (types[j].first->clientdata) {
	  const swig_octave_class *c = (const swig_octave_class *) types[j].first->clientdata;
	  os << c->name << ", ptr = " << types[j].second.ptr; newline(os);
	} else {
	  os << types[j].first->name << ", ptr = " << types[j].second.ptr; newline(os);
	}
      }
      for (member_map::const_iterator it = tmp.begin(); it != tmp.end(); ++it) {
        indent(os);
	if (it->second.first) {
	  const char *objtype = it->second.first->method ? "method" : "variable";
	  const char *modifier = (it->second.first->flags &1) ? "static " : (it->second.first->flags &2) ? "global " : "";
	  os << it->second.first->name << " (" << modifier << objtype << ")"; newline(os);
	  assert(it->second.first->name == it->first);
	} else {
	  os << it->first; newline(os);
	}
      }
      decrement_indent_level();
      indent(os);
      os << "}"; newline(os);
    }
  };

  // Octave tries hard to preserve pass-by-value semantics. Eg, assignments
  // will call clone() via make_unique() if there is more than one outstanding 
  // reference to the lhs, and forces the clone's reference count to 1 
  // (so you can't just increment your own count and return this).
  //
  // One way to fix this (without modifying Octave) is to add a level of
  // indirection such that clone copies ref-counted pointer and we keep 
  // pass-by-ref semantics (which are more natural/expected for C++ bindings).
  //
  // Supporting both pass-by-{ref,value} and toggling via %feature/option 
  // might be nice.

  class octave_swig_ref:public octave_base_value {
    octave_swig_type *ptr;
  public:
    octave_swig_ref(octave_swig_type *_ptr = 0)
      :ptr(_ptr) { }

    ~octave_swig_ref()
      { if (ptr) ptr->decref(); }

    octave_swig_type *get_ptr() const
      { return ptr; }

    octave_base_value *clone() const
      { if (ptr) ptr->incref(); return new octave_swig_ref(ptr); }

    octave_base_value *empty_clone() const
      { return new octave_swig_ref(0); }

    dim_vector dims(void) const 
      { return ptr->dims(); }

    bool is_defined() const
      { return ptr->is_defined(); }

    virtual bool is_map() const 
      { return ptr->is_map(); }

    virtual octave_value subsref(const std::string &ops, const std::list < octave_value_list > &idx) 
      { return ptr->subsref(ops, idx); }

    virtual octave_value_list subsref(const std::string &ops, const std::list < octave_value_list > &idx, int nargout)
      { return ptr->subsref(ops, idx, nargout); }

    octave_value subsasgn(const std::string &ops, const std::list < octave_value_list > &idx, const octave_value &rhs)
      { return ptr->subsasgn(ops, idx, rhs); }

    virtual bool is_object() const 
      { return ptr->is_object(); }

    virtual bool is_string() const 
      { return ptr->is_string(); }

    virtual std::string string_value(bool force = false) const 
      { return ptr->string_value(force); }

#if OCTAVE_API_VERSION_NUMBER >= 40
    virtual octave_map map_value() const
      { return ptr->map_value(); }
#else
    virtual Octave_map map_value() const
      { return ptr->map_value(); }
#endif

    virtual string_vector map_keys() const
      { return ptr->map_keys(); }

    virtual bool save_ascii (std::ostream& os)
      { return ptr->save_ascii(os); }

    virtual bool load_ascii (std::istream& is)
      { return ptr->load_ascii(is); }

    virtual bool save_binary (std::ostream& os, bool& save_as_floats)
      { return ptr->save_binary(os, save_as_floats); }

    virtual bool load_binary (std::istream& is, bool swap, 
			      oct_mach_info::float_format fmt)
      { return ptr->load_binary(is, swap, fmt); }

#if defined (HAVE_HDF5)
    virtual bool
      save_hdf5 (hid_t loc_id, const char *name, bool save_as_floats)
      { return ptr->save_hdf5(loc_id, name, save_as_floats); }

    virtual bool
      load_hdf5 (hid_t loc_id, const char *name, bool have_h5giterate_bug)
      { return ptr->load_hdf5(loc_id, name, have_h5giterate_bug); }
#endif

    virtual octave_value convert_to_str(bool pad = false, bool force = false, char type = '"') const
      { return ptr->convert_to_str(pad, force, type); }

    virtual octave_value convert_to_str_internal(bool pad, bool force, char type) const
      { return ptr->convert_to_str_internal(pad, force, type); }

    void print(std::ostream &os, bool pr_as_read_syntax = false) const
      { return ptr->print(os, pr_as_read_syntax); }

  private:
    DECLARE_OCTAVE_ALLOCATOR;
    DECLARE_OV_TYPEID_FUNCTIONS_AND_DATA;
  };
  DEFINE_OCTAVE_ALLOCATOR(octave_swig_ref);
  DEFINE_OV_TYPEID_FUNCTIONS_AND_DATA(octave_swig_ref, "swig_ref", "swig_ref");

  class octave_swig_packed:public octave_base_value {
    swig_type_info *type;
    std::vector < char > buf;
  public:

    octave_swig_packed(swig_type_info *_type = 0, const void *_buf = 0, size_t _buf_len = 0)
      :	type(_type), buf((const char*)_buf, (const char*)_buf + _buf_len) {
    }

    bool copy(swig_type_info *outtype, void *ptr, size_t sz) const {
      if (outtype && outtype != type)
	return false;
      assert(sz <= buf.size());
      std::copy(buf.begin(), buf.begin()+sz, (char*)ptr);
      return true;
    }

    octave_base_value *clone() const {
      return new octave_swig_packed(*this);
    }

    octave_base_value *empty_clone() const {
      return new octave_swig_packed();
    }

    bool is_defined() const {
      return true;
    }

    void print(std::ostream &os, bool pr_as_read_syntax = false) const {
      indent(os);
      os << "swig packed type: name = " << (type ? type->name : std::string()) << ", len = " << buf.size(); newline(os);
    }


    virtual bool save_ascii (std::ostream& os) {
      return true;
    }

    virtual bool load_ascii (std::istream& is) {
      return true;
    }

    virtual bool save_binary (std::ostream& os, bool& save_as_floats) {
      return true;
    }

    virtual bool load_binary (std::istream& is, bool swap, 
			      oct_mach_info::float_format fmt) {
      return true;
    }

#if defined (HAVE_HDF5)
    virtual bool
      save_hdf5 (hid_t loc_id, const char *name, bool save_as_floats) {
      return true;
    }

    virtual bool
      load_hdf5 (hid_t loc_id, const char *name, bool have_h5giterate_bug) {
      return true;
    }
#endif

  private:
    DECLARE_OCTAVE_ALLOCATOR;
    DECLARE_OV_TYPEID_FUNCTIONS_AND_DATA;
  };
  DEFINE_OCTAVE_ALLOCATOR(octave_swig_packed);
  DEFINE_OV_TYPEID_FUNCTIONS_AND_DATA(octave_swig_packed, "swig_packed", "swig_packed");

  static octave_value_list octave_set_immutable(const octave_value_list &args, int nargout) {
    error("attempt to set immutable member variable");
    return octave_value_list();
  }

  struct octave_value_ref {
    const octave_value_list &ovl;
    int j;

    octave_value_ref(const octave_value_list &_ovl, int _j)
      :ovl(_ovl), j(_j) { }

    operator  octave_value() const {
      return ovl(j);
    }

    octave_value operator*() const {
      return ovl(j);
    }
  };


namespace Swig {

  SWIGRUNTIME octave_base_value *swig_value_ref(octave_swig_type *ost) {
    return new octave_swig_ref(ost);
  }

  SWIGRUNTIME octave_swig_type *swig_value_deref(octave_value ov) {
    if (ov.is_cell() && ov.rows() == 1 && ov.columns() == 1)
      ov = ov.cell_value()(0);
    return swig_value_deref(*ov.internal_rep());
  }

  SWIGRUNTIME octave_swig_type *swig_value_deref(const octave_base_value &ov) {
    if (ov.type_id() != octave_swig_ref::static_type_id())
      return 0;
    const octave_swig_ref *osr = static_cast < const octave_swig_ref *>(&ov);
    return osr->get_ptr();
  }

}


#define swig_unary_op(name) \
SWIGRUNTIME octave_value swig_unary_op_##name(const octave_base_value &x) { \
  return octave_swig_type::dispatch_unary_op(x,#name); \
}
#define swig_binary_op(name) \
SWIGRUNTIME octave_value swig_binary_op_##name(const octave_base_value&lhs,const octave_base_value &rhs) { \
  return octave_swig_type::dispatch_binary_op(lhs,rhs,#name); \
}
#define swigreg_unary_op(name) \
if (!octave_value_typeinfo::lookup_unary_op(octave_value::op_##name,tid)) \
octave_value_typeinfo::register_unary_op(octave_value::op_##name,tid,swig_unary_op_##name);
#define swigreg_binary_op(name) \
if (!octave_value_typeinfo::lookup_binary_op(octave_value::op_##name,tid1,tid2)) \
octave_value_typeinfo::register_binary_op(octave_value::op_##name,tid1,tid2,swig_binary_op_##name);

  swig_unary_op(not);
  swig_unary_op(uplus);
  swig_unary_op(uminus);
  swig_unary_op(transpose);
  swig_unary_op(hermitian);
  swig_unary_op(incr);
  swig_unary_op(decr);

  swig_binary_op(add);
  swig_binary_op(sub);
  swig_binary_op(mul);
  swig_binary_op(div);
  swig_binary_op(pow);
  swig_binary_op(ldiv);
  swig_binary_op(lshift);
  swig_binary_op(rshift);
  swig_binary_op(lt);
  swig_binary_op(le);
  swig_binary_op(eq);
  swig_binary_op(ge);
  swig_binary_op(gt);
  swig_binary_op(ne);
  swig_binary_op(el_mul);
  swig_binary_op(el_div);
  swig_binary_op(el_pow);
  swig_binary_op(el_ldiv);
  swig_binary_op(el_and);
  swig_binary_op(el_or);

  SWIGRUNTIME void SWIG_InstallUnaryOps(int tid) {
    swigreg_unary_op(not);
    swigreg_unary_op(uplus);
    swigreg_unary_op(uminus);
    swigreg_unary_op(transpose);
    swigreg_unary_op(hermitian);
    swigreg_unary_op(incr);
    swigreg_unary_op(decr);
  }
  SWIGRUNTIME void SWIG_InstallBinaryOps(int tid1, int tid2) {
    swigreg_binary_op(add);
    swigreg_binary_op(sub);
    swigreg_binary_op(mul);
    swigreg_binary_op(div);
    swigreg_binary_op(pow);
    swigreg_binary_op(ldiv);
    swigreg_binary_op(lshift);
    swigreg_binary_op(rshift);
    swigreg_binary_op(lt);
    swigreg_binary_op(le);
    swigreg_binary_op(eq);
    swigreg_binary_op(ge);
    swigreg_binary_op(gt);
    swigreg_binary_op(ne);
    swigreg_binary_op(el_mul);
    swigreg_binary_op(el_div);
    swigreg_binary_op(el_pow);
    swigreg_binary_op(el_ldiv);
    swigreg_binary_op(el_and);
    swigreg_binary_op(el_or);
  }
  SWIGRUNTIME void SWIG_InstallOps(int tid) {
    // here we assume that tid are conseq integers increasing from zero, and 
    // that our tid is the last one. might be better to have explicit string 
    // list of types we should bind to, and use lookup_type to resolve their tid.

    SWIG_InstallUnaryOps(tid);
    SWIG_InstallBinaryOps(tid, tid);
    for (int j = 0; j < tid; ++j) {
      SWIG_InstallBinaryOps(j, tid);
      SWIG_InstallBinaryOps(tid, j);
    }
  }

SWIGRUNTIME octave_value SWIG_Octave_NewPointerObj(void *ptr, swig_type_info *type, int flags) {
  int own = (flags &SWIG_POINTER_OWN) ? SWIG_POINTER_OWN : 0;

#ifdef SWIG_DIRECTORS
  Swig::Director *d = Swig::get_rtdir(ptr);
  if (d && Swig::swig_director_get_self(d))
    return Swig::swig_director_get_self(d)->as_value();
#endif
  return Swig::swig_value_ref(new octave_swig_type(ptr, type, own));
}

SWIGRUNTIME int SWIG_Octave_ConvertPtrAndOwn(octave_value ov, void **ptr, swig_type_info *type, int flags, int *own) {
  if (ov.is_cell() && ov.rows() == 1 && ov.columns() == 1)
    ov = ov.cell_value()(0);
  if (!ov.is_defined() ||
      (ov.is_matrix_type() && ov.rows() == 0 && ov.columns() == 0) ) {
    if (ptr)
      *ptr = 0;
    return SWIG_OK;
  }
  if (ov.type_id() != octave_swig_ref::static_type_id())
    return SWIG_ERROR;
  octave_swig_ref *osr = static_cast < octave_swig_ref *>(ov.internal_rep());
  octave_swig_type *ost = osr->get_ptr();
  void *vptr = ost->cast(type, own, flags);
  if (!vptr)
    return SWIG_ERROR;
  if (ptr)
    *ptr = vptr;
  return SWIG_OK;
}

SWIGRUNTIME octave_value SWIG_Octave_NewPackedObj(void *ptr, size_t sz, swig_type_info *type) {
  return new octave_swig_packed(type, (char *) ptr, sz);
}

SWIGRUNTIME int SWIG_Octave_ConvertPacked(const octave_value &ov, void *ptr, size_t sz, swig_type_info *type) {
  if (!ov.is_defined())
    return SWIG_ERROR;
  if (ov.type_id() != octave_swig_packed::static_type_id())
    return SWIG_ERROR;
  octave_swig_packed *ost = static_cast < octave_swig_packed *>(ov.internal_rep());
  return ost->copy(type, (char *) ptr, sz) ? SWIG_OK : SWIG_ERROR;
}

void SWIG_Octave_SetConstant(octave_swig_type *module_ns, const std::string &name, const octave_value &ov) {
  module_ns->assign(name, ov);
}

SWIGRUNTIMEINLINE octave_value SWIG_Octave_GetGlobalValue(std::string name) {
  return get_global_value(name, true);
}

SWIGRUNTIME void SWIG_Octave_SetGlobalValue(std::string name, const octave_value& value) {
  // It is critical that a newly-allocated octave_value is passed to set_global_value(),
  // since it and the Octave symbol table take references to the values assigned to it.
  // If we were to pass a reference to 'value' to set_global_value(), then the Octave
  // symbol table would hold a reference to a variable owned by the SWIG .oct module.
  // Both will think that they own the reference (since the .oct module is dynamically
  // loaded, it appears to have its own C++ runtime), and so they will both try to
  // de-allocate the octave_value on exit, resulting in a double-free or seg-fault.
  // This is prevented by giving Octave its own heap-allocated copy of 'value'.
  octave_value *pov = new octave_value(value);
  set_global_value(name, *pov);
}

SWIGRUNTIME void SWIG_Octave_LinkGlobalValue(std::string name) {
#if OCTAVE_API_VERSION_NUMBER < 37
  link_to_global_variable(curr_sym_tab->lookup(name, true));
#else
  symbol_table::varref(name);
  symbol_table::mark_global(name);
#endif
}

SWIGRUNTIME swig_module_info *SWIG_Octave_GetModule(void *clientdata) {
  octave_value ov = SWIG_Octave_GetGlobalValue("__SWIG_MODULE__" SWIG_TYPE_TABLE_NAME SWIG_RUNTIME_VERSION);
  if (!ov.is_defined() ||
      ov.type_id() != octave_swig_packed::static_type_id())
    return 0;
  const octave_swig_packed* osp = 
    static_cast < const octave_swig_packed *> (ov.internal_rep());
  swig_module_info *pointer = 0;
  osp->copy(0, &pointer, sizeof(swig_module_info *));
  return pointer;
}

SWIGRUNTIME void SWIG_Octave_SetModule(void *clientdata, swig_module_info *pointer) {
  octave_value ov = new octave_swig_packed(0, &pointer, sizeof(swig_module_info *));
  SWIG_Octave_SetGlobalValue("__SWIG_MODULE__" SWIG_TYPE_TABLE_NAME SWIG_RUNTIME_VERSION, ov);
}



#define SWIG_exception_fail(code, msg) do { SWIG_Error(code, msg); SWIG_fail; } while(0) 

#define SWIG_contract_assert(expr, msg) if (!(expr)) { SWIG_Error(SWIG_RuntimeError, msg); SWIG_fail; } else 



  #define SWIG_exception(code, msg) do { SWIG_Error(code, msg); SWIG_fail;; } while(0) 


/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_allocator_type swig_types[0]
#define SWIGTYPE_p_boost__unordered_mapT_int_ccmc__GeneralFileReader_p_t swig_types[1]
#define SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Interpolator_p_t swig_types[2]
#define SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Kameleon_p_t swig_types[3]
#define SWIGTYPE_p_boost__unordered_mapT_int_ccmc__TimeInterpolator_p_t swig_types[4]
#define SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Tracer_p_t swig_types[5]
#define SWIGTYPE_p_ccmc__Attribute swig_types[6]
#define SWIGTYPE_p_ccmc__BATSRUS swig_types[7]
#define SWIGTYPE_p_ccmc__BATSRUSInterpolator swig_types[8]
#define SWIGTYPE_p_ccmc__CDFFileReader swig_types[9]
#define SWIGTYPE_p_ccmc__ENLIL swig_types[10]
#define SWIGTYPE_p_ccmc__ENLILInterpolator swig_types[11]
#define SWIGTYPE_p_ccmc__Fieldline swig_types[12]
#define SWIGTYPE_p_ccmc__FileReader swig_types[13]
#define SWIGTYPE_p_ccmc__GeneralFileReader swig_types[14]
#define SWIGTYPE_p_ccmc__Interpolator swig_types[15]
#define SWIGTYPE_p_ccmc__Kameleon swig_types[16]
#define SWIGTYPE_p_ccmc__KameleonInterpolator swig_types[17]
#define SWIGTYPE_p_ccmc__MAS swig_types[18]
#define SWIGTYPE_p_ccmc__MASInterpolator swig_types[19]
#define SWIGTYPE_p_ccmc__Model swig_types[20]
#define SWIGTYPE_p_ccmc__OpenGGCM swig_types[21]
#define SWIGTYPE_p_ccmc__OpenGGCMInterpolator swig_types[22]
#define SWIGTYPE_p_ccmc__Point3f swig_types[23]
#define SWIGTYPE_p_ccmc__Position swig_types[24]
#define SWIGTYPE_p_ccmc__SWMFIono swig_types[25]
#define SWIGTYPE_p_ccmc__SWMFIonoInterpolator swig_types[26]
#define SWIGTYPE_p_ccmc__Time swig_types[27]
#define SWIGTYPE_p_ccmc__Tracer swig_types[28]
#define SWIGTYPE_p_char swig_types[29]
#define SWIGTYPE_p_difference_type swig_types[30]
#define SWIGTYPE_p_float swig_types[31]
#define SWIGTYPE_p_int swig_types[32]
#define SWIGTYPE_p_long swig_types[33]
#define SWIGTYPE_p_size_type swig_types[34]
#define SWIGTYPE_p_std__allocatorT_ccmc__Fieldline_t swig_types[35]
#define SWIGTYPE_p_std__allocatorT_ccmc__Point3f_t swig_types[36]
#define SWIGTYPE_p_std__allocatorT_float_t swig_types[37]
#define SWIGTYPE_p_std__allocatorT_int_t swig_types[38]
#define SWIGTYPE_p_std__allocatorT_std__string_t swig_types[39]
#define SWIGTYPE_p_std__ostream swig_types[40]
#define SWIGTYPE_p_std__string swig_types[41]
#define SWIGTYPE_p_std__vectorT_ccmc__Fieldline_std__allocatorT_ccmc__Fieldline_t_t swig_types[42]
#define SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t swig_types[43]
#define SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t swig_types[44]
#define SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t swig_types[45]
#define SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t swig_types[46]
#define SWIGTYPE_p_swig__OctSwigIterator swig_types[47]
#define SWIGTYPE_p_value_type swig_types[48]
static swig_type_info *swig_types[50];
static swig_module_info swig_module = {swig_types, 49, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */


#define SWIGVERSION 0x020009 
#define SWIG_VERSION SWIGVERSION


#define SWIG_as_voidptr(a) (void *)((const void *)(a)) 
#define SWIG_as_voidptrptr(a) ((void)SWIG_as_voidptr(*a),(void**)(a)) 


#include <stdexcept>


#include <string>


#include <iostream>


#include <stdexcept>


#if defined(__GNUC__)
#  if __GNUC__ == 2 && __GNUC_MINOR <= 96
#     define SWIG_STD_NOMODERN_STL
#  endif
#endif


#include <string>
#include <stdexcept>
#include <stddef.h>


  #include <stddef.h>

  
namespace swig {
  struct stop_iteration {
  };

  struct OctSwigIterator {
  private:
    octave_value _seq;

  protected:
    OctSwigIterator(octave_value seq) : _seq(seq)
    {
    }
      
  public:
    virtual ~OctSwigIterator() {}

    virtual octave_value value() const = 0;

    virtual OctSwigIterator *incr(size_t n = 1) = 0;

    virtual OctSwigIterator *decr(size_t n = 1)
    {
      throw stop_iteration();
    }

    virtual ptrdiff_t distance(const OctSwigIterator &x) const
    {
      throw std::invalid_argument("operation not supported");
    }

    virtual bool equal (const OctSwigIterator &x) const
    {
      throw std::invalid_argument("operation not supported");
    }
    
    virtual OctSwigIterator *copy() const = 0;

    octave_value next()
    {
      octave_value obj = value();
      incr();
      return obj;
    }

    octave_value previous()
    {
      decr();
      return value();
    }

    OctSwigIterator *advance(ptrdiff_t n)
    {
      return  (n > 0) ?  incr(n) : decr(-n);
    }
      
    bool operator == (const OctSwigIterator& x)  const
    {
      return equal(x);
    }
      
    bool operator != (const OctSwigIterator& x) const
    {
      return ! operator==(x);
    }

    OctSwigIterator* operator ++ () {
      incr();
      return this;
    }

    OctSwigIterator* operator -- () {
      decr();
      return this;
    }
      
    OctSwigIterator* operator + (ptrdiff_t n) const
    {
      return copy()->advance(n);
    }

    OctSwigIterator* operator - (ptrdiff_t n) const
    {
      return copy()->advance(-n);
    }
      
    ptrdiff_t operator - (const OctSwigIterator& x) const
    {
      return x.distance(*this);
    }
      
    static swig_type_info* descriptor() {
      static int init = 0;
      static swig_type_info* desc = 0;
      if (!init) {
	desc = SWIG_TypeQuery("swig::OctSwigIterator *");
	init = 1;
      }	
      return desc;
    }    
  };
}


  SWIGINTERN int SWIG_AsVal_unsigned_SS_long (const octave_value& ov, unsigned long* val)
    {
      if (!ov.is_scalar_type())
	return SWIG_TypeError;
      if (ov.is_complex_scalar())
	return SWIG_TypeError;
      if (ov.is_double_type()||ov.is_single_type()) {
	double v=ov.double_value();
	if (v<0)
	  return SWIG_OverflowError;  
	if (v!=floor(v))
	  return SWIG_TypeError;
      }
      if (ov.is_int8_type()||ov.is_int16_type()||
	  ov.is_int32_type()) {
	long v=ov.long_value();
	if (v<0)
	  return SWIG_OverflowError;  
      }
      if (ov.is_int64_type()) {
	long long v=ov.int64_scalar_value().value();
	if (v<0)
	  return SWIG_OverflowError;  
      }
      if (val)
	*val = ov.ulong_value();
      return SWIG_OK;
    }


SWIGINTERNINLINE int
SWIG_AsVal_size_t (octave_value obj, size_t *val)
{
  unsigned long v;
  int res = SWIG_AsVal_unsigned_SS_long (obj, val ? &v : 0);
  if (SWIG_IsOK(res) && val) *val = (size_t)(v);
  return res;
}


  SWIGINTERNINLINE octave_value SWIG_From_long    (long value)
    {    
      return octave_value(value);
    }


SWIGINTERNINLINE octave_value
SWIG_From_ptrdiff_t  (ptrdiff_t value)
{    
  return SWIG_From_long  ((long)(value));
}


SWIGINTERNINLINE octave_value
  SWIG_From_bool  (bool value)
{
  return octave_value(value);
}


  SWIGINTERN int SWIG_AsVal_long (const octave_value& ov, long* val)
    {
      if (!ov.is_scalar_type())
	return SWIG_TypeError;
      if (ov.is_complex_scalar())
	return SWIG_TypeError;
      if (ov.is_double_type()||ov.is_single_type()) {
	double v=ov.double_value();
	if (v!=floor(v))
	  return SWIG_TypeError;
      }
      if (val)
	*val = ov.long_value();
      return SWIG_OK;
    }


SWIGINTERNINLINE int
SWIG_AsVal_ptrdiff_t (octave_value obj, ptrdiff_t *val)
{
  long v;
  int res = SWIG_AsVal_long (obj, val ? &v : 0);
  if (SWIG_IsOK(res) && val) *val = (ptrdiff_t)(v);
  return res;
}


#include <stdexcept>


#include <algorithm>


#include <vector>


#include <ccmc/FileReader.h>
#include <ccmc/GeneralFileReader.h>
#include <ccmc/CDFFileReader.h>
#include <ccmc/Kameleon.h>
#include <ccmc/Interpolator.h>
#include <ccmc/KameleonInterpolator.h>
#include <ccmc/Tracer.h>
#include <ccmc/Fieldline.h>
#include <ccmc/Point3f.h>
#include <ccmc/Attribute.h>
#include <ccmc/Model.h>
#include <ccmc/BATSRUS.h>
#include <ccmc/ENLIL.h>
#include <ccmc/MAS.h>
#include <ccmc/OpenGGCM.h>
#include <ccmc/SWMFIono.h>
#include <ccmc/BATSRUSInterpolator.h>
#include <ccmc/ENLILInterpolator.h>
#include <ccmc/MASInterpolator.h>
#include <ccmc/OpenGGCMInterpolator.h>
#include <ccmc/SWMFIonoInterpolator.h>
#include <ccmc/CCMCTime.h>
using namespace std;
using namespace ccmc;




SWIGINTERN int
SWIG_AsCharPtrAndSize(octave_value ov, char** cptr, size_t* psize, int *alloc)
{
  if (ov.is_cell() && ov.rows() == 1 && ov.columns() == 1)
    ov = ov.cell_value()(0);
  if (!ov.is_string())
    return SWIG_TypeError;
  
  std::string str=ov.string_value();
  size_t len=str.size();
  char* cstr=(char*)str.c_str();
  if (alloc) {
    *cptr = (char*)(memcpy((new char[len + 1]), cstr, sizeof(char)*(len + 1)));
    *alloc = SWIG_NEWOBJ;
  } else if (cptr)
    *cptr = cstr;
  if (psize)
    *psize = len + 1;
  return SWIG_OK;
}


SWIGINTERN int
SWIG_AsPtr_std_string (octave_value obj, std::string **val) 
{
  char* buf = 0 ; size_t size = 0; int alloc = SWIG_OLDOBJ;
  if (SWIG_IsOK((SWIG_AsCharPtrAndSize(obj, &buf, &size, &alloc)))) {
    if (buf) {
      if (val) *val = new std::string(buf, size - 1);
      if (alloc == SWIG_NEWOBJ) delete[] buf;
      return SWIG_NEWOBJ;
    } else {
      if (val) *val = 0;
      return SWIG_OLDOBJ;
    }
  } else {
    static int init = 0;
    static swig_type_info* descriptor = 0;
    if (!init) {
      descriptor = SWIG_TypeQuery("std::string" " *");
      init = 1;
    }
    if (descriptor) {
      std::string *vptr;
      int res = SWIG_ConvertPtr(obj, (void**)&vptr, descriptor, 0);
      if (SWIG_IsOK(res) && val) *val = vptr;
      return res;
    }
  }
  return SWIG_ERROR;
}


SWIGINTERN int
SWIG_AsVal_bool (const octave_value& ov, bool *val)
{
  if (!ov.is_bool_type())
    return SWIG_ERROR;
  if (val)
    *val = ov.bool_value();
  return SWIG_OK;
}


  SWIGINTERNINLINE octave_value SWIG_From_double    (double value)
    {    
      return octave_value(value);
    }


SWIGINTERNINLINE octave_value
SWIG_From_float  (float value)
{    
  return SWIG_From_double  (value);
}


SWIGINTERNINLINE octave_value
SWIG_From_int  (int value)
{    
  return SWIG_From_long  (value);
}


SWIGINTERN swig_type_info*
SWIG_pchar_descriptor(void)
{
  static int init = 0;
  static swig_type_info* info = 0;
  if (!init) {
    info = SWIG_TypeQuery("_p_char");
    init = 1;
  }
  return info;
}


SWIGINTERNINLINE octave_value
SWIG_FromCharPtrAndSize(const char* carray, size_t size)
{
  return std::string(carray,carray+size);
}


SWIGINTERNINLINE octave_value
SWIG_From_std_string  (const std::string& s)
{
  return SWIG_FromCharPtrAndSize(s.data(), s.size());
}


SWIGINTERN int
SWIG_AsCharArray(octave_value obj, char *val, size_t size)
{ 
  char* cptr = 0; size_t csize = 0; int alloc = SWIG_OLDOBJ;
  int res = SWIG_AsCharPtrAndSize(obj, &cptr, &csize, &alloc);
  if (SWIG_IsOK(res)) {
    if ((csize == size + 1) && cptr && !(cptr[csize-1])) --csize;
    if (csize <= size) {
      if (val) {
	if (csize) memcpy(val, cptr, csize*sizeof(char));
	if (csize < size) memset(val + csize, 0, (size - csize)*sizeof(char));
      }
      if (alloc == SWIG_NEWOBJ) {
	delete[] cptr;
	res = SWIG_DelNewMask(res);
      }      
      return res;
    }
    if (alloc == SWIG_NEWOBJ) delete[] cptr;
  }
  return SWIG_TypeError;
}


  SWIGINTERN int SWIG_AsVal_double (const octave_value& ov, double* val)
    {
      if (!ov.is_scalar_type())
	return SWIG_TypeError;
      if (ov.is_complex_scalar())
	return SWIG_TypeError;
      if (val)
	*val = ov.double_value();
      return SWIG_OK;
    }


#include <float.h>


SWIGINTERN int
SWIG_AsVal_float (octave_value obj, float *val)
{
  double v;
  int res = SWIG_AsVal_double (obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v < -FLT_MAX || v > FLT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = (float)(v);
    }
  }  
  return res;
}





#include <limits.h>
#if !defined(SWIG_NO_LLONG_MAX)
# if !defined(LLONG_MAX) && defined(__GNUC__) && defined (__LONG_LONG_MAX__)
#   define LLONG_MAX __LONG_LONG_MAX__
#   define LLONG_MIN (-LLONG_MAX - 1LL)
#   define ULLONG_MAX (LLONG_MAX * 2ULL + 1ULL)
# endif
#endif


SWIGINTERN int
SWIG_AsVal_int (octave_value obj, int *val)
{
  long v;
  int res = SWIG_AsVal_long (obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v < INT_MIN || v > INT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = (int)(v);
    }
  }  
  return res;
}


SWIGINTERNINLINE octave_value
SWIG_From_short  (short value)
{    
  return SWIG_From_long  (value);
}


SWIGINTERN int
SWIG_AsVal_short (octave_value obj, short *val)
{
  long v;
  int res = SWIG_AsVal_long (obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v < SHRT_MIN || v > SHRT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = (short)(v);
    }
  }  
  return res;
}


namespace swig {  
  template <class Type>
  struct noconst_traits {
    typedef Type noconst_type;
  };

  template <class Type>
  struct noconst_traits<const Type> {
    typedef Type noconst_type;
  };

  /*
    type categories
  */
  struct pointer_category { };  
  struct value_category { };

  /*
    General traits that provides type_name and type_info
  */
  template <class Type> struct traits { };

  template <class Type>
  inline const char* type_name() {
    return traits<typename noconst_traits<Type >::noconst_type >::type_name();
  }

  template <class Type> 
  struct traits_info {
    static swig_type_info *type_query(std::string name) {
      name += " *";
      return SWIG_TypeQuery(name.c_str());
    }    
    static swig_type_info *type_info() {
      static swig_type_info *info = type_query(type_name<Type>());
      return info;
    }
  };

  template <class Type>
  inline swig_type_info *type_info() {
    return traits_info<Type>::type_info();
  }

  /*
    Partial specialization for pointers
  */
  template <class Type> struct traits <Type *> {
    typedef pointer_category category;
    static std::string make_ptr_name(const char* name) {
      std::string ptrname = name;
      ptrname += " *";
      return ptrname;
    }    
    static const char* type_name() {
      static std::string name = make_ptr_name(swig::type_name<Type>());
      return name.c_str();
    }
  };

  template <class Type, class Category> 
  struct traits_as { };
 
  template <class Type, class Category> 
  struct traits_check { };

}


namespace swig {  
// Traits that provides the from method
  template <class Type> struct traits_from_ptr {
    static octave_value from(Type *val, int owner = 0) {
      return SWIG_NewPointerObj(val, type_info<Type>(), owner);
    }
  };

  template <class Type> struct traits_from {
    static octave_value from(const Type& val) {
      return traits_from_ptr<Type>::from(new Type(val), 1);
    }
  };

  template <class Type> struct traits_from<Type *> {
    static octave_value from(Type* val) {
      return traits_from_ptr<Type>::from(val, 0);
    }
  };

  template <class Type> struct traits_from<const Type *> {
    static octave_value from(const Type* val) {
      return traits_from_ptr<Type>::from(const_cast<Type*>(val), 0);
    }
  };


  template <class Type>
  inline octave_value from(const Type& val) {
    return traits_from<Type>::from(val);
  }

  template <class Type>
  inline octave_value from_ptr(Type* val, int owner) {
    return traits_from_ptr<Type>::from(val, owner);
  }

    // Traits that provides the asval/as/check method
  template <class Type>
  struct traits_asptr {   
    static int asptr(const octave_value& obj, Type **val) {
      Type *p;
      int res = SWIG_ConvertPtr(obj, (void**)&p, type_info<Type>(), 0);
      if (SWIG_IsOK(res)) {
	if (val) *val = p;
      }
      return res;
    }
  }; 

  template <class Type>
  inline int asptr(const octave_value& obj, Type **vptr) {
    return traits_asptr<Type>::asptr(obj, vptr);
  }

  template <class Type> 
  struct traits_asval {
    static int asval(const octave_value& obj, Type *val) {
      if (val) {
	Type *p = 0;
	int res = traits_asptr<Type>::asptr(obj, &p);
	if (!SWIG_IsOK(res)) return res;	
	if (p) {
	  typedef typename noconst_traits<Type>::noconst_type noconst_type;
	  *(const_cast<noconst_type*>(val)) = *p;
	  if (SWIG_IsNewObj(res)){
	    delete p;
	    res = SWIG_DelNewMask(res);
	  }
	  return res;
	} else {
	  return SWIG_ERROR;
	}
      } else {
	return traits_asptr<Type>::asptr(obj, (Type **)(0));
      }
    }
  };

  template <class Type> struct traits_asval<Type*> {
    static int asval(const octave_value& obj, Type **val) {
      if (val) {
        typedef typename noconst_traits<Type>::noconst_type noconst_type;
        noconst_type *p = 0;
        int res = traits_asptr<noconst_type>::asptr(obj,  &p);
        if (SWIG_IsOK(res)) {
          *(const_cast<noconst_type**>(val)) = p;
	}
	return res;
      } else {
	return traits_asptr<Type>::asptr(obj, (Type **)(0));
      }
    }
  };
  
  template <class Type>
  inline int asval(const octave_value& obj, Type *val) {
    return traits_asval<Type>::asval(obj, val);
  }

  template <class Type> 
  struct traits_as<Type, value_category> {
    static Type as(const octave_value& obj, bool throw_error) {
      Type v;
      int res = asval(obj, &v);
      if (!obj.is_defined() || !SWIG_IsOK(res)) {
	if (!Octave_Error_Occurred()) {
	  SWIG_Error(SWIG_TypeError,  swig::type_name<Type>());
	}
	if (throw_error) throw std::invalid_argument("bad type");
      }
      return v;
    }
  };

  template <class Type> 
  struct traits_as<Type, pointer_category> {
    static Type as(const octave_value& obj, bool throw_error) {
      Type *v = 0;      
      int res = traits_asptr<Type>::asptr(obj, &v);
      if (SWIG_IsOK(res) && v) {
	if (SWIG_IsNewObj(res)) {
	  Type r(*v);
	  delete v;
	  return r;
	} else {
	  return *v;
	}
      } else {
	// Uninitialized return value, no Type() constructor required.
	static Type *v_def = (Type*) malloc(sizeof(Type));
	if (!Octave_Error_Occurred()) {
	  SWIG_Error(SWIG_TypeError,  swig::type_name<Type>());
	}
	if (throw_error) throw std::invalid_argument("bad type");
	memset(v_def,0,sizeof(Type));
	return *v_def;
      }
    }
  };

  template <class Type> 
  struct traits_as<Type*, pointer_category> {
    static Type* as(const octave_value& obj, bool throw_error) {
      Type *v = 0;      
      int res = traits_asptr<Type>::asptr(obj, &v);
      if (SWIG_IsOK(res)) {
	return v;
      } else {
	if (!Octave_Error_Occurred()) {
	  SWIG_Error(SWIG_TypeError,  swig::type_name<Type>());
	}
	if (throw_error) throw std::invalid_argument("bad type");
	return 0;
      }
    }
  };
    
  template <class Type>
  inline Type as(const octave_value& obj, bool te = false) {
    return traits_as<Type, typename traits<Type>::category>::as(obj, te);
  }

  template <class Type> 
  struct traits_check<Type, value_category> {
    static bool check(const octave_value& obj) {
      int res = asval(obj, (Type *)(0));
      return SWIG_IsOK(res) ? true : false;
    }
  };

  template <class Type> 
  struct traits_check<Type, pointer_category> {
    static bool check(const octave_value& obj) {
      int res = asptr(obj, (Type **)(0));
      return SWIG_IsOK(res) ? true : false;
    }
  };

  template <class Type>
  inline bool check(const octave_value& obj) {
    return traits_check<Type, typename traits<Type>::category>::check(obj);
  }
}


#include <functional>

namespace std {
  template <>
  struct less <octave_value>: public binary_function<octave_value, octave_value, bool>
  {
    bool
    operator()(const octave_value& v, const octave_value& w) const
    { 
      octave_value res = do_binary_op(octave_value::op_le,v,w);
      return res.is_true();
    }
  };
}

namespace swig {
  inline size_t
  check_index(ptrdiff_t i, size_t size, bool insert = false) {
    if ( i < 0 ) {
      if ((size_t) (-i) <= size)
	return (size_t) (i + size);
    } else if ( (size_t) i < size ) {
      return (size_t) i;
    } else if (insert && ((size_t) i == size)) {
      return size;
    }
    
    throw std::out_of_range("index out of range");
  }

  inline size_t
  slice_index(ptrdiff_t i, size_t size) {
    if ( i < 0 ) {
      if ((size_t) (-i) <= size) {
	return (size_t) (i + size);
      } else {
	throw std::out_of_range("index out of range");
      }
    } else {
      return ( (size_t) i < size ) ? ((size_t) i) : size;
    }
  }

  template <class Sequence, class Difference>
  inline typename Sequence::iterator
  getpos(Sequence* self, Difference i)  {
    typename Sequence::iterator pos = self->begin();
    std::advance(pos, check_index(i,self->size()));
    return pos;
  }

  template <class Sequence, class Difference>
  inline typename Sequence::const_iterator
  cgetpos(const Sequence* self, Difference i)  {
    typename Sequence::const_iterator pos = self->begin();
    std::advance(pos, check_index(i,self->size()));
    return pos;
  }

  template <class Sequence, class Difference>
  inline Sequence*
  getslice(const Sequence* self, Difference i, Difference j) {
    typename Sequence::size_type size = self->size();
    typename Sequence::size_type ii = swig::check_index(i, size);
    typename Sequence::size_type jj = swig::slice_index(j, size);

    if (jj > ii) {
      typename Sequence::const_iterator vb = self->begin();
      typename Sequence::const_iterator ve = self->begin();
      std::advance(vb,ii);
      std::advance(ve,jj);
      return new Sequence(vb, ve);
    } else {
      return new Sequence();
    }
  }

  template <class Sequence, class Difference, class InputSeq>
  inline void
  setslice(Sequence* self, Difference i, Difference j, const InputSeq& v) {
    typename Sequence::size_type size = self->size();
    typename Sequence::size_type ii = swig::check_index(i, size, true);
    typename Sequence::size_type jj = swig::slice_index(j, size);
    if (jj < ii) jj = ii;
    size_t ssize = jj - ii;
    if (ssize <= v.size()) {
      typename Sequence::iterator sb = self->begin();
      typename InputSeq::const_iterator vmid = v.begin();
      std::advance(sb,ii);
      std::advance(vmid, jj - ii);
      self->insert(std::copy(v.begin(), vmid, sb), vmid, v.end());
    } else {
      typename Sequence::iterator sb = self->begin();
      typename Sequence::iterator se = self->begin();
      std::advance(sb,ii);
      std::advance(se,jj);
      self->erase(sb,se);
      self->insert(sb, v.begin(), v.end());
    }
  }

  template <class Sequence, class Difference>
  inline void
  delslice(Sequence* self, Difference i, Difference j) {
    typename Sequence::size_type size = self->size();
    typename Sequence::size_type ii = swig::check_index(i, size, true);
    typename Sequence::size_type jj = swig::slice_index(j, size);
    if (jj > ii) {
      typename Sequence::iterator sb = self->begin();
      typename Sequence::iterator se = self->begin();
      std::advance(sb,ii);
      std::advance(se,jj);
      self->erase(sb,se);
    }
  }
}


#if defined(__SUNPRO_CC) && defined(_RWSTD_VER)
#  if !defined(SWIG_NO_STD_NOITERATOR_TRAITS_STL)
#    define SWIG_STD_NOITERATOR_TRAITS_STL
#  endif
#endif

#if !defined(SWIG_STD_NOITERATOR_TRAITS_STL)
#include <iterator>
#else
namespace std {
  template <class Iterator>
  struct iterator_traits {
    typedef ptrdiff_t difference_type;
    typedef typename Iterator::value_type value_type;
  };

  template <class Iterator, class Category,class T, class Reference, class Pointer, class Distance>
  struct iterator_traits<__reverse_bi_iterator<Iterator,Category,T,Reference,Pointer,Distance> > {
    typedef Distance difference_type;
    typedef T value_type;
  };

  template <class T>
  struct iterator_traits<T*> {
    typedef T value_type;
    typedef ptrdiff_t difference_type;
  };

  template<typename _InputIterator>
  inline typename iterator_traits<_InputIterator>::difference_type
  distance(_InputIterator __first, _InputIterator __last)
  {
    typename iterator_traits<_InputIterator>::difference_type __n = 0;
    while (__first != __last) {
      ++__first; ++__n;
    }
    return __n;
  }
}
#endif


namespace swig {
  template<typename OutIterator>
  class OctSwigIterator_T :  public OctSwigIterator
  {
  public:
    typedef OutIterator out_iterator;
    typedef typename std::iterator_traits<out_iterator>::value_type value_type;    
    typedef OctSwigIterator_T<out_iterator> self_type;

    OctSwigIterator_T(out_iterator curr, octave_value seq)
      : OctSwigIterator(seq), current(curr)
    {
    }

    const out_iterator& get_current() const
    {
      return current;
    }

    
    bool equal (const OctSwigIterator &iter) const
    {
      const self_type *iters = dynamic_cast<const self_type *>(&iter);
      if (iters) {
	return (current == iters->get_current());
      } else {
	throw std::invalid_argument("bad iterator type");
      }
    }
    
    ptrdiff_t distance(const OctSwigIterator &iter) const
    {
      const self_type *iters = dynamic_cast<const self_type *>(&iter);
      if (iters) {
	return std::distance(current, iters->get_current());
      } else {
	throw std::invalid_argument("bad iterator type");
      }
    }    
    
  protected:
    out_iterator current;
  };
  
  template <class ValueType>
  struct from_oper 
  {
    typedef const ValueType& argument_type;
    typedef octave_value result_type;
    result_type operator()(argument_type v) const
    {
      return swig::from(v);
    }
  };

  template<typename OutIterator, 
	   typename ValueType = typename std::iterator_traits<OutIterator>::value_type,
	   typename FromOper = from_oper<ValueType> >
  class OctSwigIteratorOpen_T :  public OctSwigIterator_T<OutIterator>
  {
  public:
    FromOper from;
    typedef OutIterator out_iterator;
    typedef ValueType value_type;
    typedef OctSwigIterator_T<out_iterator>  base;
    typedef OctSwigIteratorOpen_T<OutIterator, ValueType, FromOper> self_type;
    
    OctSwigIteratorOpen_T(out_iterator curr, octave_value seq)
      : OctSwigIterator_T<OutIterator>(curr, seq)
    {
    }
    
    octave_value value() const {
      return from(static_cast<const value_type&>(*(base::current)));
    }
    
    OctSwigIterator *copy() const
    {
      return new self_type(*this);
    }

    OctSwigIterator *incr(size_t n = 1)
    {
      while (n--) {
	++base::current;
      }
      return this;
    }

    OctSwigIterator *decr(size_t n = 1)
    {
      while (n--) {
	--base::current;
      }
      return this;
    }
  };

  template<typename OutIterator, 
	   typename ValueType = typename std::iterator_traits<OutIterator>::value_type,
	   typename FromOper = from_oper<ValueType> >
  class OctSwigIteratorClosed_T :  public OctSwigIterator_T<OutIterator>
  {
  public:
    FromOper from;
    typedef OutIterator out_iterator;
    typedef ValueType value_type;
    typedef OctSwigIterator_T<out_iterator>  base;    
    typedef OctSwigIteratorClosed_T<OutIterator, ValueType, FromOper> self_type;
    
    OctSwigIteratorClosed_T(out_iterator curr, out_iterator first, out_iterator last, octave_value seq)
      : OctSwigIterator_T<OutIterator>(curr, seq), begin(first), end(last)
    {
    }
    
    octave_value value() const {
      if (base::current == end) {
	throw stop_iteration();
      } else {
	return from(static_cast<const value_type&>(*(base::current)));
      }
    }
    
    OctSwigIterator *copy() const
    {
      return new self_type(*this);
    }

    OctSwigIterator *incr(size_t n = 1)
    {
      while (n--) {
	if (base::current == end) {
	  throw stop_iteration();
	} else {
	  ++base::current;
	}
      }
      return this;
    }

    OctSwigIterator *decr(size_t n = 1)
    {
      while (n--) {
	if (base::current == begin) {
	  throw stop_iteration();
	} else {
	  --base::current;
	}
      }
      return this;
    }

  private:
    out_iterator begin;
    out_iterator end;
  };

  template<typename OutIter>
  inline OctSwigIterator*
  make_output_iterator(const OutIter& current, const OutIter& begin,const OutIter& end, octave_value seq = octave_value())
  {
    return new OctSwigIteratorClosed_T<OutIter>(current, begin, end, seq);
  }

  template<typename OutIter>
  inline OctSwigIterator*
  make_output_iterator(const OutIter& current, octave_value seq = octave_value())
  {
    return new OctSwigIteratorOpen_T<OutIter>(current, seq);
  }
}


namespace swig
{
  template <class T>
    struct OctSequence_Ref // * octave can't support these, because of how assignment works
  {
    OctSequence_Ref(const octave_value& seq, int index)
      : _seq(seq), _index(index)
    {
    }
    
    operator T () const
    {
      //      swig::SwigVar_PyObject item = OctSequence_GetItem(_seq, _index);
      octave_value item; // * todo
      try {
	return swig::as<T>(item, true);
      } catch (std::exception& e) {
	char msg[1024];
	sprintf(msg, "in sequence element %d ", _index);
	if (!Octave_Error_Occurred()) {
	  SWIG_Error(SWIG_TypeError,  swig::type_name<T>());
	}
	SWIG_Octave_AddErrorMsg(msg);
	SWIG_Octave_AddErrorMsg(e.what());
	throw;
      }
    }

    OctSequence_Ref& operator=(const T& v)
    {
      //      OctSequence_SetItem(_seq, _index, swig::from<T>(v));
      // * todo
      return *this;
    }

  private:
    octave_value _seq;
    int _index;
  };

  template <class T>
  struct OctSequence_ArrowProxy
  {
    OctSequence_ArrowProxy(const T& x): m_value(x) {}
    const T* operator->() const { return &m_value; }
    operator const T*() const { return &m_value; }
    T m_value;
  };

  template <class T, class Reference >
  struct OctSequence_InputIterator
  {
    typedef OctSequence_InputIterator<T, Reference > self;

    typedef std::random_access_iterator_tag iterator_category;
    typedef Reference reference;
    typedef T value_type;
    typedef T* pointer;
    typedef int difference_type;

    OctSequence_InputIterator()
    {
    }

    OctSequence_InputIterator(const octave_value& seq, int index)
      : _seq(seq), _index(index)
    {
    }

    reference operator*() const
    {
      return reference(_seq, _index);
    }

    OctSequence_ArrowProxy<T>
    operator->() const {
      return OctSequence_ArrowProxy<T>(operator*());
    }

    bool operator==(const self& ri) const
    {
      return (_index == ri._index);
    }

    bool operator!=(const self& ri) const
    {
      return !(operator==(ri));
    }

    self& operator ++ ()
    {
      ++_index;
      return *this;
    }

    self& operator -- ()
    {
      --_index;
      return *this;
    }

    self& operator += (difference_type n)
    {
      _index += n;
      return *this;
    }

    self operator +(difference_type n) const
    {
      return self(_seq, _index + n);
    }

    self& operator -= (difference_type n)
    {
      _index -= n;
      return *this;
    }

    self operator -(difference_type n) const
    {
      return self(_seq, _index - n);
    }

    difference_type operator - (const self& ri) const
    {
      return _index - ri._index;
    }

    bool operator < (const self& ri) const
    {
      return _index < ri._index;
    }

    reference
    operator[](difference_type n) const
    {
      return reference(_seq, _index + n);
    }

  private:
    octave_value _seq;
    difference_type _index;
  };

  template <class T>
  struct OctSequence_Cont
  {
    typedef OctSequence_Ref<T> reference;
    typedef const OctSequence_Ref<T> const_reference;
    typedef T value_type;
    typedef T* pointer;
    typedef int difference_type;
    typedef int size_type;
    typedef const pointer const_pointer;
    typedef OctSequence_InputIterator<T, reference> iterator;
    typedef OctSequence_InputIterator<T, const_reference> const_iterator;

    OctSequence_Cont(const octave_value& seq) : _seq(seq)
    {
      // * assert that we have map type etc.
      /*
      if (!OctSequence_Check(seq)) {
	throw std::invalid_argument("a sequence is expected");
      }
      _seq = seq;
      Py_INCREF(_seq);
      */
    }

    ~OctSequence_Cont()
    {
    }

    size_type size() const
    {
      //      return static_cast<size_type>(OctSequence_Size(_seq));
      return 0; // * todo
    }

    bool empty() const
    {
      return size() == 0;
    }

    iterator begin()
    {
      return iterator(_seq, 0);
    }

    const_iterator begin() const
    {
      return const_iterator(_seq, 0);
    }

    iterator end()
    {
      return iterator(_seq, size());
    }

    const_iterator end() const
    {
      return const_iterator(_seq, size());
    }

    reference operator[](difference_type n)
    {
      return reference(_seq, n);
    }

    const_reference operator[](difference_type n)  const
    {
      return const_reference(_seq, n);
    }

    bool check(bool set_err = true) const
    {
      int s = size();
      for (int i = 0; i < s; ++i) {
	//	swig::SwigVar_PyObject item = OctSequence_GetItem(_seq, i);
	octave_value item; // * todo
	if (!swig::check<value_type>(item)) {
	  if (set_err) {
	    char msg[1024];
	    sprintf(msg, "in sequence element %d", i);
	    SWIG_Error(SWIG_RuntimeError, msg);
	  }
	  return false;
	}
      }
      return true;
    }

  private:
    octave_value _seq;
  };

}

SWIGINTERN vector< ccmc::Point3f >::value_type vector_Sl_Point3f_Sg__pop(vector< Point3f > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector<ccmc::Point3f,std::allocator< ccmc::Point3f > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN vector< ccmc::Point3f >::value_type vector_Sl_Point3f_Sg____paren__(vector< Point3f > *self,vector< ccmc::Point3f >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void vector_Sl_Point3f_Sg____paren_asgn__(vector< Point3f > *self,vector< ccmc::Point3f >::difference_type i,vector< ccmc::Point3f >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN void vector_Sl_Point3f_Sg__append(vector< Point3f > *self,vector< ccmc::Point3f >::value_type x){
      self->push_back(x);
    }

  namespace swig {
    template <>  struct traits<ccmc::Point3f > {
      typedef pointer_category category;
      static const char* type_name() { return"ccmc::Point3f"; }
    };
  }


namespace swig {
  template <class OctSeq, class Seq>
  inline void
  assign(const OctSeq& octseq, Seq* seq) {
#ifdef SWIG_STD_NOASSIGN_STL
    typedef typename OctSeq::value_type value_type;
    typename OctSeq::const_iterator it = octseq.begin();
    for (;it != octseq.end(); ++it) {
      seq->insert(seq->end(),(value_type)(*it));
    }
#else
    seq->assign(octseq.begin(), octseq.end());
#endif
  }

  template <class Seq, class T = typename Seq::value_type >
  struct traits_asptr_stdseq {
    typedef Seq sequence;
    typedef T value_type;

    static int asptr(const octave_value& obj, sequence **seq) {
      if (!obj.is_defined() || Swig::swig_value_deref(obj)) {
	sequence *p;
	if (SWIG_ConvertPtr(obj,(void**)&p,
			    swig::type_info<sequence>(),0) == SWIG_OK) {
	  if (seq) *seq = p;
	  return SWIG_OLDOBJ;
	}
      } else if (obj.is_cell()) {
	try {
	  OctSequence_Cont<value_type> octseq(obj);
	  if (seq) {
	    sequence *pseq = new sequence();
	    assign(octseq, pseq);
	    *seq = pseq;
	    return SWIG_NEWOBJ;
	  } else {
	    return octseq.check() ? SWIG_OK : SWIG_ERROR;
	  }
	} catch (std::exception& e) {
	  if (seq&&!error_state)
	    error("swig type error: %s",e.what());
	  return SWIG_ERROR;
	}
      }
      return SWIG_ERROR;
    }
  };

  template <class Seq, class T = typename Seq::value_type >
  struct traits_from_stdseq {
    typedef Seq sequence;
    typedef T value_type;
    typedef typename Seq::size_type size_type;
    typedef typename sequence::const_iterator const_iterator;

    static octave_value from(const sequence& seq) {






      size_type size = seq.size();
      if (size <= (size_type)INT_MAX) {
	Cell c(size,1);
	int i = 0;
	for (const_iterator it = seq.begin();
	     it != seq.end(); ++it, ++i) {
	  c(i) = swig::from<value_type>(*it);
	}
	return c;
      } else {
	error("swig overflow error: sequence size not valid in octave");
	return octave_value();
      }
      return octave_value();
    }
  };
}


  namespace swig {
    template <class T>
    struct traits_asptr<std::vector<T> >  {
      static int asptr(const octave_value& obj, std::vector<T> **vec) {
	return traits_asptr_stdseq<std::vector<T> >::asptr(obj, vec);
      }
    };
    
    template <class T>
    struct traits_from<std::vector<T> > {
      static octave_value from(const std::vector<T>& vec) {
	return traits_from_stdseq<std::vector<T> >::from(vec);
      }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector<ccmc::Point3f, std::allocator< ccmc::Point3f > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "ccmc::Point3f" "," "std::allocator< ccmc::Point3f >" " >";
	  }
	};
      }
    

  SWIGINTERNINLINE octave_value SWIG_From_unsigned_SS_long    (unsigned long value)
    {    
      return octave_value(value);
    }


SWIGINTERNINLINE octave_value
SWIG_From_size_t  (size_t value)
{    
  return SWIG_From_unsigned_SS_long  ((unsigned long)(value));
}

SWIGINTERN vector< std::string >::value_type vector_Sl_std_string_Sg__pop(vector< std::string > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector<std::string,std::allocator< std::string > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN vector< std::string >::value_type vector_Sl_std_string_Sg____paren__(vector< std::string > *self,vector< std::string >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void vector_Sl_std_string_Sg____paren_asgn__(vector< std::string > *self,vector< std::string >::difference_type i,vector< std::string >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN void vector_Sl_std_string_Sg__append(vector< std::string > *self,vector< std::string >::value_type x){
      self->push_back(x);
    }

SWIGINTERN int
SWIG_AsVal_std_string (octave_value obj, std::string *val)
{
  std::string* v = (std::string *) 0;
  int res = SWIG_AsPtr_std_string (obj, &v);
  if (!SWIG_IsOK(res)) return res;
  if (v) {
    if (val) *val = *v;
    if (SWIG_IsNewObj(res)) {
      delete v;
      res = SWIG_DelNewMask(res);
    }
    return res;
  }
  return SWIG_ERROR;
}


namespace swig {
  template <> struct traits<std::string > {
    typedef value_category category;
    static const char* type_name() { return"std::string"; }
  };  
  template <>  struct traits_asval<std::string > {   
    typedef std::string value_type;
    static int asval(octave_value obj, value_type *val) { 
      return SWIG_AsVal_std_string (obj, val);
    }
  };
  template <>  struct traits_from<std::string > {
    typedef std::string value_type;
    static octave_value from(const value_type& val) {
      return SWIG_From_std_string  (val);
    }
  };
}


      namespace swig {
	template <>  struct traits<std::vector<std::string, std::allocator< std::string > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "std::string" "," "std::allocator< std::string >" " >";
	  }
	};
      }
    
SWIGINTERN vector< float >::value_type vector_Sl_float_Sg__pop(vector< float > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector<float,std::allocator< float > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN vector< float >::value_type vector_Sl_float_Sg____paren__(vector< float > *self,vector< float >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void vector_Sl_float_Sg____paren_asgn__(vector< float > *self,vector< float >::difference_type i,vector< float >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN void vector_Sl_float_Sg__append(vector< float > *self,vector< float >::value_type x){
      self->push_back(x);
    }

namespace swig {
  template <> struct traits<float > {
    typedef value_category category;
    static const char* type_name() { return"float"; }
  };  
  template <>  struct traits_asval<float > {   
    typedef float value_type;
    static int asval(octave_value obj, value_type *val) { 
      return SWIG_AsVal_float (obj, val);
    }
  };
  template <>  struct traits_from<float > {
    typedef float value_type;
    static octave_value from(const value_type& val) {
      return SWIG_From_float  (val);
    }
  };
}


      namespace swig {
	template <>  struct traits<std::vector<float, std::allocator< float > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "float" "," "std::allocator< float >" " >";
	  }
	};
      }
    
SWIGINTERN vector< ccmc::Fieldline >::value_type vector_Sl_Fieldline_Sg__pop(vector< Fieldline > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector<ccmc::Fieldline,std::allocator< ccmc::Fieldline > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN vector< ccmc::Fieldline >::value_type vector_Sl_Fieldline_Sg____paren__(vector< Fieldline > *self,vector< ccmc::Fieldline >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void vector_Sl_Fieldline_Sg____paren_asgn__(vector< Fieldline > *self,vector< ccmc::Fieldline >::difference_type i,vector< ccmc::Fieldline >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN void vector_Sl_Fieldline_Sg__append(vector< Fieldline > *self,vector< ccmc::Fieldline >::value_type x){
      self->push_back(x);
    }

  namespace swig {
    template <>  struct traits<ccmc::Fieldline > {
      typedef pointer_category category;
      static const char* type_name() { return"ccmc::Fieldline"; }
    };
  }


      namespace swig {
	template <>  struct traits<std::vector<ccmc::Fieldline, std::allocator< ccmc::Fieldline > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "ccmc::Fieldline" "," "std::allocator< ccmc::Fieldline >" " >";
	  }
	};
      }
    
SWIGINTERN vector< int >::value_type vector_Sl_int_Sg__pop(vector< int > *self){
      if (self->size() == 0)
	throw std::out_of_range("pop from empty container");
      std::vector<int,std::allocator< int > >::value_type x = self->back();
      self->pop_back();
      return x;
    }
SWIGINTERN vector< int >::value_type vector_Sl_int_Sg____paren__(vector< int > *self,vector< int >::difference_type i){
      return *(swig::cgetpos(self, i));
    }
SWIGINTERN void vector_Sl_int_Sg____paren_asgn__(vector< int > *self,vector< int >::difference_type i,vector< int >::value_type x){
      *(swig::getpos(self,i)) = x;
    }
SWIGINTERN void vector_Sl_int_Sg__append(vector< int > *self,vector< int >::value_type x){
      self->push_back(x);
    }

namespace swig {
  template <> struct traits<int > {
    typedef value_category category;
    static const char* type_name() { return"int"; }
  };  
  template <>  struct traits_asval<int > {   
    typedef int value_type;
    static int asval(octave_value obj, value_type *val) { 
      return SWIG_AsVal_int (obj, val);
    }
  };
  template <>  struct traits_from<int > {
    typedef int value_type;
    static octave_value from(const value_type& val) {
      return SWIG_From_int  (val);
    }
  };
}


      namespace swig {
	template <>  struct traits<std::vector<int, std::allocator< int > > > {
	  typedef pointer_category category;
	  static const char* type_name() {
	    return "std::vector<" "int" "," "std::allocator< int >" " >";
	  }
	};
      }
    
const char* _wrap_Fieldline_getPositions_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< Point3f > & ccmc::Fieldline::getPositions()\n\
\n\
TODO: finish documentation ";
const char* _wrap_Point3f_normalize_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Point3f::normalize()\n\
\n\
TODO: finish documentation ";
const char* _wrap_Model_close_texinfo = "-*- texinfo -*-\n\
long ccmc::Model::close()\n\
\n\
Closes the currently selected file. ";
const char* _wrap_GeneralFileReader_close_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::GeneralFileReader::close() ";
const char* _wrap_FileReader_close_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::FileReader::close()\n\
\n\
Closes the currently selected file. Status of close operation. ";
const char* _wrap_Kameleon_close_texinfo = "-*- texinfo -*-\n\
long Kameleon::close()\n\
\n\
Closes the currently opened file. ";
const char* _wrap_GeneralFileReader_getVariableAttributeNames_texinfo = "-*- texinfo -*-\n\
std::vector<\n\
std::string > ccmc::GeneralFileReader::getVariableAttributeNames() ";
const char* _wrap_FileReader_initializeVariableNames_texinfo = "-*- texinfo -*-\n\
virtual void ccmc::FileReader::initializeVariableNames()=0 ";
const char* _wrap_FileReader_getVariableAttributeNames_texinfo = "-*- texinfo -*-\n\
virtual std::vector<std::string>\n\
ccmc::FileReader::getVariableAttributeNames()=0 ";
const char* _wrap_CDFFileReader_getVariableAttributeNames_texinfo = "-*- texinfo -*-\n\
std::vector< std::string >\n\
ccmc::CDFFileReader::getVariableAttributeNames() ";
const char* _wrap_Fieldline_reverseOrder_texinfo = "-*- texinfo -*-\n\
Fieldline\n\
ccmc::Fieldline::reverseOrder()\n\
\n\
TODO: finish documentation ";
const char* _wrap_delete_OpenGGCM_texinfo = "-*- texinfo -*-\n\
ccmc::OpenGGCM::~OpenGGCM() ";
const char* _wrap_new_OpenGGCM_texinfo = "-*- texinfo -*-\n\
ccmc::OpenGGCM::OpenGGCM()\n\
\n\
Default constructor ";
const char* _wrap_SWMFIonoInterpolator_interpolate_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::SWMFIonoInterpolator::interpolate(const long &variable_id, const\n\
float &r, const float &lat, const float &lon, float &dr, float &dlat,\n\
float &dlon) ";
const char* _wrap_OpenGGCMInterpolator_interpolate_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::OpenGGCMInterpolator::interpolate(const long &variable_id, const\n\
float &c0, const float &c1, const float &c2, float &dc0, float &dc1,\n\
float &dc2)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:\n\
\n\
c0:\n\
\n\
c1:\n\
\n\
c2:\n\
\n\
dc0:  Reference to a variable to store the delta for component 0\n\
\n\
dc1:  Reference to a variable to store the delta for component 1\n\
\n\
dc2:  Reference to a variable to store the delta for component 2\n\
\n\
The interpolated value at position (c0,c1,c2) with deltas\n\
(dc0,dc1,dc2) ";
const char* _wrap_MASInterpolator_interpolate_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::MASInterpolator::interpolate(const long &variable_id, const\n\
float &r, const float &lat, const float &lon, float &dr, float &dlat,\n\
float &dlon)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variableID:\n\
\n\
r:\n\
\n\
lat:\n\
\n\
lon:\n\
\n\
dr:\n\
\n\
dlat:\n\
\n\
dlon:\n\
\n\
convert from latitude -60 to 60 to radians ...\n\
\n\
convert from latitude -60 to 60 to radians ...\n\
\n\
convert from latitude -60...60 to 30...150 range in degress and then\n\
to radians...\n\
\n\
convert degrees ( 0 - 360 longitude ) to radiadns\n\
\n\
correct for longitude angles less than 0 or having a magnitude greater\n\
than 360.f ";
const char* _wrap_ENLILInterpolator_interpolate_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::ENLILInterpolator::interpolate(const long &variableID, const\n\
float &r, const float &lat, const float &lon, float &dr, float &dlat,\n\
float &dlon)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variableID:\n\
\n\
r:\n\
\n\
lat:\n\
\n\
lon:\n\
\n\
dr:\n\
\n\
dlat:\n\
\n\
dlon:\n\
\n\
convert from latitude -60 to 60 to radians ...\n\
\n\
convert from latitude -60 to 60 to radians ...\n\
\n\
convert from latitude -60...60 to 30...150 range in degress and then\n\
to radians...\n\
\n\
convert degrees ( 0 - 360 longitude ) to radiadns\n\
\n\
correct for longitude angles less than 0 or having a magnitude greater\n\
than 360.f ";
const char* _wrap_BATSRUSInterpolator_interpolate_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::BATSRUSInterpolator::interpolate(const long &variable_id, const\n\
float &c0, const float &c1, const float &c2, float &dc0, float &dc1,\n\
float &dc2)\n\
\n\
Interpolation method. Note that using the variable ID is significantly\n\
faster than using the variable string.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  A long representing the variable ID.\n\
\n\
c0:  X component of the position\n\
\n\
c1:  Y component of the position\n\
\n\
c2:  Z component of the position\n\
\n\
dc0:  Reference to a variable to store the delta for component 0\n\
\n\
dc1:  Reference to a variable to store the delta for component 1\n\
\n\
dc2:  Reference to a variable to store the delta for component 2\n\
\n\
The interpolated value at position (c0,c1,c2) with deltas\n\
(dc0,dc1,dc2)\n\
\n\
end of if new position loop ";
const char* _wrap_Fieldline_interpolate_texinfo = "-*- texinfo -*-\n\
Fieldline\n\
ccmc::Fieldline::interpolate(int option, int Npoints) ";
const char* _wrap_Interpolator_interpolate_texinfo = "-*- texinfo -*-\n\
virtual float\n\
ccmc::Interpolator::interpolate(const long &variable_id, const float\n\
&c0, const float &c1, const float &c2, float &dc0, float &dc1, float\n\
&dc2)=0 ";
const char* _wrap_KameleonInterpolator_interpolate_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::KameleonInterpolator::interpolate(const long &variable_id, const\n\
float &c0, const float &c1, const float &c2, float &dc0, float &dc1,\n\
float &dc2)\n\
\n\
A variable_id won\'t work well, since derived variables can be\n\
requested, which do not exist in the data.\n\
\n\
OpenGGCM and BATSRUS: c0,c1,c2 maps to x,y,z, respectively. ENLIL and\n\
MAS: c0,c1,c2 maps to r,theta(latitude), phi(longitude), respectively\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
c0:\n\
\n\
c1:\n\
\n\
c2:\n\
\n\
dc0:\n\
\n\
dc1:\n\
\n\
dc2:  ";
const char* _wrap_Attribute_setAttributeName_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Attribute::setAttributeName(std::string attributeName)\n\
\n\
Sets the attribute name\n\
\n\
Parameters:\n\
-----------\n\
\n\
name:  The attribute name requested. ";
const char* _wrap_Attribute_getAttributeName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Attribute::getAttributeName()\n\
\n\
Returns the attribute\'s name as a std::string object. The attribute\'s\n\
name ";
const char* _wrap_GeneralFileReader_getVariableAttributeName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::GeneralFileReader::getVariableAttributeName(long attribute_id)\n\
";
const char* _wrap_GeneralFileReader_getGlobalAttributeName_texinfo = "-*- texinfo -*-\n\
std::string ccmc::GeneralFileReader::getGlobalAttributeName(long\n\
attribute_id) ";
const char* _wrap_FileReader_getGlobalAttributeName_texinfo = "-*- texinfo -*-\n\
virtual std::string ccmc::FileReader::getGlobalAttributeName(long\n\
attribute_id)=0 ";
const char* _wrap_FileReader_getVariableAttributeName_texinfo = "-*- texinfo -*-\n\
virtual std::string ccmc::FileReader::getVariableAttributeName(long\n\
attribute_id)=0 ";
const char* _wrap_CDFFileReader_getGlobalAttributeName_texinfo = "-*- texinfo -*-\n\
std::string ccmc::CDFFileReader::getGlobalAttributeName(long\n\
attribute_id)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute_id:  ";
const char* _wrap_CDFFileReader_getVariableAttributeName_texinfo = "-*- texinfo -*-\n\
std::string ccmc::CDFFileReader::getVariableAttributeName(long\n\
attribute_id)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute_id:\n\
\n\
String representing the name of the attribute specified by\n\
attribute_id ";
const char* _wrap_Kameleon_getGlobalAttributeName_texinfo = "-*- texinfo -*-\n\
std::string Kameleon::getGlobalAttributeName(long attribute_id)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute_id:  ";
const char* _wrap_Kameleon_getVariableAttributeName_texinfo = "-*- texinfo -*-\n\
std::string Kameleon::getVariableAttributeName(long attribute_id) ";
const char* _wrap_new_Time_texinfo = "-*- texinfo -*-\n\
ccmc::Time::Time() ";
const char* _wrap_Fieldline_measure_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > & ccmc::Fieldline::measure()\n\
\n\
Measure the length of the field line up to point i ";
const char* _wrap_Point3f_magnitude_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Point3f::magnitude()\n\
\n\
Computes the magnitude of the cartesian vector ";
const char* _wrap_Time_setHour_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setHour(short hour) ";
const char* _wrap_Time_getHour_texinfo = "-*- texinfo -*-\n\
short\n\
ccmc::Time::getHour() const ";
const char* _wrap_delete_SWMFIono_texinfo = "-*- texinfo -*-\n\
ccmc::SWMFIono::~SWMFIono() ";
const char* _wrap_new_SWMFIono_texinfo = "-*- texinfo -*-\n\
ccmc::SWMFIono::SWMFIono() ";
const char* _wrap_Time_setMonth_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setMonth(short month) ";
const char* _wrap_Time_getMonth_texinfo = "-*- texinfo -*-\n\
short\n\
ccmc::Time::getMonth() const ";
const char* _wrap_MAS_getLonPosGridName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::MAS::getLonPosGridName(long variable_id) ";
const char* _wrap_MAS_getLatPosGridName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::MAS::getLatPosGridName(long variable_id) ";
const char* _wrap_MAS_getRPosGridName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::MAS::getRPosGridName(long variable) ";
const char* _wrap_OpenGGCM_getZGridName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::OpenGGCM::getZGridName(long variable_id) ";
const char* _wrap_OpenGGCM_getYGridName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::OpenGGCM::getYGridName(long variable_id) ";
const char* _wrap_OpenGGCM_getXGridName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::OpenGGCM::getXGridName(long variable_id) ";
const char* _wrap_Model_getIntVariableFromMap_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< int > *const ccmc::Model::getIntVariableFromMap(long\n\
variable_id)\n\
\n\
Returns a const pointer to the entry in the variableDataIntByID map\n\
containing the variable data.\n\
\n\
This pointer cannot be modified.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  Variable id of the variable to fetch from memory. This\n\
assumes the variable has already been loaded into memory. If the\n\
variable has not been loaded, the pointer will be NULL. Request the\n\
variable id by using FileReader::getVariableID(const std::string&\n\
variable)\n\
\n\
std::vector<int>* of the requested variable. Note that the pointer\n\
points to an entry in a map and should not and cannot be deleted. The\n\
memory pointed to by the pointer will automatically be freed when the\n\
file is closed, or the Model object is deleted. ";
const char* _wrap_Model_getVariableFromMap_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< float > *const ccmc::Model::getVariableFromMap(long\n\
variable_id)\n\
\n\
Returns a const pointer to the entry in the variableDataByID map\n\
containing the variable data.\n\
\n\
This pointer cannot be modified.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  Variable id of the variable to fetch from memory. This\n\
assumes the variable has already been loaded into memory. If the\n\
variable has not been loaded, the pointer will be NULL. Request the\n\
variable id by using FileReader::getVariableID(const std::string&\n\
variable)\n\
\n\
std::vector<float>* of the requested variable. Note that the pointer\n\
points to an entry in a map and should not and cannot be deleted. The\n\
memory pointed to by the pointer will automatically be freed when the\n\
file is closed, or the Model object is deleted. ";
const char* _wrap_Kameleon_getVariableFromMap_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< float > *const Kameleon::getVariableFromMap(const\n\
std::string &variable)\n\
\n\
Returns a pointer to the variable data stored in a map. This method\n\
works for variables of type float. This cannot and should not be\n\
modified or deleted. Use loadVariable and unloadVariable to manange\n\
the map.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Kameleon_getVariableIntFromMap_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< int > *const Kameleon::getVariableIntFromMap(const\n\
std::string &variable)\n\
\n\
Returns a pointer to the variable data stored in a map. This method\n\
works for variables of type int. This cannot and should not be\n\
modified or deleted. Use loadVariable and unloadVariable to manange\n\
the map.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_new_Tracer_texinfo = "-*- texinfo -*-\n\
ccmc::Tracer::Tracer(Kameleon *kameleon)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
kameleon:  ";
const char* _wrap_delete_Tracer_texinfo = "-*- texinfo -*-\n\
ccmc::Tracer::~Tracer()\n\
\n\
TODO: finish documentation ";
const char* _wrap_Point3f_getCoordinates_texinfo = "-*- texinfo -*-\n\
Point3f::Coordinates ccmc::Point3f::getCoordinates()\n\
\n\
TODO: finish documentation ";
const char* _wrap_Point3f_setCoordinates_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Point3f::setCoordinates(Coordinates c)\n\
\n\
TODO: finish documentation ";
const char* _wrap_new_Kameleon_texinfo = "-*- texinfo -*-\n\
Kameleon::Kameleon()\n\
\n\
Default constructor ";
const char* _wrap_delete_Kameleon_texinfo = "-*- texinfo -*-\n\
Kameleon::~Kameleon()\n\
\n\
Destructor ";
const char* _wrap_Time_setDay_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setDay(short day) ";
const char* _wrap_delete_Point3f_texinfo = "-*- texinfo -*-\n\
ccmc::Point3f::~Point3f()\n\
\n\
TODO: finish documentation ";
const char* _wrap_new_Point3f_texinfo = "-*- texinfo -*-\n\
ccmc::Point3f::Point3f(Coordinates c)\n\
\n\
TODO: finish documentation ";
const char* _wrap_Model_getProgress_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::Model::getProgress() ";
const char* _wrap_Kameleon_getProgress_texinfo = "-*- texinfo -*-\n\
int\n\
Kameleon::getProgress() ";
const char* _wrap_Fieldline_getElement_texinfo = "-*- texinfo -*-\n\
const Point3f &\n\
ccmc::Fieldline::getElement(int i) ";
const char* _wrap_Time_setYear_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setYear(short year) ";
const char* _wrap_Time_getYear_texinfo = "-*- texinfo -*-\n\
short\n\
ccmc::Time::getYear() const ";
const char* _wrap_GeneralFileReader_getNumberOfVariableAttributes_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::GeneralFileReader::getNumberOfVariableAttributes() ";
const char* _wrap_CDFFileReader_getVariableIntAtIndex_texinfo = "-*- texinfo -*-\n\
int ccmc::CDFFileReader::getVariableIntAtIndex(const std::string\n\
&variable, long index)\n\
\n\
Returns a value in the flat array of the variable and index requested.\n\
\n\
Use this method on variables that have a type of int\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  The variable in the file\n\
\n\
index:  The index in the variable\'s array in the file\n\
\n\
int of the value in the array. ";
const char* _wrap_CDFFileReader_getVariableAtIndex_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::CDFFileReader::getVariableAtIndex(long variable_id, long index)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variableNum:\n\
\n\
index:  ";
const char* _wrap_GeneralFileReader_getVariableIntAtIndex_texinfo = "-*- texinfo -*-\n\
int ccmc::GeneralFileReader::getVariableIntAtIndex(const std::string\n\
&variable, long index) ";
const char* _wrap_GeneralFileReader_getVariableAtIndex_texinfo = "-*- texinfo -*-\n\
float ccmc::GeneralFileReader::getVariableAtIndex(long variable_id,\n\
long index) ";
const char* _wrap_FileReader_getVariableAtIndex_texinfo = "-*- texinfo -*-\n\
virtual\n\
float ccmc::FileReader::getVariableAtIndex(long variable_id, long\n\
index)=0 ";
const char* _wrap_FileReader_getVariableIntAtIndex_texinfo = "-*- texinfo -*-\n\
virtual int ccmc::FileReader::getVariableIntAtIndex(const std::string\n\
&variable, long index)=0 ";
const char* _wrap_Model_getBusyStatus_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::Model::getBusyStatus() ";
const char* _wrap_FileReader_openFile_texinfo = "-*- texinfo -*-\n\
virtual long\n\
ccmc::FileReader::openFile(const std::string &filename, bool\n\
readonly)=0 ";
const char* _wrap_Tracer_bidirectionalTraceWithDipole_texinfo = "-*- texinfo -*-\n\
Fieldline ccmc::Tracer::bidirectionalTraceWithDipole(const std::string\n\
&variable, const float &startComponent1, const float &startComponent2,\n\
const float &startComponent3)\n\
\n\
Opens a CCMC generated CDF file and initializes the model name\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  The filename of the cdf file to open. Closes the opened CDF\n\
file Loads the variable, including all components of the variable,\n\
into memory. For example, if variable is \"bx\", three variables will\n\
be loaded: \"bx\", \"by\", and \"bz\"\n\
\n\
variable:  TODO: finish documentation\n\
\n\
variable:\n\
\n\
startComponent1:\n\
\n\
startComponent2:\n\
\n\
startComponent3:  ";
const char* _wrap_Tracer_unidirectionalTraceWithDipole_texinfo = "-*- texinfo -*-\n\
Fieldline ccmc::Tracer::unidirectionalTraceWithDipole(const\n\
std::string &variable, const float &startComponent1, const float\n\
&startComponent2, const float &startComponent3, const Direction\n\
&dir=FOWARD)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
startComponent1:\n\
\n\
startComponent2:\n\
\n\
startComponent3:\n\
\n\
dir:  ";
const char* _wrap_Tracer_getLastClosedFieldlines_texinfo = "-*- texinfo -*-\n\
vector<\n\
Fieldline > ccmc::Tracer::getLastClosedFieldlines(int\n\
numberOfFieldlines, int stepMax, int\n\
numberOfPointsPerReducedFieldline)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
numberOfFieldlines:\n\
\n\
stepMax:\n\
\n\
numberOfPointsPerReducedFieldline:\n\
\n\
add the first point all the time\n\
\n\
always add the last point too, since i was reduced by one ";
const char* _wrap_Fieldline_removePoint_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Fieldline::removePoint(int index)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
index:  ";
const char* _wrap_MAS_open_texinfo = "-*- texinfo -*-\n\
long ccmc::MAS::open(const\n\
std::string &filename)\n\
\n\
Opens a file.\n\
\n\
Opens a file and performs any necessary initialization required to\n\
work with the data.\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  ";
const char* _wrap_BATSRUS_open_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::BATSRUS::open(const std::string &filename)\n\
\n\
Opens a file.\n\
\n\
Opens a file and performs any necessary initialization required to\n\
work with the data.\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  ";
const char* _wrap_MAS_getChangeSignFlag_texinfo = "-*- texinfo -*-\n\
bool\n\
ccmc::MAS::getChangeSignFlag(long variable_id) ";
const char* _wrap_ENLIL_getChangeSignFlag_texinfo = "-*- texinfo -*-\n\
bool\n\
ccmc::ENLIL::getChangeSignFlag(std::string variable) ";
const char* _wrap_CDFFileReader_getNumberOfVariableAttributes_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::CDFFileReader::getNumberOfVariableAttributes()\n\
\n\
Gets the number of variable attributes. The number of variable\n\
attributes in the opened file. ";
const char* _wrap_CDFFileReader_getNumberOfGlobalAttributes_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::CDFFileReader::getNumberOfGlobalAttributes()\n\
\n\
TODO Retrieves the number of global attributes in the selected file.\n\
This is useful for iterating over all available global attributes. The\n\
number of global attributes stored in the selected file. ";
const char* _wrap_FileReader_getNumberOfGlobalAttributes_texinfo = "-*- texinfo -*-\n\
virtual int ccmc::FileReader::getNumberOfGlobalAttributes()=0 ";
const char* _wrap_FileReader_getNumberOfVariableAttributes_texinfo = "-*- texinfo -*-\n\
virtual int ccmc::FileReader::getNumberOfVariableAttributes()=0 ";
const char* _wrap_Kameleon_getNumberOfGlobalAttributes_texinfo = "-*- texinfo -*-\n\
int Kameleon::getNumberOfGlobalAttributes() ";
const char* _wrap_Kameleon_getNumberOfVariableAttributes_texinfo = "-*- texinfo -*-\n\
int Kameleon::getNumberOfVariableAttributes() ";
const char* _wrap_CDFFileReader_getNumberOfRecords_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::CDFFileReader::getNumberOfRecords(long variable_id)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  ";
const char* _wrap_GeneralFileReader_getNumberOfRecords_texinfo = "-*- texinfo -*-\n\
long ccmc::GeneralFileReader::getNumberOfRecords(long variable_id) ";
const char* _wrap_FileReader_getNumberOfRecords_texinfo = "-*- texinfo -*-\n\
virtual\n\
long ccmc::FileReader::getNumberOfRecords(long variable_id)=0 ";
const char* _wrap_Attribute_getAttributeInt_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::Attribute::getAttributeInt()\n\
\n\
Returns the attribute value as an int, if applicable. The int value of\n\
the attribute. The value returned will be 0 if the AttributeType of\n\
the Attribute object is not Attribute::FLOAT ";
const char* _wrap_Time_getDay_texinfo = "-*- texinfo -*-\n\
short ccmc::Time::getDay()\n\
const ";
const char* _wrap_OpenGGCM_getZGrid_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > *const ccmc::OpenGGCM::getZGrid(long variable) ";
const char* _wrap_ENLIL_getChangeSignFlagByID_texinfo = "-*- texinfo -*-\n\
bool\n\
ccmc::ENLIL::getChangeSignFlagByID(long variable_id) ";
const char* _wrap_delete_Attribute_texinfo = "-*- texinfo -*-\n\
ccmc::Attribute::~Attribute()\n\
\n\
Destructor ";
const char* _wrap_new_Attribute_texinfo = "-*- texinfo -*-\n\
ccmc::Attribute::Attribute()\n\
\n\
Default constructor. Initializes the attributeName to \"\", the string\n\
value to \"\", and the integer and float values to 0. ";
const char* _wrap_GeneralFileReader_getVariableAttribute_texinfo = "-*- texinfo -*-\n\
Attribute ccmc::GeneralFileReader::getVariableAttribute(const\n\
std::string &variable, const std::string &attribute) ";
const char* _wrap_GeneralFileReader_getGlobalAttribute_texinfo = "-*- texinfo -*-\n\
Attribute ccmc::GeneralFileReader::getGlobalAttribute(const\n\
std::string &attribute) ";
const char* _wrap_GeneralFileReader_getNumberOfGlobalAttributes_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::GeneralFileReader::getNumberOfGlobalAttributes() ";
const char* _wrap_FileReader_getGlobalAttribute_texinfo = "-*- texinfo -*-\n\
virtual\n\
Attribute ccmc::FileReader::getGlobalAttribute(const std::string\n\
&attribute)=0 ";
const char* _wrap_FileReader_getVariableAttribute_texinfo = "-*- texinfo -*-\n\
virtual Attribute ccmc::FileReader::getVariableAttribute(const\n\
std::string &variable, const std::string &attribute)=0 ";
const char* _wrap_CDFFileReader_getGlobalAttribute_texinfo = "-*- texinfo -*-\n\
Attribute ccmc::CDFFileReader::getGlobalAttribute(const std::string\n\
&attribute)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute:  ";
const char* _wrap_CDFFileReader_getVariableAttribute_texinfo = "-*- texinfo -*-\n\
Attribute ccmc::CDFFileReader::getVariableAttribute(const std::string\n\
&variable, const std::string &attribute)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
vattribute:  ";
const char* _wrap_Kameleon_getGlobalAttribute_texinfo = "-*- texinfo -*-\n\
Attribute\n\
Kameleon::getGlobalAttribute(const std::string &attribute)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute:  ";
const char* _wrap_Kameleon_getVariableAttribute_texinfo = "-*- texinfo -*-\n\
Attribute Kameleon::getVariableAttribute(const std::string &variable,\n\
const std::string &attribute)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
attribute:  ";
const char* _wrap_Tracer_bidirectionalTrace_texinfo = "-*- texinfo -*-\n\
Fieldline\n\
ccmc::Tracer::bidirectionalTrace(const std::string &variable, const\n\
float &startComponent1, const float &startComponent2, const float\n\
&startComponent3)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
startComponent1:\n\
\n\
startComponent2:\n\
\n\
startComponent3:  ";
const char* _wrap_Tracer_unidirectionalTrace_texinfo = "-*- texinfo -*-\n\
Fieldline\n\
ccmc::Tracer::unidirectionalTrace(const std::string &variable, const\n\
float &startComponent1, const float &startComponent2, const float\n\
&startComponent3, const Direction &dir=FOWARD)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
startComponent1:\n\
\n\
startComponent2:\n\
\n\
startComponent3:\n\
\n\
dir:  ";
const char* _wrap_GeneralFileReader_open_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::GeneralFileReader::open(const std::string &filename) ";
const char* _wrap_FileReader_open_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::FileReader::open(const std::string &filename, bool\n\
readonly=true)\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:\n\
\n\
The CDF status of the open call. CDF_OK is the standard successful\n\
status. ";
const char* _wrap_MAS_getlonPosGrid_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > *const ccmc::MAS::getlonPosGrid(const std::string &variable)\n\
";
const char* _wrap_MAS_getLonPosGrid_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > *const ccmc::MAS::getLonPosGrid(long variable_id) ";
const char* _wrap_MAS_getLatPosGrid_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > *const ccmc::MAS::getLatPosGrid(long variable_id) ";
const char* _wrap_MAS_getRPosGrid_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > *const ccmc::MAS::getRPosGrid(long variable_id) ";
const char* _wrap_Time_setEpoch_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setEpoch(double epoch) ";
const char* _wrap_Time_getEpoch_texinfo = "-*- texinfo -*-\n\
double\n\
ccmc::Time::getEpoch() const ";
const char* _wrap_Fieldline_getIntegral_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Fieldline::getIntegral(int i)\n\
\n\
Get the integral up to position i ";
const char* _wrap_OpenGGCM_getYGrid_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > *const ccmc::OpenGGCM::getYGrid(long variable) ";
const char* _wrap_Tracer_setDn_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setDn(float dn)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
dn:  ";
const char* _wrap_Attribute_toString_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Attribute::toString() const ";
const char* _wrap_Attribute_getAttributeString_texinfo = "-*- texinfo -*-\n\
std::string ccmc::Attribute::getAttributeString()\n\
\n\
Returns the string representation of the attribute, if applicable. The\n\
string value of the attribute. This value will be an empty string if\n\
the AttributeType of the Attribute object is not Attribute::STRING ";
const char* _wrap_Point3f_toString_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Point3f::toString() const\n\
\n\
TODO: finish documentation ";
const char* _wrap_Time_toString_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Time::toString() const ";
const char* _wrap_Tracer_setMissing_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setMissing(float missing)\n\
\n\
Parameters:\n\
-----------\n\
\n\
missing:  ";
const char* _wrap_Model_getMissingValue_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Model::getMissingValue()\n\
\n\
Returns the missing value that will be returned when no valid data\n\
exists.\n\
\n\
This value can be used to check whether an interpolated value is a\n\
missing value or not.\n\
\n\
Missing value ";
const char* _wrap_Model_setMissingValue_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Model::setMissingValue(float missingValue)\n\
\n\
Sets the missing value to use when no valid data exists.\n\
\n\
Parameters:\n\
-----------\n\
\n\
missingValue:  ";
const char* _wrap_Kameleon_getMissingValue_texinfo = "-*- texinfo -*-\n\
float\n\
Kameleon::getMissingValue() ";
const char* _wrap_Kameleon_setMissingValue_texinfo = "-*- texinfo -*-\n\
void\n\
Kameleon::setMissingValue(float missingValue) ";
const char* _wrap_new_MAS_texinfo = "-*- texinfo -*-\n\
ccmc::MAS::MAS() ";
const char* _wrap_Fieldline_reserve_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Fieldline::reserve(int size)\n\
\n\
Parameters:\n\
-----------\n\
\n\
size:  ";
const char* _wrap_OpenGGCM_getXGrid_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > *const ccmc::OpenGGCM::getXGrid(long variable) ";
const char* _wrap_Fieldline_getElements_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< Point3f > & ccmc::Fieldline::getElements() ";
const char* _wrap_Point3f_getCartesian_texinfo = "-*- texinfo -*-\n\
Point3f\n\
ccmc::Point3f::getCartesian() ";
const char* _wrap_Attribute_getAttributeFloat_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Attribute::getAttributeFloat()\n\
\n\
Returns the attribute value as a float, if applicable. The float value\n\
of the attribute. The value returned will be 0.f if the AttributeType\n\
of the Attribute object is not Attribute::FLOAT ";
const char* _wrap_Tracer_setInnerBoundary_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setInnerBoundary(float r_end)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
r_end:  ";
const char* _wrap_Attribute_getAttributeType_texinfo = "-*- texinfo -*-\n\
Attribute::AttributeType ccmc::Attribute::getAttributeType()\n\
\n\
AttributeType of the Attribute object ";
const char* _wrap_Kameleon_getVisUnit_texinfo = "-*- texinfo -*-\n\
std::string\n\
Kameleon::getVisUnit(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Fieldline_reverseOrderInPlace_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Fieldline::reverseOrderInPlace()\n\
\n\
TODO: finish documentation ";
const char* _wrap_delete_ENLIL_texinfo = "-*- texinfo -*-\n\
ccmc::ENLIL::~ENLIL() ";
const char* _wrap_new_ENLIL_texinfo = "-*- texinfo -*-\n\
ccmc::ENLIL::ENLIL() ";
const char* _wrap_Fieldline_getDs_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > & ccmc::Fieldline::getDs()\n\
\n\
Calculate the forward difference elements for a field line with\n\
ordered positions. Output has length fieldline.size()-1 TODO: Add\n\
backward and higher-order differencing ";
const char* _wrap_Fieldline_getPosition_texinfo = "-*- texinfo -*-\n\
const Point3f &\n\
ccmc::Fieldline::getPosition(int i)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
i:  ";
const char* _wrap_delete_Fieldline_texinfo = "-*- texinfo -*-\n\
ccmc::Fieldline::~Fieldline()\n\
\n\
TODO: finish documentation ";
const char* _wrap_new_Fieldline_texinfo = "-*- texinfo -*-\n\
ccmc::Fieldline::Fieldline(int initialSize)\n\
\n\
Parameters:\n\
-----------\n\
\n\
initialSize:  ";
const char* _wrap_Attribute_setAttributeValue_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Attribute::setAttributeValue(float &value)\n\
\n\
Copies the contents of value and stores them.\n\
\n\
Parameters:\n\
-----------\n\
\n\
value:  the new attribute value ";
const char* _wrap_SWMFIono_open_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::SWMFIono::open(const std::string &filename)\n\
\n\
Opens a file.\n\
\n\
Opens a file and performs any necessary initialization required to\n\
work with the data.\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  ";
const char* _wrap_delete_BATSRUS_texinfo = "-*- texinfo -*-\n\
ccmc::BATSRUS::~BATSRUS()\n\
\n\
Destructor ";
const char* _wrap_new_BATSRUS_texinfo = "-*- texinfo -*-\n\
ccmc::BATSRUS::BATSRUS()\n\
\n\
Default constructor ";
const char* _wrap_Tracer_setTilt_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setTilt(float tilt)\n\
\n\
Parameters:\n\
-----------\n\
\n\
tilt:  ";
const char* _wrap_OpenGGCMInterpolator_getConversionFactor_texinfo = "-*- texinfo -*-\n\
float ccmc::OpenGGCMInterpolator::getConversionFactor(const long\n\
&variable_id)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  ";
const char* _wrap_Interpolator_getConversionFactor_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Interpolator::getConversionFactor(const long &variable_id)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  ";
const char* _wrap_Fieldline_getData_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Fieldline::getData(int i)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
i:  ";
const char* _wrap_GeneralFileReader_getCurrentFilename_texinfo = "-*- texinfo -*-\n\
const std::string & ccmc::GeneralFileReader::getCurrentFilename() ";
const char* _wrap_FileReader_getCurrentFilename_texinfo = "-*- texinfo -*-\n\
virtual\n\
const std::string& ccmc::FileReader::getCurrentFilename()=0 ";
const char* _wrap_CDFFileReader_getCurrentFilename_texinfo = "-*- texinfo -*-\n\
const\n\
std::string & ccmc::CDFFileReader::getCurrentFilename()\n\
\n\
Returns the current filename. The current filename. ";
const char* _wrap_Kameleon_getCurrentFilename_texinfo = "-*- texinfo -*-\n\
const\n\
std::string & Kameleon::getCurrentFilename() ";
const char* _wrap_Model_getSIUnit_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Model::getSIUnit(const std::string &variable)\n\
\n\
Returns the SI units of the specified variable.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Kameleon_getSIUnit_texinfo = "-*- texinfo -*-\n\
std::string\n\
Kameleon::getSIUnit(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_SWMFIono_getLoadedVariables_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< std::string > ccmc::SWMFIono::getLoadedVariables()\n\
\n\
Returns the list of variables that have been loaded into memory, using\n\
the loadVariable or loadVectorVariable methods. ";
const char* _wrap_MAS_getLoadedVariables_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< std::string > ccmc::MAS::getLoadedVariables()\n\
\n\
Returns the list of variables that have been loaded into memory, using\n\
the loadVariable or loadVectorVariable methods. ";
const char* _wrap_ENLIL_getLoadedVariables_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< std::string > ccmc::ENLIL::getLoadedVariables()\n\
\n\
Returns the list of variables that have been loaded into memory, using\n\
the loadVariable or loadVectorVariable methods. ";
const char* _wrap_BATSRUS_getLoadedVariables_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< std::string > ccmc::BATSRUS::getLoadedVariables()\n\
\n\
Returns the list of variables that have been loaded into memory, using\n\
the loadVariable or loadVectorVariable methods. ";
const char* _wrap_OpenGGCM_getLoadedVariables_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< std::string > ccmc::OpenGGCM::getLoadedVariables()\n\
\n\
Returns the list of variables that have been loaded into memory, using\n\
the loadVariable or loadVectorVariable methods. ";
const char* _wrap_Model_getLoadedVariables_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< std::string > ccmc::Model::getLoadedVariables()\n\
\n\
Returns the list of variables that have been loaded into memory, using\n\
the loadVariable or loadVectorVariable methods. ";
const char* _wrap_CDFFileReader_getNumberOfVariables_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::CDFFileReader::getNumberOfVariables() ";
const char* _wrap_GeneralFileReader_getNumberOfVariables_texinfo = "-*- texinfo -*-\n\
int ccmc::GeneralFileReader::getNumberOfVariables() ";
const char* _wrap_FileReader_getNumberOfVariables_texinfo = "-*- texinfo -*-\n\
virtual int ccmc::FileReader::getNumberOfVariables()=0 ";
const char* _wrap_Kameleon_getLoadedVariables_texinfo = "-*- texinfo -*-\n\
std::vector< std::string > Kameleon::getLoadedVariables() ";
const char* _wrap_Kameleon_getNumberOfVariables_texinfo = "-*- texinfo -*-\n\
int\n\
Kameleon::getNumberOfVariables() ";
const char* _wrap_Model_getNativeUnit_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Model::getNativeUnit(const std::string &variable)\n\
\n\
Fetches the native units of the variable as stored in the file.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  Variable to request units for.\n\
\n\
The native units of the specified variable, as stored in the file. ";
const char* _wrap_Kameleon_getNativeUnit_texinfo = "-*- texinfo -*-\n\
std::string\n\
Kameleon::getNativeUnit(const std::string &variable)\n\
\n\
Returns the units of the variable specified. The units may differ from\n\
the units in the original data.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
String representation of the units ";
const char* _wrap_Model_getIntVariableFromMapRW_texinfo = "-*- texinfo -*-\n\
std::vector< int > * ccmc::Model::getIntVariableFromMapRW(long\n\
variable_id)\n\
\n\
Returns a pointer to the entry in the variableDataIntByID map\n\
containing the variable data.\n\
\n\
This pointer cannot be modified.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  Variable id of the variable to fetch from memory. This\n\
assumes the variable has already been loaded into memory. If the\n\
variable has not been loaded, the pointer will be NULL. Request the\n\
variable id by using FileReader::getVariableID(const std::string&\n\
variable)\n\
\n\
std::vector<int>* of the requested variable. Note that the pointer\n\
points to an entry in a map. The memory pointed to by the pointer will\n\
automatically be freed when the file is closed, or the Model object is\n\
deleted. ";
const char* _wrap_Model_getVariableFromMapRW_texinfo = "-*- texinfo -*-\n\
std::vector< float > * ccmc::Model::getVariableFromMapRW(long\n\
variable_id)\n\
\n\
Returns a pointer to the entry in the variableDataByID map containing\n\
the variable data.\n\
\n\
This pointer cannot be modified.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  Variable id of the variable to fetch from memory. This\n\
assumes the variable has already been loaded into memory. If the\n\
variable has not been loaded, the pointer will be NULL. Request the\n\
variable id by using FileReader::getVariableID(const std::string&\n\
variable)\n\
\n\
std::vector<float>* of the requested variable. Note that the pointer\n\
points to an entry in a map. The memory pointed to by the pointer will\n\
automatically be freed when the file is closed, or the Model object is\n\
deleted. ";
const char* _wrap_new_CDFFileReader_texinfo = "-*- texinfo -*-\n\
ccmc::CDFFileReader::CDFFileReader()\n\
\n\
Default constructor. Does nothing. ";
const char* _wrap_delete_GeneralFileReader_texinfo = "-*- texinfo -*-\n\
ccmc::GeneralFileReader::~GeneralFileReader() ";
const char* _wrap_new_GeneralFileReader_texinfo = "-*- texinfo -*-\n\
ccmc::GeneralFileReader::GeneralFileReader() ";
const char* _wrap_delete_FileReader_texinfo = "-*- texinfo -*-\n\
ccmc::FileReader::~FileReader()\n\
\n\
Destructor ";
const char* _wrap_delete_CDFFileReader_texinfo = "-*- texinfo -*-\n\
ccmc::CDFFileReader::~CDFFileReader()\n\
\n\
Destructor ";
const char* _wrap_Fieldline_getNearest_texinfo = "-*- texinfo -*-\n\
const\n\
std::vector< int > & ccmc::Fieldline::getNearest() ";
const char* _wrap_Kameleon_open_texinfo = "-*- texinfo -*-\n\
long\n\
Kameleon::open(const std::string &filename)\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  ";
const char* _wrap_Tracer_setMaxIterations_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setMaxIterations(int stepMax)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
stepMax:  ";
const char* _wrap_delete_Model_texinfo = "-*- texinfo -*-\n\
ccmc::Model::~Model()\n\
\n\
Destructor ";
const char* _wrap_Time_setMinute_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setMinute(short minute) ";
const char* _wrap_Time_getMinute_texinfo = "-*- texinfo -*-\n\
short\n\
ccmc::Time::getMinute() const ";
const char* _wrap_Tracer_findLastClosed_texinfo = "-*- texinfo -*-\n\
Fieldline\n\
ccmc::Tracer::findLastClosed(Point3f position, int stepMax)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
position:\n\
\n\
stepMax:  ";
const char* _wrap_Tracer_isClosed_texinfo = "-*- texinfo -*-\n\
bool\n\
ccmc::Tracer::isClosed(Fieldline &fieldline)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
fieldline:  ";
const char* _wrap_Model_getModelName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Model::getModelName()\n\
\n\
Returns the modelName of the currently selected file. ";
const char* _wrap_Model_setModelName_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Model::setModelName(std::string modelName)\n\
\n\
Sets the model name to modelName.\n\
\n\
Parameters:\n\
-----------\n\
\n\
modelName:  ";
const char* _wrap_Kameleon_getModelName_texinfo = "-*- texinfo -*-\n\
const\n\
std::string & Kameleon::getModelName()\n\
\n\
Returns the model name of the opened file. The model name. ";
const char* _wrap_Interpolator_getModelName_texinfo = "-*- texinfo -*-\n\
std::string\n\
ccmc::Interpolator::getModelName() ";
const char* _wrap_Model_unloadVariable_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::Model::unloadVariable(const std::string &variable)\n\
\n\
Unload a variable from memory. This will return FileReader::OK if the\n\
variable is removed from memory, and\n\
FileReader::VARIABLE_NOT_IN_MEMORY if the variable was not already in\n\
memory.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  Variable to unload from memory.\n\
\n\
status of the operation ";
const char* _wrap_Model_loadVariable_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::Model::loadVariable(const std::string &variable)\n\
\n\
Load a variable into memory.\n\
\n\
Use this method when the variable to load is of type float\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  Variable to load into memory.\n\
\n\
status of the operation ";
const char* _wrap_Fieldline_getVariable_texinfo = "-*- texinfo -*-\n\
const\n\
std::string & ccmc::Fieldline::getVariable() ";
const char* _wrap_Fieldline_setVariable_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Fieldline::setVariable(std::string variable) ";
const char* _wrap_CDFFileReader_getVariable_texinfo = "-*- texinfo -*-\n\
std::vector<\n\
float > * ccmc::CDFFileReader::getVariable(long variableID, long\n\
startIndex, long count)\n\
\n\
Returns a pointer to a std::vector<float> containing the values of the\n\
selected variable in the range specified by the startIndex and count\n\
(the number of records to read) stored in the selected file. This\n\
allocates a new std::vector<float> pointer. Make sure you delete the\n\
contents when you done using it, or you will have a memory leak.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variableID:\n\
\n\
startIndex:\n\
\n\
count:\n\
\n\
std::vector<float> containing the values of the selected variable. ";
const char* _wrap_GeneralFileReader_getVariable_texinfo = "-*- texinfo -*-\n\
std::vector< float > * ccmc::GeneralFileReader::getVariable(long\n\
variableID, long startIndex, long count) ";
const char* _wrap_FileReader_getVariable_texinfo = "-*- texinfo -*-\n\
virtual\n\
std::vector<float>* ccmc::FileReader::getVariable(long variableID,\n\
long startIndex, long count)=0 ";
const char* _wrap_Kameleon_getVariable_texinfo = "-*- texinfo -*-\n\
std::vector<\n\
float > * Kameleon::getVariable(const std::string &variable) ";
const char* _wrap_Kameleon_loadVariable_texinfo = "-*- texinfo -*-\n\
bool\n\
Kameleon::loadVariable(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Kameleon_loadVectorVariable_texinfo = "-*- texinfo -*-\n\
bool\n\
Kameleon::loadVectorVariable(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Kameleon_unloadVariable_texinfo = "-*- texinfo -*-\n\
bool\n\
Kameleon::unloadVariable(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Kameleon_unloadVectorVariable_texinfo = "-*- texinfo -*-\n\
bool\n\
Kameleon::unloadVectorVariable(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_GeneralFileReader_doesVariableExist_texinfo = "-*- texinfo -*-\n\
bool ccmc::GeneralFileReader::doesVariableExist(const std::string\n\
&variable) ";
const char* _wrap_GeneralFileReader_doesAttributeExist_texinfo = "-*- texinfo -*-\n\
bool ccmc::GeneralFileReader::doesAttributeExist(const std::string\n\
&attribute) ";
const char* _wrap_FileReader_doesVariableExist_texinfo = "-*- texinfo -*-\n\
virtual\n\
bool ccmc::FileReader::doesVariableExist(const std::string\n\
&variable)=0 ";
const char* _wrap_FileReader_doesAttributeExist_texinfo = "-*- texinfo -*-\n\
virtual\n\
bool ccmc::FileReader::doesAttributeExist(const std::string\n\
&attribute)=0 ";
const char* _wrap_CDFFileReader_doesAttributeExist_texinfo = "-*- texinfo -*-\n\
bool\n\
ccmc::CDFFileReader::doesAttributeExist(long attribute)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute:  ";
const char* _wrap_CDFFileReader_doesVariableExist_texinfo = "-*- texinfo -*-\n\
bool\n\
ccmc::CDFFileReader::doesVariableExist(long variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Kameleon_doesAttributeExist_texinfo = "-*- texinfo -*-\n\
bool\n\
Kameleon::doesAttributeExist(const std::string &attribute)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute:  ";
const char* _wrap_Kameleon_doesVariableExist_texinfo = "-*- texinfo -*-\n\
bool\n\
Kameleon::doesVariableExist(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_delete_SWMFIonoInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::SWMFIonoInterpolator::~SWMFIonoInterpolator() ";
const char* _wrap_new_SWMFIonoInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::SWMFIonoInterpolator::SWMFIonoInterpolator(Model *model) ";
const char* _wrap_delete_OpenGGCMInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::OpenGGCMInterpolator::~OpenGGCMInterpolator()\n\
\n\
Destructor ";
const char* _wrap_new_OpenGGCMInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::OpenGGCMInterpolator::OpenGGCMInterpolator(Model *modelReader)\n\
\n\
Constructor\n\
\n\
Parameters:\n\
-----------\n\
\n\
modelReader:  ";
const char* _wrap_delete_MASInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::MASInterpolator::~MASInterpolator() ";
const char* _wrap_new_MASInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::MASInterpolator::MASInterpolator(Model *model)\n\
\n\
Parameters:\n\
-----------\n\
\n\
model:  ";
const char* _wrap_delete_ENLILInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::ENLILInterpolator::~ENLILInterpolator() ";
const char* _wrap_new_ENLILInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::ENLILInterpolator::ENLILInterpolator(Model *model)\n\
\n\
Parameters:\n\
-----------\n\
\n\
model:  ";
const char* _wrap_delete_BATSRUSInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::BATSRUSInterpolator::~BATSRUSInterpolator()\n\
\n\
Destructor ";
const char* _wrap_new_BATSRUSInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::BATSRUSInterpolator::BATSRUSInterpolator(Model *modelReader)\n\
\n\
Parameters:\n\
-----------\n\
\n\
modelReader:  Pointer to the Model object containing the appropriate\n\
variable maps. BATSRUSInterpolator should be returned by a\n\
BATSRUS::createNewInterpolator() call.\n\
\n\
They are stored as floats. Need to fetch them, and convert to int ";
const char* _wrap_SWMFIono_createNewInterpolator_texinfo = "-*- texinfo -*-\n\
Interpolator * ccmc::SWMFIono::createNewInterpolator()\n\
\n\
Returns an Interpolator object for the currently opened file.\n\
\n\
This returns an Interpolator object that contains all the necessary\n\
local variables required to interpolate independent of any other\n\
Interpolator object. The pointer must be deleted from the calling\n\
program. A pointer to an Interpolator object. ";
const char* _wrap_MAS_createNewInterpolator_texinfo = "-*- texinfo -*-\n\
Interpolator\n\
* ccmc::MAS::createNewInterpolator()\n\
\n\
Returns an Interpolator object for the currently opened file.\n\
\n\
This returns an Interpolator object that contains all the necessary\n\
local variables required to interpolate independent of any other\n\
Interpolator object. The pointer must be deleted from the calling\n\
program. A pointer to an Interpolator object. ";
const char* _wrap_ENLIL_createNewInterpolator_texinfo = "-*- texinfo -*-\n\
Interpolator * ccmc::ENLIL::createNewInterpolator()\n\
\n\
Returns an Interpolator object for the currently opened file.\n\
\n\
This returns an Interpolator object that contains all the necessary\n\
local variables required to interpolate independent of any other\n\
Interpolator object. The pointer must be deleted from the calling\n\
program. A pointer to an Interpolator object. ";
const char* _wrap_BATSRUS_createNewInterpolator_texinfo = "-*- texinfo -*-\n\
Interpolator * ccmc::BATSRUS::createNewInterpolator()\n\
\n\
Returns an Interpolator object for the currently opened file.\n\
\n\
This returns an Interpolator object that contains all the necessary\n\
local variables required to interpolate independent of any other\n\
Interpolator object. The pointer must be deleted from the calling\n\
program. A pointer to an Interpolator object. ";
const char* _wrap_OpenGGCM_createNewInterpolator_texinfo = "-*- texinfo -*-\n\
Interpolator * ccmc::OpenGGCM::createNewInterpolator()\n\
\n\
Returns an Interpolator object for the currently opened file.\n\
\n\
This returns an Interpolator object that contains all the necessary\n\
local variables required to interpolate independent of any other\n\
Interpolator object. The pointer must be deleted from the calling\n\
program. A pointer to an Interpolator object. ";
const char* _wrap_Model_createNewInterpolator_texinfo = "-*- texinfo -*-\n\
virtual\n\
Interpolator* ccmc::Model::createNewInterpolator()=0\n\
\n\
Returns an Interpolator object for the currently opened file.\n\
\n\
This returns an Interpolator object that contains all the necessary\n\
local variables required to interpolate independent of any other\n\
Interpolator object. The pointer must be deleted from the calling\n\
program. A pointer to an Interpolator object. ";
const char* _wrap_Kameleon_createNewInterpolator_texinfo = "-*- texinfo -*-\n\
Interpolator * Kameleon::createNewInterpolator()\n\
\n\
Returns a new interpolater that maintains state information\n\
independent of other interpolators. This can be used to parallelize\n\
the interpolations. A new interpolator. ";
const char* _wrap_delete_Interpolator_texinfo = "-*- texinfo -*-\n\
ccmc::Interpolator::~Interpolator()\n\
\n\
Destructor ";
const char* _wrap_new_KameleonInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::KameleonInterpolator::KameleonInterpolator(Model *modelReader)\n\
\n\
Parameters:\n\
-----------\n\
\n\
model:  ";
const char* _wrap_delete_KameleonInterpolator_texinfo = "-*- texinfo -*-\n\
ccmc::KameleonInterpolator::~KameleonInterpolator() ";
const char* _wrap_GeneralFileReader_getVariableName_texinfo = "-*- texinfo -*-\n\
std::string ccmc::GeneralFileReader::getVariableName(long variable_id)\n\
";
const char* _wrap_FileReader_getVariableName_texinfo = "-*- texinfo -*-\n\
virtual\n\
std::string ccmc::FileReader::getVariableName(long variable_id)=0 ";
const char* _wrap_CDFFileReader_getVariableName_texinfo = "-*- texinfo -*-\n\
std::string ccmc::CDFFileReader::getVariableName(long variable_id)\n\
\n\
Returns the string representation of the variable referred to by\n\
variable_id String representation of the variable. ";
const char* _wrap_Kameleon_getVariableName_texinfo = "-*- texinfo -*-\n\
std::string\n\
Kameleon::getVariableName(long variable_id)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable_id:  ";
const char* _wrap_Tracer_getVector_texinfo = "-*- texinfo -*-\n\
Point3f\n\
ccmc::Tracer::getVector(const std::string &variable, const Point3f\n\
&position, float &dComponent1, float &dComponent2, float &dComponent3,\n\
const Interpolator *interpolator)\n\
\n\
check to see if iterations are greater than or equal to max I should\n\
have changed the name but it would have been too long TODO: finish\n\
documentation TODO: return missing value if variable not found TODO:\n\
use a map instead of an if/else statement to check for the variable\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
position:\n\
\n\
dComponent1:\n\
\n\
dComponent2:\n\
\n\
dComponent3:\n\
\n\
interpolator:  ";
const char* _wrap_delete_MAS_texinfo = "-*- texinfo -*-\n\
ccmc::MAS::~MAS() ";
const char* _wrap_FileReader_initializeVariableIDs_texinfo = "-*- texinfo -*-\n\
virtual void ccmc::FileReader::initializeVariableIDs()=0 ";
const char* _wrap_FileReader_closeFile_texinfo = "-*- texinfo -*-\n\
virtual long\n\
ccmc::FileReader::closeFile()=0 ";
const char* _wrap_GeneralFileReader_getVariableID_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::GeneralFileReader::getVariableID(const std::string &variable) ";
const char* _wrap_FileReader_getVariableID_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::FileReader::getVariableID(const std::string &variable)=0\n\
\n\
Returns the variable ID as a long. Using the variable ID wherever\n\
possible is significantly faster than the equivalent methods accepting\n\
the variable string. Status of the file operation. ";
const char* _wrap_CDFFileReader_getVariableID_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::CDFFileReader::getVariableID(const std::string &variable)\n\
\n\
Returns the variable ID as a long. Using the variable ID wherever\n\
possible is significantly faster than the equivalent methods accepting\n\
the variable string. Status of the file operation. ";
const char* _wrap_Kameleon_getVariableID_texinfo = "-*- texinfo -*-\n\
long\n\
Kameleon::getVariableID(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Fieldline_integrate_texinfo = "-*- texinfo -*-\n\
const std::vector<\n\
float > & ccmc::Fieldline::integrate()\n\
\n\
Calculate the integral of ds*values over the length of the field line\n\
\n\
TODO: Change integration so that it multiplies the element lengths by\n\
the average of the data on either side of the element ";
const char* _wrap_OpenGGCM_open_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::OpenGGCM::open(const std::string &filename)\n\
\n\
Opens a file.\n\
\n\
Opens a file and performs any necessary initialization required to\n\
work with the data.\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  ";
const char* _wrap_Fieldline_insertPointData_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Fieldline::insertPointData(const Point3f &p, const float &d)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
p:\n\
\n\
d:  ";
const char* _wrap_FileReader_getGlobalAttributeID_texinfo = "-*- texinfo -*-\n\
virtual long ccmc::FileReader::getGlobalAttributeID(const std::string\n\
&attribute)=0 ";
const char* _wrap_CDFFileReader_getGlobalAttributeID_texinfo = "-*- texinfo -*-\n\
long ccmc::CDFFileReader::getGlobalAttributeID(const std::string\n\
&attribute)\n\
\n\
Parameters:\n\
-----------\n\
\n\
attribute:  ";
const char* _wrap_Fieldline_setStartPoint_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Fieldline::setStartPoint(Point3f p)\n\
\n\
TODO: finish documentation\n\
\n\
Parameters:\n\
-----------\n\
\n\
startPoint:  ";
const char* _wrap_Fieldline_getStartPoint_texinfo = "-*- texinfo -*-\n\
Point3f\n\
ccmc::Fieldline::getStartPoint()\n\
\n\
TODO: finish documentation ";
const char* _wrap_Model_loadVariableInt_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::Model::loadVariableInt(const std::string &variable)\n\
\n\
Loads a variable into memory.\n\
\n\
Use this method when the variable to load is of type int\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
status of the operation ";
const char* _wrap_CDFFileReader_getVariableInt_texinfo = "-*- texinfo -*-\n\
std::vector< int > * ccmc::CDFFileReader::getVariableInt(const\n\
std::string &variable)\n\
\n\
This allocates a new std::vector<int> pointer. Make sure you delete\n\
the contents when you done using it, or you will have a memory leak.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:\n\
\n\
vector<int> containing the integer values of the variable ";
const char* _wrap_GeneralFileReader_getVariableInt_texinfo = "-*- texinfo -*-\n\
std::vector< int > * ccmc::GeneralFileReader::getVariableInt(const\n\
std::string &variable) ";
const char* _wrap_FileReader_getVariableInt_texinfo = "-*- texinfo -*-\n\
virtual\n\
std::vector<int>* ccmc::FileReader::getVariableInt(const std::string\n\
&variable)=0 ";
const char* _wrap_Kameleon_getVariableInt_texinfo = "-*- texinfo -*-\n\
std::vector<\n\
int > * Kameleon::getVariableInt(const std::string &variable)\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";
const char* _wrap_Point3f_distance_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Point3f::distance(const Point3f &p) const\n\
\n\
compute the distance between this point, and Point p TODO: finish\n\
documentation ";
const char* _wrap_Kameleon_getCurrentTime_texinfo = "-*- texinfo -*-\n\
Time\n\
Kameleon::getCurrentTime()\n\
\n\
Calculates the current time based on the start time and the elapsed\n\
time. Formatted string of the current time. This is currently\n\
different for different models. If the current time cannot be\n\
calculated, \"TIME_UNAVAILABLE\" is returned. ";
const char* _wrap_Fieldline_size_texinfo = "-*- texinfo -*-\n\
int\n\
ccmc::Fieldline::size()\n\
\n\
TODO: finish documentation ";
const char* _wrap_Model_open_texinfo = "-*- texinfo -*-\n\
virtual long\n\
ccmc::Model::open(const std::string &filename)=0\n\
\n\
Opens a file.\n\
\n\
Opens a file and performs any necessary initialization required to\n\
work with the data.\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  ";
const char* _wrap_Time_setSeconds_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setSeconds(double seconds) ";
const char* _wrap_Time_getSeconds_texinfo = "-*- texinfo -*-\n\
short\n\
ccmc::Time::getSeconds() const ";
const char* _wrap_Time_setMilliseconds_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Time::setMilliseconds(short milliseconds) ";
const char* _wrap_Time_getMilliseconds_texinfo = "-*- texinfo -*-\n\
short\n\
ccmc::Time::getMilliseconds() const ";
const char* _wrap_ENLIL_open_texinfo = "-*- texinfo -*-\n\
long\n\
ccmc::ENLIL::open(const std::string &filename)\n\
\n\
Opens a file.\n\
\n\
Opens a file and performs any necessary initialization required to\n\
work with the data.\n\
\n\
Parameters:\n\
-----------\n\
\n\
filename:  ";
const char* _wrap_Tracer_setUseRegionOfInterest_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setUseRegionOfInterest(bool useROI)\n\
\n\
Parameters:\n\
-----------\n\
\n\
useROI:  ";
const char* _wrap_Tracer_setRegionOfInterest_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setRegionOfInterest(Point3f min, Point3f max)\n\
\n\
Parameters:\n\
-----------\n\
\n\
min:\n\
\n\
max:  ";
const char* _wrap_Fieldline_getLength_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Fieldline::getLength(int i)\n\
\n\
Get the length up to position i ";
const char* _wrap_Tracer_setUseMaxArcLength_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setUseMaxArcLength(bool useMaxArcLength)\n\
\n\
Parameters:\n\
-----------\n\
\n\
useMaxArcLength:  ";
const char* _wrap_Tracer_setMaxArcLength_texinfo = "-*- texinfo -*-\n\
void\n\
ccmc::Tracer::setMaxArcLength(float maxArcLength)\n\
\n\
Parameters:\n\
-----------\n\
\n\
maxArcLength:  ";
const char* _wrap_Model_getConversionFactorToSI_texinfo = "-*- texinfo -*-\n\
float\n\
ccmc::Model::getConversionFactorToSI(const std::string &variable)\n\
\n\
Returns the conversion factor needed to convert the interpolated value\n\
to SI units.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  Variable to request the conversion factor for.\n\
\n\
Conversion factor to convert the specified variable to SI units ";
const char* _wrap_Kameleon_getConversionFactorToSI_texinfo = "-*- texinfo -*-\n\
float\n\
Kameleon::getConversionFactorToSI(const std::string &variable)\n\
\n\
Currently not implemented.\n\
\n\
Parameters:\n\
-----------\n\
\n\
variable:  ";

SWIG_DEFUN( delete_OctSwigIterator, _wrap_delete_OctSwigIterator, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_OctSwigIterator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_OctSwigIterator" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_value, _wrap_OctSwigIterator_value, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  octave_value result;
  
  if (!SWIG_check_num_args("OctSwigIterator_value",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_value" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  try {
    result = ((swig::OctSwigIterator const *)arg1)->value();
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = result;
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OctSwigIterator_incr__SWIG_0 (const octave_value_list& args, int nargout) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  size_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator_incr",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_incr" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OctSwigIterator_incr" "', argument " "2"" of type '" "size_t""'");
  } 
  arg2 = (size_t)(val2);
  try {
    result = (swig::OctSwigIterator *)(arg1)->incr(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OctSwigIterator_incr__SWIG_1 (const octave_value_list& args, int nargout) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator_incr",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_incr" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  try {
    result = (swig::OctSwigIterator *)(arg1)->incr();
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_incr, _wrap_OctSwigIterator_incr, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__OctSwigIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_OctSwigIterator_incr__SWIG_1(args, nargout);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__OctSwigIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OctSwigIterator_incr__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_OctSwigIterator_decr__SWIG_0 (const octave_value_list& args, int nargout) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  size_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator_decr",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_decr" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OctSwigIterator_decr" "', argument " "2"" of type '" "size_t""'");
  } 
  arg2 = (size_t)(val2);
  try {
    result = (swig::OctSwigIterator *)(arg1)->decr(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OctSwigIterator_decr__SWIG_1 (const octave_value_list& args, int nargout) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator_decr",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_decr" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  try {
    result = (swig::OctSwigIterator *)(arg1)->decr();
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_decr, _wrap_OctSwigIterator_decr, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__OctSwigIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_OctSwigIterator_decr__SWIG_1(args, nargout);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__OctSwigIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OctSwigIterator_decr__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( OctSwigIterator_distance, _wrap_OctSwigIterator_distance, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  swig::OctSwigIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ptrdiff_t result;
  
  if (!SWIG_check_num_args("OctSwigIterator_distance",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_distance" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_swig__OctSwigIterator,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OctSwigIterator_distance" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OctSwigIterator_distance" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  arg2 = (swig::OctSwigIterator *)(argp2);
  try {
    result = ((swig::OctSwigIterator const *)arg1)->distance((swig::OctSwigIterator const &)*arg2);
  }
  catch(std::invalid_argument &_e) {
    error("C++ side threw an exception of type " "std::invalid_argument"); SWIG_fail;
  }
  
  _outv = SWIG_From_ptrdiff_t((ptrdiff_t)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_equal, _wrap_OctSwigIterator_equal, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  swig::OctSwigIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("OctSwigIterator_equal",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_equal" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_swig__OctSwigIterator,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OctSwigIterator_equal" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OctSwigIterator_equal" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  arg2 = (swig::OctSwigIterator *)(argp2);
  try {
    result = (bool)((swig::OctSwigIterator const *)arg1)->equal((swig::OctSwigIterator const &)*arg2);
  }
  catch(std::invalid_argument &_e) {
    error("C++ side threw an exception of type " "std::invalid_argument"); SWIG_fail;
  }
  
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_copy, _wrap_OctSwigIterator_copy, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator_copy",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_copy" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  result = (swig::OctSwigIterator *)((swig::OctSwigIterator const *)arg1)->copy();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_next, _wrap_OctSwigIterator_next, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  octave_value result;
  
  if (!SWIG_check_num_args("OctSwigIterator_next",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_next" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  try {
    result = (arg1)->next();
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = result;
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_previous, _wrap_OctSwigIterator_previous, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  octave_value result;
  
  if (!SWIG_check_num_args("OctSwigIterator_previous",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_previous" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  try {
    result = (arg1)->previous();
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = result;
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator_advance, _wrap_OctSwigIterator_advance, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator_advance",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator_advance" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OctSwigIterator_advance" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = (ptrdiff_t)(val2);
  try {
    result = (swig::OctSwigIterator *)(arg1)->advance(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator___eq__, _wrap_OctSwigIterator___eq__, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  swig::OctSwigIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("OctSwigIterator___eq__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator___eq__" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_swig__OctSwigIterator,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OctSwigIterator___eq__" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OctSwigIterator___eq__" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  arg2 = (swig::OctSwigIterator *)(argp2);
  result = (bool)((swig::OctSwigIterator const *)arg1)->operator ==((swig::OctSwigIterator const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator___ne__, _wrap_OctSwigIterator___ne__, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  swig::OctSwigIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("OctSwigIterator___ne__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator___ne__" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_swig__OctSwigIterator,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OctSwigIterator___ne__" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OctSwigIterator___ne__" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  arg2 = (swig::OctSwigIterator *)(argp2);
  result = (bool)((swig::OctSwigIterator const *)arg1)->operator !=((swig::OctSwigIterator const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator___incr__, _wrap_OctSwigIterator___incr__, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator___incr__",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator___incr__" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  result = (swig::OctSwigIterator *)(arg1)->operator ++();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator___decr__, _wrap_OctSwigIterator___decr__, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator___decr__",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator___decr__" "', argument " "1"" of type '" "swig::OctSwigIterator *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  result = (swig::OctSwigIterator *)(arg1)->operator --();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator___add__, _wrap_OctSwigIterator___add__, std::string() ) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator___add__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator___add__" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OctSwigIterator___add__" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = (ptrdiff_t)(val2);
  try {
    result = (swig::OctSwigIterator *)((swig::OctSwigIterator const *)arg1)->operator +(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OctSwigIterator___sub____SWIG_0 (const octave_value_list& args, int nargout) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  ptrdiff_t arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  swig::OctSwigIterator *result = 0 ;
  
  if (!SWIG_check_num_args("OctSwigIterator___sub__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator___sub__" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OctSwigIterator___sub__" "', argument " "2"" of type '" "ptrdiff_t""'");
  } 
  arg2 = (ptrdiff_t)(val2);
  try {
    result = (swig::OctSwigIterator *)((swig::OctSwigIterator const *)arg1)->operator -(arg2);
  }
  catch(swig::stop_iteration &_e) {
    {
      error("stop_iteration exception");
      SWIG_fail;
    }
  }
  
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_swig__OctSwigIterator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OctSwigIterator___sub____SWIG_1 (const octave_value_list& args, int nargout) {
  swig::OctSwigIterator *arg1 = (swig::OctSwigIterator *) 0 ;
  swig::OctSwigIterator *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ptrdiff_t result;
  
  if (!SWIG_check_num_args("OctSwigIterator___sub__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_swig__OctSwigIterator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OctSwigIterator___sub__" "', argument " "1"" of type '" "swig::OctSwigIterator const *""'"); 
  }
  arg1 = (swig::OctSwigIterator *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_swig__OctSwigIterator,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OctSwigIterator___sub__" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OctSwigIterator___sub__" "', argument " "2"" of type '" "swig::OctSwigIterator const &""'"); 
  }
  arg2 = (swig::OctSwigIterator *)(argp2);
  result = ((swig::OctSwigIterator const *)arg1)->operator -((swig::OctSwigIterator const &)*arg2);
  _outv = SWIG_From_ptrdiff_t((ptrdiff_t)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OctSwigIterator___sub__, _wrap_OctSwigIterator___sub__, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__OctSwigIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_swig__OctSwigIterator, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OctSwigIterator___sub____SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_swig__OctSwigIterator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_ptrdiff_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OctSwigIterator___sub____SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static swig_octave_member swig_OctSwigIterator_members[] = {
{"value",_wrap_OctSwigIterator_value,0,0,0,0},
{"incr",_wrap_OctSwigIterator_incr,0,0,0,0},
{"decr",_wrap_OctSwigIterator_decr,0,0,0,0},
{"distance",_wrap_OctSwigIterator_distance,0,0,0,0},
{"equal",_wrap_OctSwigIterator_equal,0,0,0,0},
{"copy",_wrap_OctSwigIterator_copy,0,0,0,0},
{"next",_wrap_OctSwigIterator_next,0,0,0,0},
{"previous",_wrap_OctSwigIterator_previous,0,0,0,0},
{"advance",_wrap_OctSwigIterator_advance,0,0,0,0},
{"__eq__",_wrap_OctSwigIterator___eq__,0,0,0,0},
{"__ne__",_wrap_OctSwigIterator___ne__,0,0,0,0},
{"__incr__",_wrap_OctSwigIterator___incr__,0,0,0,0},
{"__decr__",_wrap_OctSwigIterator___decr__,0,0,0,0},
{"__add__",_wrap_OctSwigIterator___add__,0,0,0,0},
{"__sub__",_wrap_OctSwigIterator___sub__,0,0,0,0},
{0,0,0,0}
};
static const char *swig_OctSwigIterator_base_names[] = {0};
static const swig_type_info *swig_OctSwigIterator_base[] = {0};
static swig_octave_class _wrap_class_OctSwigIterator = {"OctSwigIterator", &SWIGTYPE_p_swig__OctSwigIterator,0,0,0,_wrap_delete_OctSwigIterator,swig_OctSwigIterator_members,swig_OctSwigIterator_base_names,swig_OctSwigIterator_base };

static octave_value_list _wrap_FileReader_open__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  bool val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_open",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_open" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_bool(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_open" "', argument " "3"" of type '" "bool""'");
  } 
  arg3 = (bool)(val3);
  result = (long)(arg1)->open((std::string const &)*arg2,arg3);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_open__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_open" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_open, _wrap_FileReader_open, _wrap_FileReader_open_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_FileReader_open__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_bool(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_FileReader_open__SWIG_0(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_FileReader_getVariable__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("FileReader_getVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariable" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getVariable__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("FileReader_getVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariable" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getVariable" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getVariable__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  long arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  long val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("FileReader_getVariable",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariable" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_getVariable" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  ecode4 = SWIG_AsVal_long(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "FileReader_getVariable" "', argument " "4"" of type '" "long""'");
  } 
  arg4 = (long)(val4);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable((std::string const &)*arg2,arg3,arg4);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getVariable__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  long arg3 ;
  long arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  long val3 ;
  int ecode3 = 0 ;
  long val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("FileReader_getVariable",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariable" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getVariable" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_getVariable" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  ecode4 = SWIG_AsVal_long(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "FileReader_getVariable" "', argument " "4"" of type '" "long""'");
  } 
  arg4 = (long)(val4);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable(arg2,arg3,arg4);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getVariable, _wrap_FileReader_getVariable, _wrap_FileReader_getVariable_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[4]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_FileReader_getVariable__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_FileReader_getVariable__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_long(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_FileReader_getVariable__SWIG_3(args, nargout);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_long(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_FileReader_getVariable__SWIG_2(args, nargout);
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_FileReader_getVariableAtIndex__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("FileReader_getVariableAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableAtIndex" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getVariableAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariableAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_getVariableAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (float)(arg1)->getVariableAtIndex((std::string const &)*arg2,arg3);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getVariableAtIndex__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("FileReader_getVariableAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableAtIndex" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getVariableAtIndex" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_getVariableAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (float)(arg1)->getVariableAtIndex(arg2,arg3);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getVariableAtIndex, _wrap_FileReader_getVariableAtIndex, _wrap_FileReader_getVariableAtIndex_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_FileReader_getVariableAtIndex__SWIG_1(args, nargout);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_FileReader_getVariableAtIndex__SWIG_0(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( FileReader_getVariableInt, _wrap_FileReader_getVariableInt, _wrap_FileReader_getVariableInt_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("FileReader_getVariableInt",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableInt" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getVariableInt((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getVariableIntAtIndex, _wrap_FileReader_getVariableIntAtIndex, _wrap_FileReader_getVariableIntAtIndex_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("FileReader_getVariableIntAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableIntAtIndex" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getVariableIntAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariableIntAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_getVariableIntAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (int)(arg1)->getVariableIntAtIndex((std::string const &)*arg2,arg3);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getNumberOfGlobalAttributes, _wrap_FileReader_getNumberOfGlobalAttributes, _wrap_FileReader_getNumberOfGlobalAttributes_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("FileReader_getNumberOfGlobalAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getNumberOfGlobalAttributes" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  result = (int)(arg1)->getNumberOfGlobalAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getNumberOfVariables, _wrap_FileReader_getNumberOfVariables, _wrap_FileReader_getNumberOfVariables_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("FileReader_getNumberOfVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getNumberOfVariables" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  result = (int)(arg1)->getNumberOfVariables();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getNumberOfVariableAttributes, _wrap_FileReader_getNumberOfVariableAttributes, _wrap_FileReader_getNumberOfVariableAttributes_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("FileReader_getNumberOfVariableAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getNumberOfVariableAttributes" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  result = (int)(arg1)->getNumberOfVariableAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getNumberOfRecords__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_getNumberOfRecords",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getNumberOfRecords" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getNumberOfRecords" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getNumberOfRecords" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getNumberOfRecords((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getNumberOfRecords__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_getNumberOfRecords",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getNumberOfRecords" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getNumberOfRecords" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (long)(arg1)->getNumberOfRecords(arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getNumberOfRecords, _wrap_FileReader_getNumberOfRecords, _wrap_FileReader_getNumberOfRecords_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_FileReader_getNumberOfRecords__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_FileReader_getNumberOfRecords__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( FileReader_getVariableID, _wrap_FileReader_getVariableID, _wrap_FileReader_getVariableID_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_getVariableID",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableID" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getVariableID((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getVariableName, _wrap_FileReader_getVariableName, _wrap_FileReader_getVariableName_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("FileReader_getVariableName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableName" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getVariableName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getGlobalAttribute__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("FileReader_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getGlobalAttribute" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttribute(arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getGlobalAttributeName, _wrap_FileReader_getGlobalAttributeName, _wrap_FileReader_getGlobalAttributeName_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("FileReader_getGlobalAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getGlobalAttributeName" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getGlobalAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getVariableAttributeName, _wrap_FileReader_getVariableAttributeName, _wrap_FileReader_getVariableAttributeName_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("FileReader_getVariableAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableAttributeName" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "FileReader_getVariableAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_FileReader_getGlobalAttribute__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("FileReader_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getGlobalAttribute((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getGlobalAttribute, _wrap_FileReader_getGlobalAttribute, _wrap_FileReader_getGlobalAttribute_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_FileReader_getGlobalAttribute__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__FileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_FileReader_getGlobalAttribute__SWIG_1(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( FileReader_getGlobalAttributeID, _wrap_FileReader_getGlobalAttributeID, _wrap_FileReader_getGlobalAttributeID_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_getGlobalAttributeID",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getGlobalAttributeID" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getGlobalAttributeID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getGlobalAttributeID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getGlobalAttributeID((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getVariableAttribute, _wrap_FileReader_getVariableAttribute, _wrap_FileReader_getVariableAttribute_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  int res3 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("FileReader_getVariableAttribute",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableAttribute" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  {
    std::string *ptr = (std::string *)0;
    res3 = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "FileReader_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    arg3 = ptr;
  }
  result = (arg1)->getVariableAttribute((std::string const &)*arg2,(std::string const &)*arg3);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
  if (SWIG_IsNewObj(res3)) delete arg3;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getVariableAttributeNames, _wrap_FileReader_getVariableAttributeNames, _wrap_FileReader_getVariableAttributeNames_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("FileReader_getVariableAttributeNames",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getVariableAttributeNames" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  result = (arg1)->getVariableAttributeNames();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_doesAttributeExist, _wrap_FileReader_doesAttributeExist, _wrap_FileReader_doesAttributeExist_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("FileReader_doesAttributeExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_doesAttributeExist" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesAttributeExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_doesVariableExist, _wrap_FileReader_doesVariableExist, _wrap_FileReader_doesVariableExist_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("FileReader_doesVariableExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_doesVariableExist" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesVariableExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_addVariableName, _wrap_FileReader_addVariableName, std::string() ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("FileReader_addVariableName",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_addVariableName" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_addVariableName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_addVariableName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_addVariableName" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  (arg1)->addVariableName((std::string const &)*arg2,arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( FileReader_close, _wrap_FileReader_close, _wrap_FileReader_close_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_close",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_close" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  result = (long)(arg1)->close();
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_getCurrentFilename, _wrap_FileReader_getCurrentFilename, _wrap_FileReader_getCurrentFilename_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string *result = 0 ;
  
  if (!SWIG_check_num_args("FileReader_getCurrentFilename",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_getCurrentFilename" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  result = (std::string *) &(arg1)->getCurrentFilename();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_initializeVariableIDs, _wrap_FileReader_initializeVariableIDs, _wrap_FileReader_initializeVariableIDs_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("FileReader_initializeVariableIDs",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_initializeVariableIDs" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  (arg1)->initializeVariableIDs();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_initializeVariableNames, _wrap_FileReader_initializeVariableNames, _wrap_FileReader_initializeVariableNames_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("FileReader_initializeVariableNames",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_initializeVariableNames" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  (arg1)->initializeVariableNames();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_closeFile, _wrap_FileReader_closeFile, _wrap_FileReader_closeFile_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_closeFile",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_closeFile" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  result = (long)(arg1)->closeFile();
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( FileReader_openFile, _wrap_FileReader_openFile, _wrap_FileReader_openFile_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  std::string *arg2 = 0 ;
  bool arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  bool val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("FileReader_openFile",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "FileReader_openFile" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "FileReader_openFile" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "FileReader_openFile" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_bool(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "FileReader_openFile" "', argument " "3"" of type '" "bool""'");
  } 
  arg3 = (bool)(val3);
  result = (long)(arg1)->openFile((std::string const &)*arg2,arg3);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( delete_FileReader, _wrap_delete_FileReader, _wrap_delete_FileReader_texinfo ) {
  ccmc::FileReader *arg1 = (ccmc::FileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_FileReader",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__FileReader, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_FileReader" "', argument " "1"" of type '" "ccmc::FileReader *""'"); 
  }
  arg1 = (ccmc::FileReader *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_FileReader_members[] = {
{"open",_wrap_FileReader_open,0,0,0,0},
{"getVariable",_wrap_FileReader_getVariable,0,0,0,0},
{"getVariableAtIndex",_wrap_FileReader_getVariableAtIndex,0,0,0,0},
{"getVariableInt",_wrap_FileReader_getVariableInt,0,0,0,0},
{"getVariableIntAtIndex",_wrap_FileReader_getVariableIntAtIndex,0,0,0,0},
{"getNumberOfGlobalAttributes",_wrap_FileReader_getNumberOfGlobalAttributes,0,0,0,0},
{"getNumberOfVariables",_wrap_FileReader_getNumberOfVariables,0,0,0,0},
{"getNumberOfVariableAttributes",_wrap_FileReader_getNumberOfVariableAttributes,0,0,0,0},
{"getNumberOfRecords",_wrap_FileReader_getNumberOfRecords,0,0,0,0},
{"getVariableID",_wrap_FileReader_getVariableID,0,0,0,0},
{"getVariableName",_wrap_FileReader_getVariableName,0,0,0,0},
{"getGlobalAttributeName",_wrap_FileReader_getGlobalAttributeName,0,0,0,0},
{"getVariableAttributeName",_wrap_FileReader_getVariableAttributeName,0,0,0,0},
{"getGlobalAttribute",_wrap_FileReader_getGlobalAttribute,0,0,0,0},
{"getGlobalAttributeID",_wrap_FileReader_getGlobalAttributeID,0,0,0,0},
{"getVariableAttribute",_wrap_FileReader_getVariableAttribute,0,0,0,0},
{"getVariableAttributeNames",_wrap_FileReader_getVariableAttributeNames,0,0,0,0},
{"doesAttributeExist",_wrap_FileReader_doesAttributeExist,0,0,0,0},
{"doesVariableExist",_wrap_FileReader_doesVariableExist,0,0,0,0},
{"addVariableName",_wrap_FileReader_addVariableName,0,0,0,0},
{"close",_wrap_FileReader_close,0,0,0,0},
{"getCurrentFilename",_wrap_FileReader_getCurrentFilename,0,0,0,0},
{"initializeVariableIDs",_wrap_FileReader_initializeVariableIDs,0,0,0,0},
{"initializeVariableNames",_wrap_FileReader_initializeVariableNames,0,0,0,0},
{"closeFile",_wrap_FileReader_closeFile,0,0,0,0},
{"openFile",_wrap_FileReader_openFile,0,0,0,0},
{0,0,0,0}
};
static const char *swig_FileReader_base_names[] = {0};
static const swig_type_info *swig_FileReader_base[] = {0};
static swig_octave_class _wrap_class_FileReader = {"FileReader", &SWIGTYPE_p_ccmc__FileReader,0,0,0,_wrap_delete_FileReader,swig_FileReader_members,swig_FileReader_base_names,swig_FileReader_base };

SWIG_DEFUN( new_GeneralFileReader, _wrap_new_GeneralFileReader, _wrap_new_GeneralFileReader_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::GeneralFileReader *result = 0 ;
  
  if (!SWIG_check_num_args("new_GeneralFileReader",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::GeneralFileReader *)new ccmc::GeneralFileReader();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__GeneralFileReader, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_open, _wrap_GeneralFileReader_open, _wrap_GeneralFileReader_open_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("GeneralFileReader_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_open" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getVariable__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariable" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getVariable__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariable" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getVariable" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getVariable__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  long arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  long val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariable",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariable" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "GeneralFileReader_getVariable" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  ecode4 = SWIG_AsVal_long(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "GeneralFileReader_getVariable" "', argument " "4"" of type '" "long""'");
  } 
  arg4 = (long)(val4);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable((std::string const &)*arg2,arg3,arg4);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getVariable__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  long arg3 ;
  long arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  long val3 ;
  int ecode3 = 0 ;
  long val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariable",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariable" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getVariable" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "GeneralFileReader_getVariable" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  ecode4 = SWIG_AsVal_long(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "GeneralFileReader_getVariable" "', argument " "4"" of type '" "long""'");
  } 
  arg4 = (long)(val4);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable(arg2,arg3,arg4);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getVariable, _wrap_GeneralFileReader_getVariable, _wrap_GeneralFileReader_getVariable_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[4]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_GeneralFileReader_getVariable__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_GeneralFileReader_getVariable__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_long(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_GeneralFileReader_getVariable__SWIG_3(args, nargout);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_long(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_GeneralFileReader_getVariable__SWIG_2(args, nargout);
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_GeneralFileReader_getVariableAtIndex__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableAtIndex" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getVariableAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariableAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "GeneralFileReader_getVariableAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (float)(arg1)->getVariableAtIndex((std::string const &)*arg2,arg3);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getVariableAtIndex__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableAtIndex" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getVariableAtIndex" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "GeneralFileReader_getVariableAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (float)(arg1)->getVariableAtIndex(arg2,arg3);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getVariableAtIndex, _wrap_GeneralFileReader_getVariableAtIndex, _wrap_GeneralFileReader_getVariableAtIndex_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_GeneralFileReader_getVariableAtIndex__SWIG_1(args, nargout);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_GeneralFileReader_getVariableAtIndex__SWIG_0(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( GeneralFileReader_getVariableInt, _wrap_GeneralFileReader_getVariableInt, _wrap_GeneralFileReader_getVariableInt_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableInt",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableInt" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getVariableInt((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getVariableIntAtIndex, _wrap_GeneralFileReader_getVariableIntAtIndex, _wrap_GeneralFileReader_getVariableIntAtIndex_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableIntAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableIntAtIndex" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getVariableIntAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariableIntAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "GeneralFileReader_getVariableIntAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (int)(arg1)->getVariableIntAtIndex((std::string const &)*arg2,arg3);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getNumberOfGlobalAttributes, _wrap_GeneralFileReader_getNumberOfGlobalAttributes, _wrap_GeneralFileReader_getNumberOfGlobalAttributes_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getNumberOfGlobalAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getNumberOfGlobalAttributes" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  result = (int)(arg1)->getNumberOfGlobalAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getNumberOfVariables, _wrap_GeneralFileReader_getNumberOfVariables, _wrap_GeneralFileReader_getNumberOfVariables_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getNumberOfVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getNumberOfVariables" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  result = (int)(arg1)->getNumberOfVariables();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getNumberOfVariableAttributes, _wrap_GeneralFileReader_getNumberOfVariableAttributes, _wrap_GeneralFileReader_getNumberOfVariableAttributes_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getNumberOfVariableAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getNumberOfVariableAttributes" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  result = (int)(arg1)->getNumberOfVariableAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getNumberOfRecords__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getNumberOfRecords",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getNumberOfRecords" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getNumberOfRecords" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getNumberOfRecords" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getNumberOfRecords((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getNumberOfRecords__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getNumberOfRecords",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getNumberOfRecords" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getNumberOfRecords" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (long)(arg1)->getNumberOfRecords(arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getNumberOfRecords, _wrap_GeneralFileReader_getNumberOfRecords, _wrap_GeneralFileReader_getNumberOfRecords_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_GeneralFileReader_getNumberOfRecords__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_GeneralFileReader_getNumberOfRecords__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( GeneralFileReader_getVariableID, _wrap_GeneralFileReader_getVariableID, _wrap_GeneralFileReader_getVariableID_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableID",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableID" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getVariableID((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getVariableName, _wrap_GeneralFileReader_getVariableName, _wrap_GeneralFileReader_getVariableName_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableName" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getVariableName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getGlobalAttribute__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getGlobalAttribute" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttribute(arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getGlobalAttributeName, _wrap_GeneralFileReader_getGlobalAttributeName, _wrap_GeneralFileReader_getGlobalAttributeName_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getGlobalAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getGlobalAttributeName" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getGlobalAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getVariableAttributeName, _wrap_GeneralFileReader_getVariableAttributeName, _wrap_GeneralFileReader_getVariableAttributeName_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableAttributeName" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "GeneralFileReader_getVariableAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_GeneralFileReader_getGlobalAttribute__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getGlobalAttribute((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getGlobalAttribute, _wrap_GeneralFileReader_getGlobalAttribute, _wrap_GeneralFileReader_getGlobalAttribute_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_GeneralFileReader_getGlobalAttribute__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__GeneralFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_GeneralFileReader_getGlobalAttribute__SWIG_1(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( GeneralFileReader_getVariableAttribute, _wrap_GeneralFileReader_getVariableAttribute, _wrap_GeneralFileReader_getVariableAttribute_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  int res3 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableAttribute",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableAttribute" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  {
    std::string *ptr = (std::string *)0;
    res3 = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "GeneralFileReader_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    arg3 = ptr;
  }
  result = (arg1)->getVariableAttribute((std::string const &)*arg2,(std::string const &)*arg3);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
  if (SWIG_IsNewObj(res3)) delete arg3;
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getVariableAttributeNames, _wrap_GeneralFileReader_getVariableAttributeNames, _wrap_GeneralFileReader_getVariableAttributeNames_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("GeneralFileReader_getVariableAttributeNames",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getVariableAttributeNames" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  result = (arg1)->getVariableAttributeNames();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_doesAttributeExist, _wrap_GeneralFileReader_doesAttributeExist, _wrap_GeneralFileReader_doesAttributeExist_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("GeneralFileReader_doesAttributeExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_doesAttributeExist" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesAttributeExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_doesVariableExist, _wrap_GeneralFileReader_doesVariableExist, _wrap_GeneralFileReader_doesVariableExist_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("GeneralFileReader_doesVariableExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_doesVariableExist" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "GeneralFileReader_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "GeneralFileReader_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesVariableExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_close, _wrap_GeneralFileReader_close, _wrap_GeneralFileReader_close_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("GeneralFileReader_close",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_close" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  result = (long)(arg1)->close();
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( GeneralFileReader_getCurrentFilename, _wrap_GeneralFileReader_getCurrentFilename, _wrap_GeneralFileReader_getCurrentFilename_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string *result = 0 ;
  
  if (!SWIG_check_num_args("GeneralFileReader_getCurrentFilename",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "GeneralFileReader_getCurrentFilename" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  result = (std::string *) &(arg1)->getCurrentFilename();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_GeneralFileReader, _wrap_delete_GeneralFileReader, _wrap_delete_GeneralFileReader_texinfo ) {
  ccmc::GeneralFileReader *arg1 = (ccmc::GeneralFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_GeneralFileReader",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__GeneralFileReader, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_GeneralFileReader" "', argument " "1"" of type '" "ccmc::GeneralFileReader *""'"); 
  }
  arg1 = (ccmc::GeneralFileReader *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_GeneralFileReader_members[] = {
{"open",_wrap_GeneralFileReader_open,0,0,0,0},
{"getVariable",_wrap_GeneralFileReader_getVariable,0,0,0,0},
{"getVariableAtIndex",_wrap_GeneralFileReader_getVariableAtIndex,0,0,0,0},
{"getVariableInt",_wrap_GeneralFileReader_getVariableInt,0,0,0,0},
{"getVariableIntAtIndex",_wrap_GeneralFileReader_getVariableIntAtIndex,0,0,0,0},
{"getNumberOfGlobalAttributes",_wrap_GeneralFileReader_getNumberOfGlobalAttributes,0,0,0,0},
{"getNumberOfVariables",_wrap_GeneralFileReader_getNumberOfVariables,0,0,0,0},
{"getNumberOfVariableAttributes",_wrap_GeneralFileReader_getNumberOfVariableAttributes,0,0,0,0},
{"getNumberOfRecords",_wrap_GeneralFileReader_getNumberOfRecords,0,0,0,0},
{"getVariableID",_wrap_GeneralFileReader_getVariableID,0,0,0,0},
{"getVariableName",_wrap_GeneralFileReader_getVariableName,0,0,0,0},
{"getGlobalAttributeName",_wrap_GeneralFileReader_getGlobalAttributeName,0,0,0,0},
{"getVariableAttributeName",_wrap_GeneralFileReader_getVariableAttributeName,0,0,0,0},
{"getGlobalAttribute",_wrap_GeneralFileReader_getGlobalAttribute,0,0,0,0},
{"getVariableAttribute",_wrap_GeneralFileReader_getVariableAttribute,0,0,0,0},
{"getVariableAttributeNames",_wrap_GeneralFileReader_getVariableAttributeNames,0,0,0,0},
{"doesAttributeExist",_wrap_GeneralFileReader_doesAttributeExist,0,0,0,0},
{"doesVariableExist",_wrap_GeneralFileReader_doesVariableExist,0,0,0,0},
{"close",_wrap_GeneralFileReader_close,0,0,0,0},
{"getCurrentFilename",_wrap_GeneralFileReader_getCurrentFilename,0,0,0,0},
{0,0,0,0}
};
static const char *swig_GeneralFileReader_base_names[] = {0};
static const swig_type_info *swig_GeneralFileReader_base[] = {0};
static swig_octave_class _wrap_class_GeneralFileReader = {"GeneralFileReader", &SWIGTYPE_p_ccmc__GeneralFileReader,0,_wrap_new_GeneralFileReader,0,_wrap_delete_GeneralFileReader,swig_GeneralFileReader_members,swig_GeneralFileReader_base_names,swig_GeneralFileReader_base };

SWIG_DEFUN( new_CDFFileReader, _wrap_new_CDFFileReader, _wrap_new_CDFFileReader_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::CDFFileReader *result = 0 ;
  
  if (!SWIG_check_num_args("new_CDFFileReader",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::CDFFileReader *)new ccmc::CDFFileReader();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__CDFFileReader, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getVariable__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariable" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getVariable__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariable" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getVariable" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getVariable__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  long arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  long val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariable",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariable" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "CDFFileReader_getVariable" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  ecode4 = SWIG_AsVal_long(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "CDFFileReader_getVariable" "', argument " "4"" of type '" "long""'");
  } 
  arg4 = (long)(val4);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable((std::string const &)*arg2,arg3,arg4);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getVariable__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  long arg3 ;
  long arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  long val3 ;
  int ecode3 = 0 ;
  long val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariable",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariable" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getVariable" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "CDFFileReader_getVariable" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  ecode4 = SWIG_AsVal_long(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "CDFFileReader_getVariable" "', argument " "4"" of type '" "long""'");
  } 
  arg4 = (long)(val4);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable(arg2,arg3,arg4);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getVariable, _wrap_CDFFileReader_getVariable, _wrap_CDFFileReader_getVariable_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[4]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_CDFFileReader_getVariable__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_CDFFileReader_getVariable__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_long(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_CDFFileReader_getVariable__SWIG_3(args, nargout);
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_long(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_CDFFileReader_getVariable__SWIG_2(args, nargout);
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_CDFFileReader_getVariableAtIndex__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableAtIndex" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getVariableAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariableAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "CDFFileReader_getVariableAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (float)(arg1)->getVariableAtIndex((std::string const &)*arg2,arg3);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getVariableAtIndex__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableAtIndex" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getVariableAtIndex" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "CDFFileReader_getVariableAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (float)(arg1)->getVariableAtIndex(arg2,arg3);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getVariableAtIndex, _wrap_CDFFileReader_getVariableAtIndex, _wrap_CDFFileReader_getVariableAtIndex_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_CDFFileReader_getVariableAtIndex__SWIG_1(args, nargout);
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_long(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_CDFFileReader_getVariableAtIndex__SWIG_0(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( CDFFileReader_getVariableInt, _wrap_CDFFileReader_getVariableInt, _wrap_CDFFileReader_getVariableInt_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableInt",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableInt" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getVariableInt((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getVariableIntAtIndex, _wrap_CDFFileReader_getVariableIntAtIndex, _wrap_CDFFileReader_getVariableIntAtIndex_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  long arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  long val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableIntAtIndex",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableIntAtIndex" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getVariableIntAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariableIntAtIndex" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_long(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "CDFFileReader_getVariableIntAtIndex" "', argument " "3"" of type '" "long""'");
  } 
  arg3 = (long)(val3);
  result = (int)(arg1)->getVariableIntAtIndex((std::string const &)*arg2,arg3);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getNumberOfGlobalAttributes, _wrap_CDFFileReader_getNumberOfGlobalAttributes, _wrap_CDFFileReader_getNumberOfGlobalAttributes_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("CDFFileReader_getNumberOfGlobalAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getNumberOfGlobalAttributes" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  result = (int)(arg1)->getNumberOfGlobalAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getNumberOfVariables, _wrap_CDFFileReader_getNumberOfVariables, _wrap_CDFFileReader_getNumberOfVariables_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("CDFFileReader_getNumberOfVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getNumberOfVariables" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  result = (int)(arg1)->getNumberOfVariables();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getNumberOfVariableAttributes, _wrap_CDFFileReader_getNumberOfVariableAttributes, _wrap_CDFFileReader_getNumberOfVariableAttributes_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("CDFFileReader_getNumberOfVariableAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getNumberOfVariableAttributes" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  result = (int)(arg1)->getNumberOfVariableAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getNumberOfRecords__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("CDFFileReader_getNumberOfRecords",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getNumberOfRecords" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getNumberOfRecords" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getNumberOfRecords" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getNumberOfRecords((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getNumberOfRecords__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("CDFFileReader_getNumberOfRecords",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getNumberOfRecords" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getNumberOfRecords" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (long)(arg1)->getNumberOfRecords(arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getNumberOfRecords, _wrap_CDFFileReader_getNumberOfRecords, _wrap_CDFFileReader_getNumberOfRecords_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_CDFFileReader_getNumberOfRecords__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_CDFFileReader_getNumberOfRecords__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( CDFFileReader_getVariableID, _wrap_CDFFileReader_getVariableID, _wrap_CDFFileReader_getVariableID_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableID",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableID" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getVariableID((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getVariableName, _wrap_CDFFileReader_getVariableName, _wrap_CDFFileReader_getVariableName_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableName" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getVariableName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getGlobalAttribute__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("CDFFileReader_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getGlobalAttribute" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttribute(arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getGlobalAttributeName, _wrap_CDFFileReader_getGlobalAttributeName, _wrap_CDFFileReader_getGlobalAttributeName_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("CDFFileReader_getGlobalAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getGlobalAttributeName" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getGlobalAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getVariableAttributeName, _wrap_CDFFileReader_getVariableAttributeName, _wrap_CDFFileReader_getVariableAttributeName_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableAttributeName" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_getVariableAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_getGlobalAttribute__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("CDFFileReader_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getGlobalAttribute((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getGlobalAttribute, _wrap_CDFFileReader_getGlobalAttribute, _wrap_CDFFileReader_getGlobalAttribute_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_CDFFileReader_getGlobalAttribute__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_CDFFileReader_getGlobalAttribute__SWIG_1(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( CDFFileReader_getGlobalAttributeID, _wrap_CDFFileReader_getGlobalAttributeID, _wrap_CDFFileReader_getGlobalAttributeID_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("CDFFileReader_getGlobalAttributeID",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getGlobalAttributeID" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getGlobalAttributeID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getGlobalAttributeID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getGlobalAttributeID((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getVariableAttribute, _wrap_CDFFileReader_getVariableAttribute, _wrap_CDFFileReader_getVariableAttribute_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  int res3 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableAttribute",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableAttribute" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  {
    std::string *ptr = (std::string *)0;
    res3 = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "CDFFileReader_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    arg3 = ptr;
  }
  result = (arg1)->getVariableAttribute((std::string const &)*arg2,(std::string const &)*arg3);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
  if (SWIG_IsNewObj(res3)) delete arg3;
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_getVariableAttributeNames, _wrap_CDFFileReader_getVariableAttributeNames, _wrap_CDFFileReader_getVariableAttributeNames_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("CDFFileReader_getVariableAttributeNames",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getVariableAttributeNames" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  result = (arg1)->getVariableAttributeNames();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_doesAttributeExist__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("CDFFileReader_doesAttributeExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_doesAttributeExist" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesAttributeExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_doesVariableExist__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("CDFFileReader_doesVariableExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_doesVariableExist" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "CDFFileReader_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "CDFFileReader_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesVariableExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_CDFFileReader_doesAttributeExist__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("CDFFileReader_doesAttributeExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_doesAttributeExist" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_doesAttributeExist" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (bool)(arg1)->doesAttributeExist(arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_doesAttributeExist, _wrap_CDFFileReader_doesAttributeExist, _wrap_CDFFileReader_doesAttributeExist_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_CDFFileReader_doesAttributeExist__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_CDFFileReader_doesAttributeExist__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_CDFFileReader_doesVariableExist__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("CDFFileReader_doesVariableExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_doesVariableExist" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "CDFFileReader_doesVariableExist" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (bool)(arg1)->doesVariableExist(arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( CDFFileReader_doesVariableExist, _wrap_CDFFileReader_doesVariableExist, _wrap_CDFFileReader_doesVariableExist_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_CDFFileReader_doesVariableExist__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__CDFFileReader, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_CDFFileReader_doesVariableExist__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( CDFFileReader_getCurrentFilename, _wrap_CDFFileReader_getCurrentFilename, _wrap_CDFFileReader_getCurrentFilename_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string *result = 0 ;
  
  if (!SWIG_check_num_args("CDFFileReader_getCurrentFilename",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "CDFFileReader_getCurrentFilename" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  result = (std::string *) &(arg1)->getCurrentFilename();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_CDFFileReader, _wrap_delete_CDFFileReader, _wrap_delete_CDFFileReader_texinfo ) {
  ccmc::CDFFileReader *arg1 = (ccmc::CDFFileReader *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_CDFFileReader",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__CDFFileReader, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_CDFFileReader" "', argument " "1"" of type '" "ccmc::CDFFileReader *""'"); 
  }
  arg1 = (ccmc::CDFFileReader *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_CDFFileReader_members[] = {
{"getVariable",_wrap_CDFFileReader_getVariable,0,0,0,0},
{"getVariableAtIndex",_wrap_CDFFileReader_getVariableAtIndex,0,0,0,0},
{"getVariableInt",_wrap_CDFFileReader_getVariableInt,0,0,0,0},
{"getVariableIntAtIndex",_wrap_CDFFileReader_getVariableIntAtIndex,0,0,0,0},
{"getNumberOfGlobalAttributes",_wrap_CDFFileReader_getNumberOfGlobalAttributes,0,0,0,0},
{"getNumberOfVariables",_wrap_CDFFileReader_getNumberOfVariables,0,0,0,0},
{"getNumberOfVariableAttributes",_wrap_CDFFileReader_getNumberOfVariableAttributes,0,0,0,0},
{"getNumberOfRecords",_wrap_CDFFileReader_getNumberOfRecords,0,0,0,0},
{"getVariableID",_wrap_CDFFileReader_getVariableID,0,0,0,0},
{"getVariableName",_wrap_CDFFileReader_getVariableName,0,0,0,0},
{"getGlobalAttributeName",_wrap_CDFFileReader_getGlobalAttributeName,0,0,0,0},
{"getVariableAttributeName",_wrap_CDFFileReader_getVariableAttributeName,0,0,0,0},
{"getGlobalAttribute",_wrap_CDFFileReader_getGlobalAttribute,0,0,0,0},
{"getGlobalAttributeID",_wrap_CDFFileReader_getGlobalAttributeID,0,0,0,0},
{"getVariableAttribute",_wrap_CDFFileReader_getVariableAttribute,0,0,0,0},
{"getVariableAttributeNames",_wrap_CDFFileReader_getVariableAttributeNames,0,0,0,0},
{"doesAttributeExist",_wrap_CDFFileReader_doesAttributeExist,0,0,0,0},
{"doesVariableExist",_wrap_CDFFileReader_doesVariableExist,0,0,0,0},
{"getCurrentFilename",_wrap_CDFFileReader_getCurrentFilename,0,0,0,0},
{0,0,0,0}
};
static const char *swig_CDFFileReader_base_names[] = {"_p_ccmc__FileReader",0};
static const swig_type_info *swig_CDFFileReader_base[] = {0,0};
static swig_octave_class _wrap_class_CDFFileReader = {"CDFFileReader", &SWIGTYPE_p_ccmc__CDFFileReader,0,_wrap_new_CDFFileReader,0,_wrap_delete_CDFFileReader,swig_CDFFileReader_members,swig_CDFFileReader_base_names,swig_CDFFileReader_base };

SWIG_DEFUN( parseEPOCH3, _wrap_parseEPOCH3, std::string() ) {
  char *arg1 ;
  char temp1[24+1] ;
  int res1 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  double result;
  
  if (!SWIG_check_num_args("parseEPOCH3",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_AsCharArray(args(0), temp1, 24+1);
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "parseEPOCH3" "', argument " "1"" of type '" "char [24+1]""'");
  }
  arg1 = (char *)(temp1);
  result = (double)ccmc::parseEPOCH3(arg1);
  _outv = SWIG_From_double((double)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( encodeEPOCH3, _wrap_encodeEPOCH3, std::string() ) {
  double arg1 ;
  char *arg2 ;
  double val1 ;
  int ecode1 = 0 ;
  char temp2[24+1] ;
  int res2 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("encodeEPOCH3",args.length(),2,2,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_double(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "encodeEPOCH3" "', argument " "1"" of type '" "double""'");
  } 
  arg1 = (double)(val1);
  res2 = SWIG_AsCharArray(args(1), temp2, 24+1);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "encodeEPOCH3" "', argument " "2"" of type '" "char [24+1]""'");
  }
  arg2 = (char *)(temp2);
  ccmc::encodeEPOCH3(arg1,arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( EPOCHbreakdown, _wrap_EPOCHbreakdown, std::string() ) {
  double arg1 ;
  long *arg2 = (long *) 0 ;
  long *arg3 = (long *) 0 ;
  long *arg4 = (long *) 0 ;
  long *arg5 = (long *) 0 ;
  long *arg6 = (long *) 0 ;
  long *arg7 = (long *) 0 ;
  long *arg8 = (long *) 0 ;
  double val1 ;
  int ecode1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  void *argp3 = 0 ;
  int res3 = 0 ;
  void *argp4 = 0 ;
  int res4 = 0 ;
  void *argp5 = 0 ;
  int res5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("EPOCHbreakdown",args.length(),8,8,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_double(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "EPOCHbreakdown" "', argument " "1"" of type '" "double""'");
  } 
  arg1 = (double)(val1);
  res2 = SWIG_ConvertPtr(args(1), &argp2,SWIGTYPE_p_long, 0 |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "EPOCHbreakdown" "', argument " "2"" of type '" "long *""'"); 
  }
  arg2 = (long *)(argp2);
  res3 = SWIG_ConvertPtr(args(2), &argp3,SWIGTYPE_p_long, 0 |  0 );
  if (!SWIG_IsOK(res3)) {
    SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "EPOCHbreakdown" "', argument " "3"" of type '" "long *""'"); 
  }
  arg3 = (long *)(argp3);
  res4 = SWIG_ConvertPtr(args(3), &argp4,SWIGTYPE_p_long, 0 |  0 );
  if (!SWIG_IsOK(res4)) {
    SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "EPOCHbreakdown" "', argument " "4"" of type '" "long *""'"); 
  }
  arg4 = (long *)(argp4);
  res5 = SWIG_ConvertPtr(args(4), &argp5,SWIGTYPE_p_long, 0 |  0 );
  if (!SWIG_IsOK(res5)) {
    SWIG_exception_fail(SWIG_ArgError(res5), "in method '" "EPOCHbreakdown" "', argument " "5"" of type '" "long *""'"); 
  }
  arg5 = (long *)(argp5);
  res6 = SWIG_ConvertPtr(args(5), &argp6,SWIGTYPE_p_long, 0 |  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "EPOCHbreakdown" "', argument " "6"" of type '" "long *""'"); 
  }
  arg6 = (long *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7,SWIGTYPE_p_long, 0 |  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "EPOCHbreakdown" "', argument " "7"" of type '" "long *""'"); 
  }
  arg7 = (long *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8,SWIGTYPE_p_long, 0 |  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "EPOCHbreakdown" "', argument " "8"" of type '" "long *""'"); 
  }
  arg8 = (long *)(argp8);
  ccmc::EPOCHbreakdown(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Position_c0_set, _wrap_Position_c0_set, std::string() ) {
  ccmc::Position *arg1 = (ccmc::Position *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Position_c0_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Position_c0_set" "', argument " "1"" of type '" "ccmc::Position *""'"); 
  }
  arg1 = (ccmc::Position *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Position_c0_set" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  if (arg1) (arg1)->c0 = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Position_c0_get, _wrap_Position_c0_get, std::string() ) {
  ccmc::Position *arg1 = (ccmc::Position *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Position_c0_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Position_c0_get" "', argument " "1"" of type '" "ccmc::Position *""'"); 
  }
  arg1 = (ccmc::Position *)(argp1);
  result = (float) ((arg1)->c0);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Position_c1_set, _wrap_Position_c1_set, std::string() ) {
  ccmc::Position *arg1 = (ccmc::Position *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Position_c1_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Position_c1_set" "', argument " "1"" of type '" "ccmc::Position *""'"); 
  }
  arg1 = (ccmc::Position *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Position_c1_set" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  if (arg1) (arg1)->c1 = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Position_c1_get, _wrap_Position_c1_get, std::string() ) {
  ccmc::Position *arg1 = (ccmc::Position *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Position_c1_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Position_c1_get" "', argument " "1"" of type '" "ccmc::Position *""'"); 
  }
  arg1 = (ccmc::Position *)(argp1);
  result = (float) ((arg1)->c1);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Position_c2_set, _wrap_Position_c2_set, std::string() ) {
  ccmc::Position *arg1 = (ccmc::Position *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Position_c2_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Position_c2_set" "', argument " "1"" of type '" "ccmc::Position *""'"); 
  }
  arg1 = (ccmc::Position *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Position_c2_set" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  if (arg1) (arg1)->c2 = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Position_c2_get, _wrap_Position_c2_get, std::string() ) {
  ccmc::Position *arg1 = (ccmc::Position *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Position_c2_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Position_c2_get" "', argument " "1"" of type '" "ccmc::Position *""'"); 
  }
  arg1 = (ccmc::Position *)(argp1);
  result = (float) ((arg1)->c2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( new_Position, _wrap_new_Position, std::string() ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Position *result = 0 ;
  
  if (!SWIG_check_num_args("new_Position",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::Position *)new ccmc::Position();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Position, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Position, _wrap_delete_Position, std::string() ) {
  ccmc::Position *arg1 = (ccmc::Position *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Position",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Position, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Position" "', argument " "1"" of type '" "ccmc::Position *""'"); 
  }
  arg1 = (ccmc::Position *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Position_members[] = {
{"c0",0,_wrap_Position_c0_get,_wrap_Position_c0_set,0,0},
{"c1",0,_wrap_Position_c1_get,_wrap_Position_c1_set,0,0},
{"c2",0,_wrap_Position_c2_get,_wrap_Position_c2_set,0,0},
{0,0,0,0}
};
static const char *swig_Position_base_names[] = {0};
static const swig_type_info *swig_Position_base[] = {0};
static swig_octave_class _wrap_class_Position = {"Position", &SWIGTYPE_p_ccmc__Position,0,_wrap_new_Position,0,_wrap_delete_Position,swig_Position_members,swig_Position_base_names,swig_Position_base };

SWIG_DEFUN( new_Kameleon, _wrap_new_Kameleon, _wrap_new_Kameleon_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Kameleon *result = 0 ;
  
  if (!SWIG_check_num_args("new_Kameleon",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::Kameleon *)new ccmc::Kameleon();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Kameleon, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Kameleon, _wrap_delete_Kameleon, _wrap_delete_Kameleon_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Kameleon",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Kameleon" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_close, _wrap_Kameleon_close, _wrap_Kameleon_close_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Kameleon_close",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_close" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (long)(arg1)->close();
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_createNewInterpolator, _wrap_Kameleon_createNewInterpolator, _wrap_Kameleon_createNewInterpolator_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("Kameleon_createNewInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_createNewInterpolator" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (Interpolator *)(arg1)->createNewInterpolator();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_doesAttributeExist, _wrap_Kameleon_doesAttributeExist, _wrap_Kameleon_doesAttributeExist_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("Kameleon_doesAttributeExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_doesAttributeExist" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_doesAttributeExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesAttributeExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_doesVariableExist, _wrap_Kameleon_doesVariableExist, _wrap_Kameleon_doesVariableExist_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("Kameleon_doesVariableExist",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_doesVariableExist" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_doesVariableExist" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->doesVariableExist((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getConversionFactorToSI, _wrap_Kameleon_getConversionFactorToSI, _wrap_Kameleon_getConversionFactorToSI_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Kameleon_getConversionFactorToSI",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getConversionFactorToSI" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getConversionFactorToSI" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getConversionFactorToSI" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (float)(arg1)->getConversionFactorToSI((std::string const &)*arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getCurrentFilename, _wrap_Kameleon_getCurrentFilename, _wrap_Kameleon_getCurrentFilename_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string *result = 0 ;
  
  if (!SWIG_check_num_args("Kameleon_getCurrentFilename",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getCurrentFilename" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (std::string *) &(arg1)->getCurrentFilename();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getCurrentTime, _wrap_Kameleon_getCurrentTime, _wrap_Kameleon_getCurrentTime_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Time result;
  
  if (!SWIG_check_num_args("Kameleon_getCurrentTime",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getCurrentTime" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (arg1)->getCurrentTime();
  _outv = SWIG_NewPointerObj((new Time((const Time&)(result))), SWIGTYPE_p_ccmc__Time, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Kameleon_getGlobalAttribute__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("Kameleon_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Kameleon_getGlobalAttribute" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttribute(arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Kameleon_getGlobalAttribute__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("Kameleon_getGlobalAttribute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getGlobalAttribute" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getGlobalAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getGlobalAttribute((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getGlobalAttribute, _wrap_Kameleon_getGlobalAttribute, _wrap_Kameleon_getGlobalAttribute_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Kameleon, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Kameleon_getGlobalAttribute__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Kameleon, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Kameleon_getGlobalAttribute__SWIG_1(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Kameleon_getGlobalAttributeName, _wrap_Kameleon_getGlobalAttributeName, _wrap_Kameleon_getGlobalAttributeName_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Kameleon_getGlobalAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getGlobalAttributeName" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Kameleon_getGlobalAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getGlobalAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getLoadedVariables, _wrap_Kameleon_getLoadedVariables, _wrap_Kameleon_getLoadedVariables_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("Kameleon_getLoadedVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getLoadedVariables" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (arg1)->getLoadedVariables();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getMissingValue, _wrap_Kameleon_getMissingValue, _wrap_Kameleon_getMissingValue_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Kameleon_getMissingValue",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getMissingValue" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (float)(arg1)->getMissingValue();
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getModelName, _wrap_Kameleon_getModelName, _wrap_Kameleon_getModelName_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string *result = 0 ;
  
  if (!SWIG_check_num_args("Kameleon_getModelName",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getModelName" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (std::string *) &(arg1)->getModelName();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getNativeUnit, _wrap_Kameleon_getNativeUnit, _wrap_Kameleon_getNativeUnit_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Kameleon_getNativeUnit",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getNativeUnit" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getNativeUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getNativeUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getNativeUnit((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getNumberOfGlobalAttributes, _wrap_Kameleon_getNumberOfGlobalAttributes, _wrap_Kameleon_getNumberOfGlobalAttributes_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Kameleon_getNumberOfGlobalAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getNumberOfGlobalAttributes" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (int)(arg1)->getNumberOfGlobalAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getNumberOfVariableAttributes, _wrap_Kameleon_getNumberOfVariableAttributes, _wrap_Kameleon_getNumberOfVariableAttributes_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Kameleon_getNumberOfVariableAttributes",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getNumberOfVariableAttributes" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (int)(arg1)->getNumberOfVariableAttributes();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getNumberOfVariables, _wrap_Kameleon_getNumberOfVariables, _wrap_Kameleon_getNumberOfVariables_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Kameleon_getNumberOfVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getNumberOfVariables" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (int)(arg1)->getNumberOfVariables();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getSIUnit, _wrap_Kameleon_getSIUnit, _wrap_Kameleon_getSIUnit_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Kameleon_getSIUnit",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getSIUnit" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getSIUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getSIUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getSIUnit((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariable, _wrap_Kameleon_getVariable, _wrap_Kameleon_getVariable_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Kameleon_getVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariable" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariable((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariableAttribute, _wrap_Kameleon_getVariableAttribute, _wrap_Kameleon_getVariableAttribute_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  int res3 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Attribute result;
  
  if (!SWIG_check_num_args("Kameleon_getVariableAttribute",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariableAttribute" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVariableAttribute" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  {
    std::string *ptr = (std::string *)0;
    res3 = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "Kameleon_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVariableAttribute" "', argument " "3"" of type '" "std::string const &""'"); 
    }
    arg3 = ptr;
  }
  result = (arg1)->getVariableAttribute((std::string const &)*arg2,(std::string const &)*arg3);
  _outv = SWIG_NewPointerObj((new Attribute((const Attribute&)(result))), SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
  if (SWIG_IsNewObj(res3)) delete arg3;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariableAttributeName, _wrap_Kameleon_getVariableAttributeName, _wrap_Kameleon_getVariableAttributeName_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Kameleon_getVariableAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariableAttributeName" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Kameleon_getVariableAttributeName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableAttributeName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariableFromMap, _wrap_Kameleon_getVariableFromMap, _wrap_Kameleon_getVariableFromMap_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Kameleon_getVariableFromMap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariableFromMap" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getVariableFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVariableFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariableFromMap((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariableID, _wrap_Kameleon_getVariableID, _wrap_Kameleon_getVariableID_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Kameleon_getVariableID",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariableID" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVariableID" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->getVariableID((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariableInt, _wrap_Kameleon_getVariableInt, _wrap_Kameleon_getVariableInt_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Kameleon_getVariableInt",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariableInt" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getVariableInt((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariableIntFromMap, _wrap_Kameleon_getVariableIntFromMap, _wrap_Kameleon_getVariableIntFromMap_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Kameleon_getVariableIntFromMap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariableIntFromMap" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getVariableIntFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVariableIntFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getVariableIntFromMap((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVariableName, _wrap_Kameleon_getVariableName, _wrap_Kameleon_getVariableName_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Kameleon_getVariableName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVariableName" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Kameleon_getVariableName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getVariableName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getVisUnit, _wrap_Kameleon_getVisUnit, _wrap_Kameleon_getVisUnit_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Kameleon_getVisUnit",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getVisUnit" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_getVisUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_getVisUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getVisUnit((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_loadVariable, _wrap_Kameleon_loadVariable, _wrap_Kameleon_loadVariable_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("Kameleon_loadVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_loadVariable" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_loadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_loadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->loadVariable((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_loadVectorVariable, _wrap_Kameleon_loadVectorVariable, _wrap_Kameleon_loadVectorVariable_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("Kameleon_loadVectorVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_loadVectorVariable" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_loadVectorVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_loadVectorVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->loadVectorVariable((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_open, _wrap_Kameleon_open, _wrap_Kameleon_open_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Kameleon_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_open" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_setMissingValue, _wrap_Kameleon_setMissingValue, _wrap_Kameleon_setMissingValue_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Kameleon_setMissingValue",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_setMissingValue" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Kameleon_setMissingValue" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  (arg1)->setMissingValue(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_unloadVariable, _wrap_Kameleon_unloadVariable, _wrap_Kameleon_unloadVariable_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("Kameleon_unloadVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_unloadVariable" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_unloadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_unloadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->unloadVariable((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_unloadVectorVariable, _wrap_Kameleon_unloadVectorVariable, _wrap_Kameleon_unloadVectorVariable_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("Kameleon_unloadVectorVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_unloadVectorVariable" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon_unloadVectorVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Kameleon_unloadVectorVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (bool)(arg1)->unloadVectorVariable((std::string const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon_getProgress, _wrap_Kameleon_getProgress, _wrap_Kameleon_getProgress_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Kameleon_getProgress",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon_getProgress" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (int)(arg1)->getProgress();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon__cxform, _wrap_Kameleon__cxform, std::string() ) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  double arg3 ;
  ccmc::Position *arg4 = (ccmc::Position *) 0 ;
  ccmc::Position *arg5 = (ccmc::Position *) 0 ;
  int res1 ;
  char *buf1 = 0 ;
  int alloc1 = 0 ;
  int res2 ;
  char *buf2 = 0 ;
  int alloc2 = 0 ;
  double val3 ;
  int ecode3 = 0 ;
  void *argp4 = 0 ;
  int res4 = 0 ;
  void *argp5 = 0 ;
  int res5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Kameleon__cxform",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_AsCharPtrAndSize(args(0), &buf1, NULL, &alloc1);
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Kameleon__cxform" "', argument " "1"" of type '" "char const *""'");
  }
  arg1 = (char *)(buf1);
  res2 = SWIG_AsCharPtrAndSize(args(1), &buf2, NULL, &alloc2);
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Kameleon__cxform" "', argument " "2"" of type '" "char const *""'");
  }
  arg2 = (char *)(buf2);
  ecode3 = SWIG_AsVal_double(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Kameleon__cxform" "', argument " "3"" of type '" "double""'");
  } 
  arg3 = (double)(val3);
  res4 = SWIG_ConvertPtr(args(3), &argp4,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res4)) {
    SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "Kameleon__cxform" "', argument " "4"" of type '" "ccmc::Position *""'"); 
  }
  arg4 = (ccmc::Position *)(argp4);
  res5 = SWIG_ConvertPtr(args(4), &argp5,SWIGTYPE_p_ccmc__Position, 0 |  0 );
  if (!SWIG_IsOK(res5)) {
    SWIG_exception_fail(SWIG_ArgError(res5), "in method '" "Kameleon__cxform" "', argument " "5"" of type '" "ccmc::Position *""'"); 
  }
  arg5 = (ccmc::Position *)(argp5);
  result = (int)ccmc::Kameleon::_cxform((char const *)arg1,(char const *)arg2,arg3,arg4,arg5);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (alloc1 == SWIG_NEWOBJ) delete[] buf1;
  if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
fail:
  return _out;
}


SWIG_DEFUN( Kameleon__cxRound, _wrap_Kameleon__cxRound, std::string() ) {
  double arg1 ;
  double val1 ;
  int ecode1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Kameleon__cxRound",args.length(),1,1,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_double(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "Kameleon__cxRound" "', argument " "1"" of type '" "double""'");
  } 
  arg1 = (double)(val1);
  result = (long)ccmc::Kameleon::_cxRound(arg1);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon__date2es, _wrap_Kameleon__date2es, std::string() ) {
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int val1 ;
  int ecode1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  int val4 ;
  int ecode4 = 0 ;
  int val5 ;
  int ecode5 = 0 ;
  int val6 ;
  int ecode6 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Kameleon__date2es",args.length(),6,6,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_int(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "Kameleon__date2es" "', argument " "1"" of type '" "int""'");
  } 
  arg1 = (int)(val1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Kameleon__date2es" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  ecode3 = SWIG_AsVal_int(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Kameleon__date2es" "', argument " "3"" of type '" "int""'");
  } 
  arg3 = (int)(val3);
  ecode4 = SWIG_AsVal_int(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Kameleon__date2es" "', argument " "4"" of type '" "int""'");
  } 
  arg4 = (int)(val4);
  ecode5 = SWIG_AsVal_int(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Kameleon__date2es" "', argument " "5"" of type '" "int""'");
  } 
  arg5 = (int)(val5);
  ecode6 = SWIG_AsVal_int(args(5), &val6);
  if (!SWIG_IsOK(ecode6)) {
    SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "Kameleon__date2es" "', argument " "6"" of type '" "int""'");
  } 
  arg6 = (int)(val6);
  result = (long)ccmc::Kameleon::_date2es(arg1,arg2,arg3,arg4,arg5,arg6);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Kameleon__gregorian_calendar_to_jd, _wrap_Kameleon__gregorian_calendar_to_jd, std::string() ) {
  int arg1 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  int arg6 ;
  int val1 ;
  int ecode1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  int val4 ;
  int ecode4 = 0 ;
  int val5 ;
  int ecode5 = 0 ;
  int val6 ;
  int ecode6 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  double result;
  
  if (!SWIG_check_num_args("Kameleon__gregorian_calendar_to_jd",args.length(),6,6,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_int(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "Kameleon__gregorian_calendar_to_jd" "', argument " "1"" of type '" "int""'");
  } 
  arg1 = (int)(val1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Kameleon__gregorian_calendar_to_jd" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  ecode3 = SWIG_AsVal_int(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Kameleon__gregorian_calendar_to_jd" "', argument " "3"" of type '" "int""'");
  } 
  arg3 = (int)(val3);
  ecode4 = SWIG_AsVal_int(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Kameleon__gregorian_calendar_to_jd" "', argument " "4"" of type '" "int""'");
  } 
  arg4 = (int)(val4);
  ecode5 = SWIG_AsVal_int(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Kameleon__gregorian_calendar_to_jd" "', argument " "5"" of type '" "int""'");
  } 
  arg5 = (int)(val5);
  ecode6 = SWIG_AsVal_int(args(5), &val6);
  if (!SWIG_IsOK(ecode6)) {
    SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "Kameleon__gregorian_calendar_to_jd" "', argument " "6"" of type '" "int""'");
  } 
  arg6 = (int)(val6);
  result = (double)ccmc::Kameleon::_gregorian_calendar_to_jd(arg1,arg2,arg3,arg4,arg5,arg6);
  _outv = SWIG_From_double((double)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Kameleon_members[] = {
{"close",_wrap_Kameleon_close,0,0,0,0},
{"createNewInterpolator",_wrap_Kameleon_createNewInterpolator,0,0,0,0},
{"doesAttributeExist",_wrap_Kameleon_doesAttributeExist,0,0,0,0},
{"doesVariableExist",_wrap_Kameleon_doesVariableExist,0,0,0,0},
{"getConversionFactorToSI",_wrap_Kameleon_getConversionFactorToSI,0,0,0,0},
{"getCurrentFilename",_wrap_Kameleon_getCurrentFilename,0,0,0,0},
{"getCurrentTime",_wrap_Kameleon_getCurrentTime,0,0,0,0},
{"getGlobalAttribute",_wrap_Kameleon_getGlobalAttribute,0,0,0,0},
{"getGlobalAttributeName",_wrap_Kameleon_getGlobalAttributeName,0,0,0,0},
{"getLoadedVariables",_wrap_Kameleon_getLoadedVariables,0,0,0,0},
{"getMissingValue",_wrap_Kameleon_getMissingValue,0,0,0,0},
{"getModelName",_wrap_Kameleon_getModelName,0,0,0,0},
{"getNativeUnit",_wrap_Kameleon_getNativeUnit,0,0,0,0},
{"getNumberOfGlobalAttributes",_wrap_Kameleon_getNumberOfGlobalAttributes,0,0,0,0},
{"getNumberOfVariableAttributes",_wrap_Kameleon_getNumberOfVariableAttributes,0,0,0,0},
{"getNumberOfVariables",_wrap_Kameleon_getNumberOfVariables,0,0,0,0},
{"getSIUnit",_wrap_Kameleon_getSIUnit,0,0,0,0},
{"getVariable",_wrap_Kameleon_getVariable,0,0,0,0},
{"getVariableAttribute",_wrap_Kameleon_getVariableAttribute,0,0,0,0},
{"getVariableAttributeName",_wrap_Kameleon_getVariableAttributeName,0,0,0,0},
{"getVariableFromMap",_wrap_Kameleon_getVariableFromMap,0,0,0,0},
{"getVariableID",_wrap_Kameleon_getVariableID,0,0,0,0},
{"getVariableInt",_wrap_Kameleon_getVariableInt,0,0,0,0},
{"getVariableIntFromMap",_wrap_Kameleon_getVariableIntFromMap,0,0,0,0},
{"getVariableName",_wrap_Kameleon_getVariableName,0,0,0,0},
{"getVisUnit",_wrap_Kameleon_getVisUnit,0,0,0,0},
{"loadVariable",_wrap_Kameleon_loadVariable,0,0,0,0},
{"loadVectorVariable",_wrap_Kameleon_loadVectorVariable,0,0,0,0},
{"open",_wrap_Kameleon_open,0,0,0,0},
{"setMissingValue",_wrap_Kameleon_setMissingValue,0,0,0,0},
{"unloadVariable",_wrap_Kameleon_unloadVariable,0,0,0,0},
{"unloadVectorVariable",_wrap_Kameleon_unloadVectorVariable,0,0,0,0},
{"getProgress",_wrap_Kameleon_getProgress,0,0,0,0},
{"_cxform",_wrap_Kameleon__cxform,0,0,1,0},
{"_cxRound",_wrap_Kameleon__cxRound,0,0,1,0},
{"_date2es",_wrap_Kameleon__date2es,0,0,1,0},
{"_gregorian_calendar_to_jd",_wrap_Kameleon__gregorian_calendar_to_jd,0,0,1,0},
{0,0,0,0}
};
static const char *swig_Kameleon_base_names[] = {0};
static const swig_type_info *swig_Kameleon_base[] = {0};
static swig_octave_class _wrap_class_Kameleon = {"Kameleon", &SWIGTYPE_p_ccmc__Kameleon,0,_wrap_new_Kameleon,0,_wrap_delete_Kameleon,swig_Kameleon_members,swig_Kameleon_base_names,swig_Kameleon_base };

SWIG_DEFUN( kameleonObjects_set, _wrap_kameleonObjects_set, std::string() ) {
  if (!SWIG_check_num_args("kameleonObjects_set",args.length(),1,1,0)) return octave_value_list();
  
  {
    void *argp = 0;
    int res = SWIG_ConvertPtr(args(0), &argp, SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Kameleon_p_t,  0 );
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in variable '""ccmc::kameleonObjects""' of type '""boost::unordered_map< int,ccmc::Kameleon * >""'");
    }
    if (!argp) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in variable '""ccmc::kameleonObjects""' of type '""boost::unordered_map< int,ccmc::Kameleon * >""'");
    } else {
      ccmc::kameleonObjects = *((boost::unordered_map< int,ccmc::Kameleon * > *)(argp));
    }
  }
fail:
  return octave_value_list();
}


SWIG_DEFUN( kameleonObjects_get, _wrap_kameleonObjects_get, std::string() ) {
  octave_value obj;
  
  obj = SWIG_NewPointerObj(SWIG_as_voidptr(&ccmc::kameleonObjects), SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Kameleon_p_t,  0 );
  return obj;
}


SWIG_DEFUN( tracerObjects_set, _wrap_tracerObjects_set, std::string() ) {
  if (!SWIG_check_num_args("tracerObjects_set",args.length(),1,1,0)) return octave_value_list();
  
  {
    void *argp = 0;
    int res = SWIG_ConvertPtr(args(0), &argp, SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Tracer_p_t,  0 );
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in variable '""ccmc::tracerObjects""' of type '""boost::unordered_map< int,ccmc::Tracer * >""'");
    }
    if (!argp) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in variable '""ccmc::tracerObjects""' of type '""boost::unordered_map< int,ccmc::Tracer * >""'");
    } else {
      ccmc::tracerObjects = *((boost::unordered_map< int,ccmc::Tracer * > *)(argp));
    }
  }
fail:
  return octave_value_list();
}


SWIG_DEFUN( tracerObjects_get, _wrap_tracerObjects_get, std::string() ) {
  octave_value obj;
  
  obj = SWIG_NewPointerObj(SWIG_as_voidptr(&ccmc::tracerObjects), SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Tracer_p_t,  0 );
  return obj;
}


SWIG_DEFUN( interpolatorObjects_set, _wrap_interpolatorObjects_set, std::string() ) {
  if (!SWIG_check_num_args("interpolatorObjects_set",args.length(),1,1,0)) return octave_value_list();
  
  {
    void *argp = 0;
    int res = SWIG_ConvertPtr(args(0), &argp, SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Interpolator_p_t,  0 );
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in variable '""ccmc::interpolatorObjects""' of type '""boost::unordered_map< int,ccmc::Interpolator * >""'");
    }
    if (!argp) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in variable '""ccmc::interpolatorObjects""' of type '""boost::unordered_map< int,ccmc::Interpolator * >""'");
    } else {
      ccmc::interpolatorObjects = *((boost::unordered_map< int,ccmc::Interpolator * > *)(argp));
    }
  }
fail:
  return octave_value_list();
}


SWIG_DEFUN( interpolatorObjects_get, _wrap_interpolatorObjects_get, std::string() ) {
  octave_value obj;
  
  obj = SWIG_NewPointerObj(SWIG_as_voidptr(&ccmc::interpolatorObjects), SWIGTYPE_p_boost__unordered_mapT_int_ccmc__Interpolator_p_t,  0 );
  return obj;
}


SWIG_DEFUN( generalFileReaderObjects_set, _wrap_generalFileReaderObjects_set, std::string() ) {
  if (!SWIG_check_num_args("generalFileReaderObjects_set",args.length(),1,1,0)) return octave_value_list();
  
  {
    void *argp = 0;
    int res = SWIG_ConvertPtr(args(0), &argp, SWIGTYPE_p_boost__unordered_mapT_int_ccmc__GeneralFileReader_p_t,  0 );
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in variable '""ccmc::generalFileReaderObjects""' of type '""boost::unordered_map< int,ccmc::GeneralFileReader * >""'");
    }
    if (!argp) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in variable '""ccmc::generalFileReaderObjects""' of type '""boost::unordered_map< int,ccmc::GeneralFileReader * >""'");
    } else {
      ccmc::generalFileReaderObjects = *((boost::unordered_map< int,ccmc::GeneralFileReader * > *)(argp));
    }
  }
fail:
  return octave_value_list();
}


SWIG_DEFUN( generalFileReaderObjects_get, _wrap_generalFileReaderObjects_get, std::string() ) {
  octave_value obj;
  
  obj = SWIG_NewPointerObj(SWIG_as_voidptr(&ccmc::generalFileReaderObjects), SWIGTYPE_p_boost__unordered_mapT_int_ccmc__GeneralFileReader_p_t,  0 );
  return obj;
}


SWIG_DEFUN( timeInterpolatorObjects_set, _wrap_timeInterpolatorObjects_set, std::string() ) {
  if (!SWIG_check_num_args("timeInterpolatorObjects_set",args.length(),1,1,0)) return octave_value_list();
  
  {
    void *argp = 0;
    int res = SWIG_ConvertPtr(args(0), &argp, SWIGTYPE_p_boost__unordered_mapT_int_ccmc__TimeInterpolator_p_t,  0 );
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in variable '""ccmc::timeInterpolatorObjects""' of type '""boost::unordered_map< int,ccmc::TimeInterpolator * >""'");
    }
    if (!argp) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in variable '""ccmc::timeInterpolatorObjects""' of type '""boost::unordered_map< int,ccmc::TimeInterpolator * >""'");
    } else {
      ccmc::timeInterpolatorObjects = *((boost::unordered_map< int,ccmc::TimeInterpolator * > *)(argp));
    }
  }
fail:
  return octave_value_list();
}


SWIG_DEFUN( timeInterpolatorObjects_get, _wrap_timeInterpolatorObjects_get, std::string() ) {
  octave_value obj;
  
  obj = SWIG_NewPointerObj(SWIG_as_voidptr(&ccmc::timeInterpolatorObjects), SWIGTYPE_p_boost__unordered_mapT_int_ccmc__TimeInterpolator_p_t,  0 );
  return obj;
}


static octave_value_list _wrap_Interpolator_interpolate__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Interpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Interpolator_interpolate" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Interpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Interpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Interpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Interpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Interpolator_interpolate__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Interpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Interpolator_interpolate" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Interpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Interpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Interpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Interpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "Interpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "Interpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "Interpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Interpolator_interpolate__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Interpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Interpolator_interpolate" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Interpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Interpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Interpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Interpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Interpolator_interpolate__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Interpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Interpolator_interpolate" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Interpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Interpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Interpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Interpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "Interpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "Interpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "Interpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Interpolator_interpolate, _wrap_Interpolator_interpolate, _wrap_Interpolator_interpolate_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[8]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5),octave_value_ref(args,6),octave_value_ref(args,7)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Interpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_Interpolator_interpolate__SWIG_2(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Interpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_Interpolator_interpolate__SWIG_0(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Interpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_Interpolator_interpolate__SWIG_3(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Interpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_Interpolator_interpolate__SWIG_1(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_Interpolator_getConversionFactor__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Interpolator_getConversionFactor",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Interpolator_getConversionFactor" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Interpolator_getConversionFactor" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Interpolator_getConversionFactor" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (float)(arg1)->getConversionFactor((std::string const &)*arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Interpolator_getConversionFactor__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  long *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Interpolator_getConversionFactor",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Interpolator_getConversionFactor" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Interpolator_getConversionFactor" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  result = (float)(arg1)->getConversionFactor((long const &)*arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Interpolator_getConversionFactor, _wrap_Interpolator_getConversionFactor, _wrap_Interpolator_getConversionFactor_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Interpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Interpolator_getConversionFactor__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Interpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Interpolator_getConversionFactor__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Interpolator_getModelName, _wrap_Interpolator_getModelName, _wrap_Interpolator_getModelName_texinfo ) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Interpolator_getModelName",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Interpolator_getModelName" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  result = (arg1)->getModelName();
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Interpolator, _wrap_delete_Interpolator, _wrap_delete_Interpolator_texinfo ) {
  ccmc::Interpolator *arg1 = (ccmc::Interpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Interpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Interpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Interpolator" "', argument " "1"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg1 = (ccmc::Interpolator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Interpolator_members[] = {
{"interpolate",_wrap_Interpolator_interpolate,0,0,0,0},
{"getConversionFactor",_wrap_Interpolator_getConversionFactor,0,0,0,0},
{"getModelName",_wrap_Interpolator_getModelName,0,0,0,0},
{0,0,0,0}
};
static const char *swig_Interpolator_base_names[] = {0};
static const swig_type_info *swig_Interpolator_base[] = {0};
static swig_octave_class _wrap_class_Interpolator = {"Interpolator", &SWIGTYPE_p_ccmc__Interpolator,0,0,0,_wrap_delete_Interpolator,swig_Interpolator_members,swig_Interpolator_base_names,swig_Interpolator_base };

SWIG_DEFUN( new_KameleonInterpolator, _wrap_new_KameleonInterpolator, _wrap_new_KameleonInterpolator_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::KameleonInterpolator *result = 0 ;
  
  if (!SWIG_check_num_args("new_KameleonInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_KameleonInterpolator" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (ccmc::KameleonInterpolator *)new ccmc::KameleonInterpolator(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__KameleonInterpolator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_KameleonInterpolator_interpolate__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::KameleonInterpolator *arg1 = (ccmc::KameleonInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("KameleonInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__KameleonInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "KameleonInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::KameleonInterpolator *""'"); 
  }
  arg1 = (ccmc::KameleonInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "KameleonInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "KameleonInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "KameleonInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "KameleonInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_KameleonInterpolator_interpolate__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::KameleonInterpolator *arg1 = (ccmc::KameleonInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("KameleonInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__KameleonInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "KameleonInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::KameleonInterpolator *""'"); 
  }
  arg1 = (ccmc::KameleonInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "KameleonInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "KameleonInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "KameleonInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "KameleonInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "KameleonInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "KameleonInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "KameleonInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_KameleonInterpolator_interpolate__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::KameleonInterpolator *arg1 = (ccmc::KameleonInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("KameleonInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__KameleonInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "KameleonInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::KameleonInterpolator *""'"); 
  }
  arg1 = (ccmc::KameleonInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "KameleonInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "KameleonInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "KameleonInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "KameleonInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_KameleonInterpolator_interpolate__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::KameleonInterpolator *arg1 = (ccmc::KameleonInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("KameleonInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__KameleonInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "KameleonInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::KameleonInterpolator *""'"); 
  }
  arg1 = (ccmc::KameleonInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "KameleonInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "KameleonInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "KameleonInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "KameleonInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "KameleonInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "KameleonInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "KameleonInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "KameleonInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( KameleonInterpolator_interpolate, _wrap_KameleonInterpolator_interpolate, _wrap_KameleonInterpolator_interpolate_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[8]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5),octave_value_ref(args,6),octave_value_ref(args,7)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__KameleonInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_KameleonInterpolator_interpolate__SWIG_2(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__KameleonInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_KameleonInterpolator_interpolate__SWIG_0(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__KameleonInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_KameleonInterpolator_interpolate__SWIG_3(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__KameleonInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_KameleonInterpolator_interpolate__SWIG_1(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( delete_KameleonInterpolator, _wrap_delete_KameleonInterpolator, _wrap_delete_KameleonInterpolator_texinfo ) {
  ccmc::KameleonInterpolator *arg1 = (ccmc::KameleonInterpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_KameleonInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__KameleonInterpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_KameleonInterpolator" "', argument " "1"" of type '" "ccmc::KameleonInterpolator *""'"); 
  }
  arg1 = (ccmc::KameleonInterpolator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_KameleonInterpolator_members[] = {
{"interpolate",_wrap_KameleonInterpolator_interpolate,0,0,0,0},
{0,0,0,0}
};
static const char *swig_KameleonInterpolator_base_names[] = {"_p_ccmc__Interpolator",0};
static const swig_type_info *swig_KameleonInterpolator_base[] = {0,0};
static swig_octave_class _wrap_class_KameleonInterpolator = {"KameleonInterpolator", &SWIGTYPE_p_ccmc__KameleonInterpolator,0,_wrap_new_KameleonInterpolator,0,_wrap_delete_KameleonInterpolator,swig_KameleonInterpolator_members,swig_KameleonInterpolator_base_names,swig_KameleonInterpolator_base };

SWIG_DEFUN( new_Tracer, _wrap_new_Tracer, _wrap_new_Tracer_texinfo ) {
  ccmc::Kameleon *arg1 = (ccmc::Kameleon *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Tracer *result = 0 ;
  
  if (!SWIG_check_num_args("new_Tracer",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Kameleon, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_Tracer" "', argument " "1"" of type '" "ccmc::Kameleon *""'"); 
  }
  arg1 = (ccmc::Kameleon *)(argp1);
  result = (ccmc::Tracer *)new ccmc::Tracer(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Tracer, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Tracer, _wrap_delete_Tracer, _wrap_delete_Tracer_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Tracer",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Tracer" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setInnerBoundary, _wrap_Tracer_setInnerBoundary, _wrap_Tracer_setInnerBoundary_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setInnerBoundary",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setInnerBoundary" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setInnerBoundary" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  (arg1)->setInnerBoundary(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setMaxIterations, _wrap_Tracer_setMaxIterations, _wrap_Tracer_setMaxIterations_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setMaxIterations",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setMaxIterations" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setMaxIterations" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  (arg1)->setMaxIterations(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setDn, _wrap_Tracer_setDn, _wrap_Tracer_setDn_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setDn",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setDn" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setDn" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  (arg1)->setDn(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setTilt, _wrap_Tracer_setTilt, _wrap_Tracer_setTilt_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setTilt",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setTilt" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setTilt" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  (arg1)->setTilt(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setMissing, _wrap_Tracer_setMissing, _wrap_Tracer_setMissing_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setMissing",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setMissing" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setMissing" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  (arg1)->setMissing(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setMaxArcLength, _wrap_Tracer_setMaxArcLength, _wrap_Tracer_setMaxArcLength_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setMaxArcLength",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setMaxArcLength" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setMaxArcLength" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  (arg1)->setMaxArcLength(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_bidirectionalTrace, _wrap_Tracer_bidirectionalTrace, _wrap_Tracer_bidirectionalTrace_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Fieldline result;
  
  if (!SWIG_check_num_args("Tracer_bidirectionalTrace",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_bidirectionalTrace" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_bidirectionalTrace" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_bidirectionalTrace" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_bidirectionalTrace" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Tracer_bidirectionalTrace" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Tracer_bidirectionalTrace" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (arg1)->bidirectionalTrace((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_NewPointerObj((new Fieldline((const Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Tracer_bidirectionalTraceWithDipole, _wrap_Tracer_bidirectionalTraceWithDipole, _wrap_Tracer_bidirectionalTraceWithDipole_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Fieldline result;
  
  if (!SWIG_check_num_args("Tracer_bidirectionalTraceWithDipole",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_bidirectionalTraceWithDipole" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_bidirectionalTraceWithDipole" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_bidirectionalTraceWithDipole" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_bidirectionalTraceWithDipole" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Tracer_bidirectionalTraceWithDipole" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Tracer_bidirectionalTraceWithDipole" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (arg1)->bidirectionalTraceWithDipole((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_NewPointerObj((new Fieldline((const Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Tracer_unidirectionalTrace__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  ccmc::Tracer::Direction *arg6 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  int val6 ;
  int ecode6 ;
  ccmc::Tracer::Direction temp6 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Fieldline result;
  
  if (!SWIG_check_num_args("Tracer_unidirectionalTrace",args.length(),6,6,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_unidirectionalTrace" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_unidirectionalTrace" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_unidirectionalTrace" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_unidirectionalTrace" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Tracer_unidirectionalTrace" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Tracer_unidirectionalTrace" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  ecode6 = SWIG_AsVal_int (args(5), &val6);
  if (!SWIG_IsOK(ecode6)) {
    SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "Tracer_unidirectionalTrace" "', argument " "6"" of type '" "ccmc::Tracer::Direction const &""'");
  } else {
    temp6 = (ccmc::Tracer::Direction)(val6);
    arg6 = &temp6;
  }
  result = (arg1)->unidirectionalTrace((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,(ccmc::Tracer::Direction const &)*arg6);
  _outv = SWIG_NewPointerObj((new Fieldline((const Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Tracer_unidirectionalTrace__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Fieldline result;
  
  if (!SWIG_check_num_args("Tracer_unidirectionalTrace",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_unidirectionalTrace" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_unidirectionalTrace" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_unidirectionalTrace" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_unidirectionalTrace" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Tracer_unidirectionalTrace" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Tracer_unidirectionalTrace" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (arg1)->unidirectionalTrace((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_NewPointerObj((new Fieldline((const Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Tracer_unidirectionalTrace, _wrap_Tracer_unidirectionalTrace, _wrap_Tracer_unidirectionalTrace_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[6]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Tracer, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_Tracer_unidirectionalTrace__SWIG_1(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Tracer, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                int res = SWIG_AsVal_int(argv[5], NULL);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                return _wrap_Tracer_unidirectionalTrace__SWIG_0(args, nargout);
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_Tracer_unidirectionalTraceWithDipole__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  ccmc::Tracer::Direction *arg6 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  int val6 ;
  int ecode6 ;
  ccmc::Tracer::Direction temp6 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Fieldline result;
  
  if (!SWIG_check_num_args("Tracer_unidirectionalTraceWithDipole",args.length(),6,6,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  ecode6 = SWIG_AsVal_int (args(5), &val6);
  if (!SWIG_IsOK(ecode6)) {
    SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "6"" of type '" "ccmc::Tracer::Direction const &""'");
  } else {
    temp6 = (ccmc::Tracer::Direction)(val6);
    arg6 = &temp6;
  }
  result = (arg1)->unidirectionalTraceWithDipole((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,(ccmc::Tracer::Direction const &)*arg6);
  _outv = SWIG_NewPointerObj((new Fieldline((const Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Tracer_unidirectionalTraceWithDipole__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Fieldline result;
  
  if (!SWIG_check_num_args("Tracer_unidirectionalTraceWithDipole",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Tracer_unidirectionalTraceWithDipole" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (arg1)->unidirectionalTraceWithDipole((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_NewPointerObj((new Fieldline((const Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Tracer_unidirectionalTraceWithDipole, _wrap_Tracer_unidirectionalTraceWithDipole, _wrap_Tracer_unidirectionalTraceWithDipole_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[6]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Tracer, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_Tracer_unidirectionalTraceWithDipole__SWIG_1(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Tracer, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              {
                int res = SWIG_AsVal_int(argv[5], NULL);
                _v = SWIG_CheckState(res);
              }
              if (_v) {
                return _wrap_Tracer_unidirectionalTraceWithDipole__SWIG_0(args, nargout);
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Tracer_findLastClosed, _wrap_Tracer_findLastClosed, _wrap_Tracer_findLastClosed_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  Point3f arg2 ;
  int arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Fieldline result;
  
  if (!SWIG_check_num_args("Tracer_findLastClosed",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_findLastClosed" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_findLastClosed" "', argument " "2"" of type '" "Point3f""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_findLastClosed" "', argument " "2"" of type '" "Point3f""'");
    } else {
      arg2 = *((Point3f *)(argp2));
    }
  }
  ecode3 = SWIG_AsVal_int(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_findLastClosed" "', argument " "3"" of type '" "int""'");
  } 
  arg3 = (int)(val3);
  result = (arg1)->findLastClosed(arg2,arg3);
  _outv = SWIG_NewPointerObj((new Fieldline((const Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_getLastClosedFieldlines, _wrap_Tracer_getLastClosedFieldlines, _wrap_Tracer_getLastClosedFieldlines_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  int val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< ccmc::Fieldline,std::allocator< ccmc::Fieldline > > > result;
  
  if (!SWIG_check_num_args("Tracer_getLastClosedFieldlines",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_getLastClosedFieldlines" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_getLastClosedFieldlines" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  ecode3 = SWIG_AsVal_int(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Tracer_getLastClosedFieldlines" "', argument " "3"" of type '" "int""'");
  } 
  arg3 = (int)(val3);
  ecode4 = SWIG_AsVal_int(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "Tracer_getLastClosedFieldlines" "', argument " "4"" of type '" "int""'");
  } 
  arg4 = (int)(val4);
  result = (arg1)->getLastClosedFieldlines(arg2,arg3,arg4);
  _outv = SWIG_NewPointerObj((new std::vector< Fieldline,std::allocator< ccmc::Fieldline > >((const std::vector< Fieldline,std::allocator< ccmc::Fieldline > >&)(result))), SWIGTYPE_p_std__vectorT_ccmc__Fieldline_std__allocatorT_ccmc__Fieldline_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_isClosed, _wrap_Tracer_isClosed, _wrap_Tracer_isClosed_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  Fieldline *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("Tracer_isClosed",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_isClosed" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Fieldline,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_isClosed" "', argument " "2"" of type '" "Fieldline &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_isClosed" "', argument " "2"" of type '" "Fieldline &""'"); 
  }
  arg2 = (Fieldline *)(argp2);
  result = (bool)(arg1)->isClosed(*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setUseMaxArcLength, _wrap_Tracer_setUseMaxArcLength, _wrap_Tracer_setUseMaxArcLength_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  bool arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  bool val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setUseMaxArcLength",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setUseMaxArcLength" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_bool(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setUseMaxArcLength" "', argument " "2"" of type '" "bool""'");
  } 
  arg2 = (bool)(val2);
  (arg1)->setUseMaxArcLength(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_getVector, _wrap_Tracer_getVector, _wrap_Tracer_getVector_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  std::string *arg2 = 0 ;
  Point3f *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  ccmc::Interpolator *arg7 = (ccmc::Interpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  void *argp3 ;
  int res3 = 0 ;
  void *argp4 = 0 ;
  int res4 = 0 ;
  void *argp5 = 0 ;
  int res5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Point3f result;
  
  if (!SWIG_check_num_args("Tracer_getVector",args.length(),7,7,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_getVector" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_getVector" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_getVector" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  res3 = SWIG_ConvertPtr(args(2), &argp3, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res3)) {
    SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "Tracer_getVector" "', argument " "3"" of type '" "Point3f const &""'"); 
  }
  if (!argp3) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_getVector" "', argument " "3"" of type '" "Point3f const &""'"); 
  }
  arg3 = (Point3f *)(argp3);
  res4 = SWIG_ConvertPtr(args(3), &argp4, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res4)) {
    SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "Tracer_getVector" "', argument " "4"" of type '" "float &""'"); 
  }
  if (!argp4) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_getVector" "', argument " "4"" of type '" "float &""'"); 
  }
  arg4 = (float *)(argp4);
  res5 = SWIG_ConvertPtr(args(4), &argp5, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res5)) {
    SWIG_exception_fail(SWIG_ArgError(res5), "in method '" "Tracer_getVector" "', argument " "5"" of type '" "float &""'"); 
  }
  if (!argp5) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_getVector" "', argument " "5"" of type '" "float &""'"); 
  }
  arg5 = (float *)(argp5);
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "Tracer_getVector" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_getVector" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7,SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "Tracer_getVector" "', argument " "7"" of type '" "ccmc::Interpolator const *""'"); 
  }
  arg7 = (ccmc::Interpolator *)(argp7);
  result = (arg1)->getVector((std::string const &)*arg2,(Point3f const &)*arg3,*arg4,*arg5,*arg6,(ccmc::Interpolator const *)arg7);
  _outv = SWIG_NewPointerObj((new Point3f((const Point3f&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setRegionOfInterest, _wrap_Tracer_setRegionOfInterest, _wrap_Tracer_setRegionOfInterest_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  Point3f arg2 ;
  Point3f arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  void *argp3 ;
  int res3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setRegionOfInterest",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setRegionOfInterest" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  {
    res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_setRegionOfInterest" "', argument " "2"" of type '" "Point3f""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_setRegionOfInterest" "', argument " "2"" of type '" "Point3f""'");
    } else {
      arg2 = *((Point3f *)(argp2));
    }
  }
  {
    res3 = SWIG_ConvertPtr(args(2), &argp3, SWIGTYPE_p_ccmc__Point3f,  0 );
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "Tracer_setRegionOfInterest" "', argument " "3"" of type '" "Point3f""'"); 
    }  
    if (!argp3) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Tracer_setRegionOfInterest" "', argument " "3"" of type '" "Point3f""'");
    } else {
      arg3 = *((Point3f *)(argp3));
    }
  }
  (arg1)->setRegionOfInterest(arg2,arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_setUseRegionOfInterest, _wrap_Tracer_setUseRegionOfInterest, _wrap_Tracer_setUseRegionOfInterest_texinfo ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  bool arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  bool val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_setUseRegionOfInterest",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_setUseRegionOfInterest" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  ecode2 = SWIG_AsVal_bool(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Tracer_setUseRegionOfInterest" "', argument " "2"" of type '" "bool""'");
  } 
  arg2 = (bool)(val2);
  (arg1)->setUseRegionOfInterest(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_interpolator_set, _wrap_Tracer_interpolator_set, std::string() ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  ccmc::Interpolator *arg2 = (ccmc::Interpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Tracer_interpolator_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_interpolator_set" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2,SWIGTYPE_p_ccmc__Interpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Tracer_interpolator_set" "', argument " "2"" of type '" "ccmc::Interpolator *""'"); 
  }
  arg2 = (ccmc::Interpolator *)(argp2);
  if (arg1) (arg1)->interpolator = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Tracer_interpolator_get, _wrap_Tracer_interpolator_get, std::string() ) {
  ccmc::Tracer *arg1 = (ccmc::Tracer *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("Tracer_interpolator_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Tracer, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Tracer_interpolator_get" "', argument " "1"" of type '" "ccmc::Tracer *""'"); 
  }
  arg1 = (ccmc::Tracer *)(argp1);
  result = (ccmc::Interpolator *) ((arg1)->interpolator);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Tracer_members[] = {
{"setInnerBoundary",_wrap_Tracer_setInnerBoundary,0,0,0,0},
{"setMaxIterations",_wrap_Tracer_setMaxIterations,0,0,0,0},
{"setDn",_wrap_Tracer_setDn,0,0,0,0},
{"setTilt",_wrap_Tracer_setTilt,0,0,0,0},
{"setMissing",_wrap_Tracer_setMissing,0,0,0,0},
{"setMaxArcLength",_wrap_Tracer_setMaxArcLength,0,0,0,0},
{"bidirectionalTrace",_wrap_Tracer_bidirectionalTrace,0,0,0,0},
{"bidirectionalTraceWithDipole",_wrap_Tracer_bidirectionalTraceWithDipole,0,0,0,0},
{"unidirectionalTrace",_wrap_Tracer_unidirectionalTrace,0,0,0,0},
{"unidirectionalTraceWithDipole",_wrap_Tracer_unidirectionalTraceWithDipole,0,0,0,0},
{"findLastClosed",_wrap_Tracer_findLastClosed,0,0,0,0},
{"getLastClosedFieldlines",_wrap_Tracer_getLastClosedFieldlines,0,0,0,0},
{"isClosed",_wrap_Tracer_isClosed,0,0,0,0},
{"setUseMaxArcLength",_wrap_Tracer_setUseMaxArcLength,0,0,0,0},
{"getVector",_wrap_Tracer_getVector,0,0,0,0},
{"setRegionOfInterest",_wrap_Tracer_setRegionOfInterest,0,0,0,0},
{"setUseRegionOfInterest",_wrap_Tracer_setUseRegionOfInterest,0,0,0,0},
{"interpolator",0,_wrap_Tracer_interpolator_get,_wrap_Tracer_interpolator_set,0,0},
{0,0,0,0}
};
static const char *swig_Tracer_base_names[] = {0};
static const swig_type_info *swig_Tracer_base[] = {0};
static swig_octave_class _wrap_class_Tracer = {"Tracer", &SWIGTYPE_p_ccmc__Tracer,0,_wrap_new_Tracer,0,_wrap_delete_Tracer,swig_Tracer_members,swig_Tracer_base_names,swig_Tracer_base };

static octave_value_list _wrap_new_Fieldline__SWIG_0 (const octave_value_list& args, int nargout) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Fieldline *result = 0 ;
  
  if (!SWIG_check_num_args("new_Fieldline",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::Fieldline *)new ccmc::Fieldline();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Fieldline, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_Fieldline__SWIG_1 (const octave_value_list& args, int nargout) {
  int arg1 ;
  int val1 ;
  int ecode1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Fieldline *result = 0 ;
  
  if (!SWIG_check_num_args("new_Fieldline",args.length(),1,1,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_int(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_Fieldline" "', argument " "1"" of type '" "int""'");
  } 
  arg1 = (int)(val1);
  result = (ccmc::Fieldline *)new ccmc::Fieldline(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Fieldline, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( new_Fieldline, _wrap_new_Fieldline, _wrap_new_Fieldline_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[1]={
    octave_value_ref(args,0)
  };
  
  if (argc == 0) {
    return _wrap_new_Fieldline__SWIG_0(args, nargout);
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_int(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_Fieldline__SWIG_1(args, nargout);
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( delete_Fieldline, _wrap_delete_Fieldline, _wrap_delete_Fieldline_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Fieldline",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Fieldline" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_insertPointData, _wrap_Fieldline_insertPointData, _wrap_Fieldline_insertPointData_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  Point3f *arg2 = 0 ;
  float *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_insertPointData",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_insertPointData" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Fieldline_insertPointData" "', argument " "2"" of type '" "Point3f const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Fieldline_insertPointData" "', argument " "2"" of type '" "Point3f const &""'"); 
  }
  arg2 = (Point3f *)(argp2);
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Fieldline_insertPointData" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  (arg1)->insertPointData((Point3f const &)*arg2,(float const &)*arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_removePoint, _wrap_Fieldline_removePoint, _wrap_Fieldline_removePoint_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_removePoint",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_removePoint" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_removePoint" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  (arg1)->removePoint(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_reverseOrder, _wrap_Fieldline_reverseOrder, _wrap_Fieldline_reverseOrder_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Fieldline result;
  
  if (!SWIG_check_num_args("Fieldline_reverseOrder",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_reverseOrder" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (arg1)->reverseOrder();
  _outv = SWIG_NewPointerObj((new ccmc::Fieldline((const ccmc::Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_reverseOrderInPlace, _wrap_Fieldline_reverseOrderInPlace, _wrap_Fieldline_reverseOrderInPlace_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_reverseOrderInPlace",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_reverseOrderInPlace" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  (arg1)->reverseOrderInPlace();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getPositions, _wrap_Fieldline_getPositions, _wrap_Fieldline_getPositions_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< Point3f,std::allocator< ccmc::Point3f > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getPositions",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getPositions" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< Point3f,std::allocator< ccmc::Point3f > > *) &(arg1)->getPositions();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Fieldline_getData__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getData",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getData" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< float,std::allocator< float > > *) &(arg1)->getData();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_size, _wrap_Fieldline_size, _wrap_Fieldline_size_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Fieldline_size",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_size" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (int)(arg1)->size();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getPosition, _wrap_Fieldline_getPosition, _wrap_Fieldline_getPosition_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Point3f *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getPosition",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getPosition" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_getPosition" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  result = (Point3f *) &(arg1)->getPosition(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Fieldline_getData__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Fieldline_getData",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getData" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_getData" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  result = (float)(arg1)->getData(arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getData, _wrap_Fieldline_getData, _wrap_Fieldline_getData_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Fieldline, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_Fieldline_getData__SWIG_0(args, nargout);
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Fieldline, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_int(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Fieldline_getData__SWIG_1(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Fieldline_getStartPoint, _wrap_Fieldline_getStartPoint, _wrap_Fieldline_getStartPoint_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Point3f result;
  
  if (!SWIG_check_num_args("Fieldline_getStartPoint",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getStartPoint" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (arg1)->getStartPoint();
  _outv = SWIG_NewPointerObj((new Point3f((const Point3f&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_reserve, _wrap_Fieldline_reserve, _wrap_Fieldline_reserve_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_reserve",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_reserve" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_reserve" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  (arg1)->reserve(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_setStartPoint, _wrap_Fieldline_setStartPoint, _wrap_Fieldline_setStartPoint_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  Point3f arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_setStartPoint",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_setStartPoint" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  {
    res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Fieldline_setStartPoint" "', argument " "2"" of type '" "Point3f""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Fieldline_setStartPoint" "', argument " "2"" of type '" "Point3f""'");
    } else {
      arg2 = *((Point3f *)(argp2));
    }
  }
  (arg1)->setStartPoint(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_setVariable, _wrap_Fieldline_setVariable, _wrap_Fieldline_setVariable_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  std::string arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_setVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_setVariable" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    int res = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res) || !ptr) {
      SWIG_exception_fail(SWIG_ArgError((ptr ? res : SWIG_TypeError)), "in method '" "Fieldline_setVariable" "', argument " "2"" of type '" "std::string""'"); 
    }
    arg2 = *ptr;
    if (SWIG_IsNewObj(res)) delete ptr;
  }
  (arg1)->setVariable(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getVariable, _wrap_Fieldline_getVariable, _wrap_Fieldline_getVariable_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getVariable",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getVariable" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::string *) &(arg1)->getVariable();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getDs, _wrap_Fieldline_getDs, _wrap_Fieldline_getDs_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getDs",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getDs" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< float,std::allocator< float > > *) &(arg1)->getDs();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getElements, _wrap_Fieldline_getElements, _wrap_Fieldline_getElements_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< Point3f,std::allocator< ccmc::Point3f > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getElements",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getElements" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< Point3f,std::allocator< ccmc::Point3f > > *) &(arg1)->getElements();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getElement, _wrap_Fieldline_getElement, _wrap_Fieldline_getElement_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  Point3f *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getElement",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getElement" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_getElement" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  result = (Point3f *) &(arg1)->getElement(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_integrate, _wrap_Fieldline_integrate, _wrap_Fieldline_integrate_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_integrate",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_integrate" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< float,std::allocator< float > > *) &(arg1)->integrate();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_derivative, _wrap_Fieldline_derivative, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_derivative",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_derivative" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< float,std::allocator< float > > *) &(arg1)->derivative();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_measure, _wrap_Fieldline_measure, _wrap_Fieldline_measure_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_measure",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_measure" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< float,std::allocator< float > > *) &(arg1)->measure();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getLength, _wrap_Fieldline_getLength, _wrap_Fieldline_getLength_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Fieldline_getLength",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getLength" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_getLength" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  result = (float)(arg1)->getLength(arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getIntegral, _wrap_Fieldline_getIntegral, _wrap_Fieldline_getIntegral_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Fieldline_getIntegral",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getIntegral" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_getIntegral" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  result = (float)(arg1)->getIntegral(arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_interpolate, _wrap_Fieldline_interpolate, _wrap_Fieldline_interpolate_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  int arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  int val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Fieldline result;
  
  if (!SWIG_check_num_args("Fieldline_interpolate",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_interpolate" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_interpolate" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  ecode3 = SWIG_AsVal_int(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Fieldline_interpolate" "', argument " "3"" of type '" "int""'");
  } 
  arg3 = (int)(val3);
  result = (arg1)->interpolate(arg2,arg3);
  _outv = SWIG_NewPointerObj((new ccmc::Fieldline((const ccmc::Fieldline&)(result))), SWIGTYPE_p_ccmc__Fieldline, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getNearest, _wrap_Fieldline_getNearest, _wrap_Fieldline_getNearest_texinfo ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getNearest",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getNearest" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< int,std::allocator< int > > *) &(arg1)->getNearest();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_getTlocal, _wrap_Fieldline_getTlocal, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_getTlocal",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_getTlocal" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< float,std::allocator< float > > *) &(arg1)->getTlocal();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_minmax, _wrap_Fieldline_minmax, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_minmax",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_minmax" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  (arg1)->minmax();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_mincount_set, _wrap_Fieldline_mincount_set, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_mincount_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_mincount_set" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_mincount_set" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  if (arg1) (arg1)->mincount = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_mincount_get, _wrap_Fieldline_mincount_get, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Fieldline_mincount_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_mincount_get" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (int) ((arg1)->mincount);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_maxcount_set, _wrap_Fieldline_maxcount_set, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_maxcount_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_maxcount_set" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_maxcount_set" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  if (arg1) (arg1)->maxcount = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_maxcount_get, _wrap_Fieldline_maxcount_get, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Fieldline_maxcount_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_maxcount_get" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (int) ((arg1)->maxcount);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_minima_set, _wrap_Fieldline_minima_set, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  std::vector< int,std::allocator< int > > *arg2 = (std::vector< int,std::allocator< int > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_minima_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_minima_set" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2,SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Fieldline_minima_set" "', argument " "2"" of type '" "std::vector< int,std::allocator< int > > *""'"); 
  }
  arg2 = (std::vector< int,std::allocator< int > > *)(argp2);
  if (arg1) (arg1)->minima = *arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_minima_get, _wrap_Fieldline_minima_get, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_minima_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_minima_get" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< int,std::allocator< int > > *)& ((arg1)->minima);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_maxima_set, _wrap_Fieldline_maxima_set, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  std::vector< int,std::allocator< int > > *arg2 = (std::vector< int,std::allocator< int > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_maxima_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_maxima_set" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2,SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Fieldline_maxima_set" "', argument " "2"" of type '" "std::vector< int,std::allocator< int > > *""'"); 
  }
  arg2 = (std::vector< int,std::allocator< int > > *)(argp2);
  if (arg1) (arg1)->maxima = *arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_maxima_get, _wrap_Fieldline_maxima_get, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Fieldline_maxima_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_maxima_get" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (std::vector< int,std::allocator< int > > *)& ((arg1)->maxima);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_GlobMinIndex_set, _wrap_Fieldline_GlobMinIndex_set, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_GlobMinIndex_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_GlobMinIndex_set" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_GlobMinIndex_set" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  if (arg1) (arg1)->GlobMinIndex = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_GlobMinIndex_get, _wrap_Fieldline_GlobMinIndex_get, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Fieldline_GlobMinIndex_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_GlobMinIndex_get" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (int) ((arg1)->GlobMinIndex);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_GlobMaxIndex_set, _wrap_Fieldline_GlobMaxIndex_set, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  int arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Fieldline_GlobMaxIndex_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_GlobMaxIndex_set" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Fieldline_GlobMaxIndex_set" "', argument " "2"" of type '" "int""'");
  } 
  arg2 = (int)(val2);
  if (arg1) (arg1)->GlobMaxIndex = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Fieldline_GlobMaxIndex_get, _wrap_Fieldline_GlobMaxIndex_get, std::string() ) {
  ccmc::Fieldline *arg1 = (ccmc::Fieldline *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Fieldline_GlobMaxIndex_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Fieldline, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Fieldline_GlobMaxIndex_get" "', argument " "1"" of type '" "ccmc::Fieldline *""'"); 
  }
  arg1 = (ccmc::Fieldline *)(argp1);
  result = (int) ((arg1)->GlobMaxIndex);
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Fieldline_members[] = {
{"insertPointData",_wrap_Fieldline_insertPointData,0,0,0,0},
{"removePoint",_wrap_Fieldline_removePoint,0,0,0,0},
{"reverseOrder",_wrap_Fieldline_reverseOrder,0,0,0,0},
{"reverseOrderInPlace",_wrap_Fieldline_reverseOrderInPlace,0,0,0,0},
{"getPositions",_wrap_Fieldline_getPositions,0,0,0,0},
{"size",_wrap_Fieldline_size,0,0,0,0},
{"getPosition",_wrap_Fieldline_getPosition,0,0,0,0},
{"getData",_wrap_Fieldline_getData,0,0,0,0},
{"getStartPoint",_wrap_Fieldline_getStartPoint,0,0,0,0},
{"reserve",_wrap_Fieldline_reserve,0,0,0,0},
{"setStartPoint",_wrap_Fieldline_setStartPoint,0,0,0,0},
{"setVariable",_wrap_Fieldline_setVariable,0,0,0,0},
{"getVariable",_wrap_Fieldline_getVariable,0,0,0,0},
{"getDs",_wrap_Fieldline_getDs,0,0,0,0},
{"getElements",_wrap_Fieldline_getElements,0,0,0,0},
{"getElement",_wrap_Fieldline_getElement,0,0,0,0},
{"integrate",_wrap_Fieldline_integrate,0,0,0,0},
{"derivative",_wrap_Fieldline_derivative,0,0,0,0},
{"measure",_wrap_Fieldline_measure,0,0,0,0},
{"getLength",_wrap_Fieldline_getLength,0,0,0,0},
{"getIntegral",_wrap_Fieldline_getIntegral,0,0,0,0},
{"interpolate",_wrap_Fieldline_interpolate,0,0,0,0},
{"getNearest",_wrap_Fieldline_getNearest,0,0,0,0},
{"getTlocal",_wrap_Fieldline_getTlocal,0,0,0,0},
{"minmax",_wrap_Fieldline_minmax,0,0,0,0},
{"mincount",0,_wrap_Fieldline_mincount_get,_wrap_Fieldline_mincount_set,0,0},
{"maxcount",0,_wrap_Fieldline_maxcount_get,_wrap_Fieldline_maxcount_set,0,0},
{"minima",0,_wrap_Fieldline_minima_get,_wrap_Fieldline_minima_set,0,0},
{"maxima",0,_wrap_Fieldline_maxima_get,_wrap_Fieldline_maxima_set,0,0},
{"GlobMinIndex",0,_wrap_Fieldline_GlobMinIndex_get,_wrap_Fieldline_GlobMinIndex_set,0,0},
{"GlobMaxIndex",0,_wrap_Fieldline_GlobMaxIndex_get,_wrap_Fieldline_GlobMaxIndex_set,0,0},
{0,0,0,0}
};
static const char *swig_Fieldline_base_names[] = {0};
static const swig_type_info *swig_Fieldline_base[] = {0};
static swig_octave_class _wrap_class_Fieldline = {"Fieldline", &SWIGTYPE_p_ccmc__Fieldline,0,_wrap_new_Fieldline,0,_wrap_delete_Fieldline,swig_Fieldline_members,swig_Fieldline_base_names,swig_Fieldline_base };

static octave_value_list _wrap_new_Point3f__SWIG_0 (const octave_value_list& args, int nargout) {
  float *arg1 = 0 ;
  float *arg2 = 0 ;
  float *arg3 = 0 ;
  float temp1 ;
  float val1 ;
  int ecode1 = 0 ;
  float temp2 ;
  float val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f *result = 0 ;
  
  if (!SWIG_check_num_args("new_Point3f",args.length(),3,3,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_float(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_Point3f" "', argument " "1"" of type '" "float""'");
  } 
  temp1 = (float)(val1);
  arg1 = &temp1;
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "new_Point3f" "', argument " "2"" of type '" "float""'");
  } 
  temp2 = (float)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "new_Point3f" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  result = (ccmc::Point3f *)new ccmc::Point3f((float const &)*arg1,(float const &)*arg2,(float const &)*arg3);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_Point3f__SWIG_1 (const octave_value_list& args, int nargout) {
  float *arg1 = 0 ;
  float *arg2 = 0 ;
  float *arg3 = 0 ;
  ccmc::Point3f::Coordinates arg4 ;
  float temp1 ;
  float val1 ;
  int ecode1 = 0 ;
  float temp2 ;
  float val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  int val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f *result = 0 ;
  
  if (!SWIG_check_num_args("new_Point3f",args.length(),4,4,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_float(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_Point3f" "', argument " "1"" of type '" "float""'");
  } 
  temp1 = (float)(val1);
  arg1 = &temp1;
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "new_Point3f" "', argument " "2"" of type '" "float""'");
  } 
  temp2 = (float)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "new_Point3f" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_int(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "new_Point3f" "', argument " "4"" of type '" "ccmc::Point3f::Coordinates""'");
  } 
  arg4 = (ccmc::Point3f::Coordinates)(val4);
  result = (ccmc::Point3f *)new ccmc::Point3f((float const &)*arg1,(float const &)*arg2,(float const &)*arg3,arg4);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_Point3f__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::Point3f *arg1 = 0 ;
  void *argp1 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f *result = 0 ;
  
  if (!SWIG_check_num_args("new_Point3f",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_Point3f" "', argument " "1"" of type '" "ccmc::Point3f const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_Point3f" "', argument " "1"" of type '" "ccmc::Point3f const &""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = (ccmc::Point3f *)new ccmc::Point3f((ccmc::Point3f const &)*arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_Point3f__SWIG_3 (const octave_value_list& args, int nargout) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f *result = 0 ;
  
  if (!SWIG_check_num_args("new_Point3f",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::Point3f *)new ccmc::Point3f();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_Point3f__SWIG_4 (const octave_value_list& args, int nargout) {
  ccmc::Point3f::Coordinates arg1 ;
  int val1 ;
  int ecode1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f *result = 0 ;
  
  if (!SWIG_check_num_args("new_Point3f",args.length(),1,1,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_int(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_Point3f" "', argument " "1"" of type '" "ccmc::Point3f::Coordinates""'");
  } 
  arg1 = (ccmc::Point3f::Coordinates)(val1);
  result = (ccmc::Point3f *)new ccmc::Point3f(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( new_Point3f, _wrap_new_Point3f, _wrap_new_Point3f_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[4]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3)
  };
  
  if (argc == 0) {
    return _wrap_new_Point3f__SWIG_3(args, nargout);
  }
  if (argc == 1) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Point3f, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_new_Point3f__SWIG_2(args, nargout);
    }
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_int(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_Point3f__SWIG_4(args, nargout);
    }
  }
  if (argc == 3) {
    int _v;
    {
      int res = SWIG_AsVal_float(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        int res = SWIG_AsVal_float(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_new_Point3f__SWIG_0(args, nargout);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      int res = SWIG_AsVal_float(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        int res = SWIG_AsVal_float(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_int(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_new_Point3f__SWIG_1(args, nargout);
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Point3f_normalize, _wrap_Point3f_normalize, _wrap_Point3f_normalize_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Point3f_normalize",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_normalize" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  (arg1)->normalize();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_toString, _wrap_Point3f_toString, _wrap_Point3f_toString_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Point3f_toString",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_toString" "', argument " "1"" of type '" "ccmc::Point3f const *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = ((ccmc::Point3f const *)arg1)->toString();
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_magnitude, _wrap_Point3f_magnitude, _wrap_Point3f_magnitude_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Point3f_magnitude",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_magnitude" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = (float)(arg1)->magnitude();
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_distance, _wrap_Point3f_distance, _wrap_Point3f_distance_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  ccmc::Point3f *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Point3f_distance",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_distance" "', argument " "1"" of type '" "ccmc::Point3f const *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Point3f_distance" "', argument " "2"" of type '" "ccmc::Point3f const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Point3f_distance" "', argument " "2"" of type '" "ccmc::Point3f const &""'"); 
  }
  arg2 = (ccmc::Point3f *)(argp2);
  result = (float)((ccmc::Point3f const *)arg1)->distance((ccmc::Point3f const &)*arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_component1_set, _wrap_Point3f_component1_set, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Point3f_component1_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_component1_set" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Point3f_component1_set" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  if (arg1) (arg1)->component1 = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_component1_get, _wrap_Point3f_component1_get, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Point3f_component1_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_component1_get" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = (float) ((arg1)->component1);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_component2_set, _wrap_Point3f_component2_set, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Point3f_component2_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_component2_set" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Point3f_component2_set" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  if (arg1) (arg1)->component2 = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_component2_get, _wrap_Point3f_component2_get, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Point3f_component2_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_component2_get" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = (float) ((arg1)->component2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_component3_set, _wrap_Point3f_component3_set, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Point3f_component3_set",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_component3_set" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Point3f_component3_set" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  if (arg1) (arg1)->component3 = arg2;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_component3_get, _wrap_Point3f_component3_get, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Point3f_component3_get",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_component3_get" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = (float) ((arg1)->component3);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f___add__, _wrap_Point3f___add__, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  ccmc::Point3f *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f result;
  
  if (!SWIG_check_num_args("Point3f___add__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f___add__" "', argument " "1"" of type '" "ccmc::Point3f const *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Point3f___add__" "', argument " "2"" of type '" "ccmc::Point3f const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Point3f___add__" "', argument " "2"" of type '" "ccmc::Point3f const &""'"); 
  }
  arg2 = (ccmc::Point3f *)(argp2);
  result = ((ccmc::Point3f const *)arg1)->operator +((ccmc::Point3f const &)*arg2);
  _outv = SWIG_NewPointerObj((new ccmc::Point3f((const ccmc::Point3f&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f___sub__, _wrap_Point3f___sub__, std::string() ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  ccmc::Point3f *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f result;
  
  if (!SWIG_check_num_args("Point3f___sub__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f___sub__" "', argument " "1"" of type '" "ccmc::Point3f const *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Point3f___sub__" "', argument " "2"" of type '" "ccmc::Point3f const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Point3f___sub__" "', argument " "2"" of type '" "ccmc::Point3f const &""'"); 
  }
  arg2 = (ccmc::Point3f *)(argp2);
  result = ((ccmc::Point3f const *)arg1)->operator -((ccmc::Point3f const &)*arg2);
  _outv = SWIG_NewPointerObj((new ccmc::Point3f((const ccmc::Point3f&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Point3f___mul____SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f result;
  
  if (!SWIG_check_num_args("Point3f___mul__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f___mul__" "', argument " "1"" of type '" "ccmc::Point3f const *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Point3f___mul__" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  result = ((ccmc::Point3f const *)arg1)->operator *(arg2);
  _outv = SWIG_NewPointerObj((new ccmc::Point3f((const ccmc::Point3f&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Point3f___mul____SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  double arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  double val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f result;
  
  if (!SWIG_check_num_args("Point3f___mul__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f___mul__" "', argument " "1"" of type '" "ccmc::Point3f const *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  ecode2 = SWIG_AsVal_double(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Point3f___mul__" "', argument " "2"" of type '" "double""'");
  } 
  arg2 = (double)(val2);
  result = ((ccmc::Point3f const *)arg1)->operator *(arg2);
  _outv = SWIG_NewPointerObj((new ccmc::Point3f((const ccmc::Point3f&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f___mul__, _wrap_Point3f___mul__, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Point3f, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_float(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Point3f___mul____SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Point3f, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_double(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Point3f___mul____SWIG_1(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Point3f_setCoordinates, _wrap_Point3f_setCoordinates, _wrap_Point3f_setCoordinates_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  ccmc::Point3f::Coordinates arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Point3f_setCoordinates",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_setCoordinates" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  ecode2 = SWIG_AsVal_int(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Point3f_setCoordinates" "', argument " "2"" of type '" "ccmc::Point3f::Coordinates""'");
  } 
  arg2 = (ccmc::Point3f::Coordinates)(val2);
  (arg1)->setCoordinates(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_getCoordinates, _wrap_Point3f_getCoordinates, _wrap_Point3f_getCoordinates_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f::Coordinates result;
  
  if (!SWIG_check_num_args("Point3f_getCoordinates",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_getCoordinates" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = (ccmc::Point3f::Coordinates)(arg1)->getCoordinates();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Point3f_getCartesian, _wrap_Point3f_getCartesian, _wrap_Point3f_getCartesian_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Point3f result;
  
  if (!SWIG_check_num_args("Point3f_getCartesian",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Point3f_getCartesian" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  result = (arg1)->getCartesian();
  _outv = SWIG_NewPointerObj((new ccmc::Point3f((const ccmc::Point3f&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Point3f, _wrap_delete_Point3f, _wrap_delete_Point3f_texinfo ) {
  ccmc::Point3f *arg1 = (ccmc::Point3f *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Point3f",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Point3f" "', argument " "1"" of type '" "ccmc::Point3f *""'"); 
  }
  arg1 = (ccmc::Point3f *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Point3f_members[] = {
{"normalize",_wrap_Point3f_normalize,0,0,0,0},
{"toString",_wrap_Point3f_toString,0,0,0,0},
{"magnitude",_wrap_Point3f_magnitude,0,0,0,0},
{"distance",_wrap_Point3f_distance,0,0,0,0},
{"component1",0,_wrap_Point3f_component1_get,_wrap_Point3f_component1_set,0,0},
{"component2",0,_wrap_Point3f_component2_get,_wrap_Point3f_component2_set,0,0},
{"component3",0,_wrap_Point3f_component3_get,_wrap_Point3f_component3_set,0,0},
{"__add__",_wrap_Point3f___add__,0,0,0,0},
{"__sub__",_wrap_Point3f___sub__,0,0,0,0},
{"__mul__",_wrap_Point3f___mul__,0,0,0,0},
{"setCoordinates",_wrap_Point3f_setCoordinates,0,0,0,0},
{"getCoordinates",_wrap_Point3f_getCoordinates,0,0,0,0},
{"getCartesian",_wrap_Point3f_getCartesian,0,0,0,0},
{0,0,0,0}
};
static const char *swig_Point3f_base_names[] = {0};
static const swig_type_info *swig_Point3f_base[] = {0};
static swig_octave_class _wrap_class_Point3f = {"Point3f", &SWIGTYPE_p_ccmc__Point3f,0,_wrap_new_Point3f,0,_wrap_delete_Point3f,swig_Point3f_members,swig_Point3f_base_names,swig_Point3f_base };

SWIG_DEFUN( Attribute_getAttributeName, _wrap_Attribute_getAttributeName, _wrap_Attribute_getAttributeName_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Attribute_getAttributeName",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_getAttributeName" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  result = (arg1)->getAttributeName();
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Attribute_setAttributeName, _wrap_Attribute_setAttributeName, _wrap_Attribute_setAttributeName_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  std::string arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Attribute_setAttributeName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_setAttributeName" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    int res = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res) || !ptr) {
      SWIG_exception_fail(SWIG_ArgError((ptr ? res : SWIG_TypeError)), "in method '" "Attribute_setAttributeName" "', argument " "2"" of type '" "std::string""'"); 
    }
    arg2 = *ptr;
    if (SWIG_IsNewObj(res)) delete ptr;
  }
  (arg1)->setAttributeName(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Attribute_setAttributeValue__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Attribute_setAttributeValue",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_setAttributeValue" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_std__string,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Attribute_setAttributeValue" "', argument " "2"" of type '" "std::string &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Attribute_setAttributeValue" "', argument " "2"" of type '" "std::string &""'"); 
  }
  arg2 = (std::string *)(argp2);
  (arg1)->setAttributeValue(*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Attribute_setAttributeValue__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  int *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Attribute_setAttributeValue",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_setAttributeValue" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_int,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Attribute_setAttributeValue" "', argument " "2"" of type '" "int &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Attribute_setAttributeValue" "', argument " "2"" of type '" "int &""'"); 
  }
  arg2 = (int *)(argp2);
  (arg1)->setAttributeValue(*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_Attribute_setAttributeValue__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  float *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Attribute_setAttributeValue",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_setAttributeValue" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Attribute_setAttributeValue" "', argument " "2"" of type '" "float &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Attribute_setAttributeValue" "', argument " "2"" of type '" "float &""'"); 
  }
  arg2 = (float *)(argp2);
  (arg1)->setAttributeValue(*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Attribute_setAttributeValue, _wrap_Attribute_setAttributeValue, _wrap_Attribute_setAttributeValue_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Attribute, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_std__string, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Attribute_setAttributeValue__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Attribute, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_int, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Attribute_setAttributeValue__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Attribute, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_float, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Attribute_setAttributeValue__SWIG_2(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Attribute_getAttributeType, _wrap_Attribute_getAttributeType, _wrap_Attribute_getAttributeType_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Attribute::AttributeType result;
  
  if (!SWIG_check_num_args("Attribute_getAttributeType",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_getAttributeType" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  result = (ccmc::Attribute::AttributeType)(arg1)->getAttributeType();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Attribute_getAttributeFloat, _wrap_Attribute_getAttributeFloat, _wrap_Attribute_getAttributeFloat_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Attribute_getAttributeFloat",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_getAttributeFloat" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  result = (float)(arg1)->getAttributeFloat();
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Attribute_getAttributeString, _wrap_Attribute_getAttributeString, _wrap_Attribute_getAttributeString_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Attribute_getAttributeString",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_getAttributeString" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  result = (arg1)->getAttributeString();
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Attribute_getAttributeInt, _wrap_Attribute_getAttributeInt, _wrap_Attribute_getAttributeInt_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Attribute_getAttributeInt",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_getAttributeInt" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  result = (int)(arg1)->getAttributeInt();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( new_Attribute, _wrap_new_Attribute, _wrap_new_Attribute_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Attribute *result = 0 ;
  
  if (!SWIG_check_num_args("new_Attribute",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::Attribute *)new ccmc::Attribute();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Attribute, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Attribute_toString, _wrap_Attribute_toString, _wrap_Attribute_toString_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Attribute_toString",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Attribute_toString" "', argument " "1"" of type '" "ccmc::Attribute const *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  result = ((ccmc::Attribute const *)arg1)->toString();
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Attribute, _wrap_delete_Attribute, _wrap_delete_Attribute_texinfo ) {
  ccmc::Attribute *arg1 = (ccmc::Attribute *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Attribute",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Attribute, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Attribute" "', argument " "1"" of type '" "ccmc::Attribute *""'"); 
  }
  arg1 = (ccmc::Attribute *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Attribute_members[] = {
{"getAttributeName",_wrap_Attribute_getAttributeName,0,0,0,0},
{"setAttributeName",_wrap_Attribute_setAttributeName,0,0,0,0},
{"setAttributeValue",_wrap_Attribute_setAttributeValue,0,0,0,0},
{"getAttributeType",_wrap_Attribute_getAttributeType,0,0,0,0},
{"getAttributeFloat",_wrap_Attribute_getAttributeFloat,0,0,0,0},
{"getAttributeString",_wrap_Attribute_getAttributeString,0,0,0,0},
{"getAttributeInt",_wrap_Attribute_getAttributeInt,0,0,0,0},
{"toString",_wrap_Attribute_toString,0,0,0,0},
{0,0,0,0}
};
static const char *swig_Attribute_base_names[] = {0};
static const swig_type_info *swig_Attribute_base[] = {0};
static swig_octave_class _wrap_class_Attribute = {"Attribute", &SWIGTYPE_p_ccmc__Attribute,0,_wrap_new_Attribute,0,_wrap_delete_Attribute,swig_Attribute_members,swig_Attribute_base_names,swig_Attribute_base };

SWIG_DEFUN( Model_open, _wrap_Model_open, _wrap_Model_open_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Model_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_open" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Model_setModelName, _wrap_Model_setModelName, _wrap_Model_setModelName_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Model_setModelName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_setModelName" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    int res = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res) || !ptr) {
      SWIG_exception_fail(SWIG_ArgError((ptr ? res : SWIG_TypeError)), "in method '" "Model_setModelName" "', argument " "2"" of type '" "std::string""'"); 
    }
    arg2 = *ptr;
    if (SWIG_IsNewObj(res)) delete ptr;
  }
  (arg1)->setModelName(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getModelName, _wrap_Model_getModelName, _wrap_Model_getModelName_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Model_getModelName",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getModelName" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (arg1)->getModelName();
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_loadVariable, _wrap_Model_loadVariable, _wrap_Model_loadVariable_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Model_loadVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_loadVariable" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_loadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_loadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->loadVariable((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Model_unloadVariable, _wrap_Model_unloadVariable, _wrap_Model_unloadVariable_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Model_unloadVariable",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_unloadVariable" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_unloadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_unloadVariable" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->unloadVariable((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Model_loadVariableInt, _wrap_Model_loadVariableInt, _wrap_Model_loadVariableInt_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Model_loadVariableInt",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_loadVariableInt" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_loadVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_loadVariableInt" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->loadVariableInt((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Model_getVariableFromMapRW__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getVariableFromMapRW",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getVariableFromMapRW" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_getVariableFromMapRW" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_getVariableFromMapRW" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariableFromMapRW((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Model_getIntVariableFromMapRW__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getIntVariableFromMapRW",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getIntVariableFromMapRW" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_getIntVariableFromMapRW" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_getIntVariableFromMapRW" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getIntVariableFromMapRW((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Model_getVariableFromMap__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getVariableFromMap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getVariableFromMap" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_getVariableFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_getVariableFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariableFromMap((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Model_getIntVariableFromMap__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getIntVariableFromMap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getIntVariableFromMap" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_getIntVariableFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_getIntVariableFromMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getIntVariableFromMap((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Model_addFloatVariableToMap, _wrap_Model_addFloatVariableToMap, std::string() ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  std::vector< float,std::allocator< float > > *arg3 = (std::vector< float,std::allocator< float > > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  void *argp3 = 0 ;
  int res3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Model_addFloatVariableToMap",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_addFloatVariableToMap" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_addFloatVariableToMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_addFloatVariableToMap" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  res3 = SWIG_ConvertPtr(args(2), &argp3,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res3)) {
    SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "Model_addFloatVariableToMap" "', argument " "3"" of type '" "std::vector< float,std::allocator< float > > *""'"); 
  }
  arg3 = (std::vector< float,std::allocator< float > > *)(argp3);
  (arg1)->addFloatVariableToMap((std::string const &)*arg2,arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_Model_getVariableFromMap__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getVariableFromMap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getVariableFromMap" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Model_getVariableFromMap" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariableFromMap(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getVariableFromMap, _wrap_Model_getVariableFromMap, _wrap_Model_getVariableFromMap_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Model_getVariableFromMap__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Model_getVariableFromMap__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_Model_getIntVariableFromMap__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getIntVariableFromMap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getIntVariableFromMap" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Model_getIntVariableFromMap" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getIntVariableFromMap(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getIntVariableFromMap, _wrap_Model_getIntVariableFromMap, _wrap_Model_getIntVariableFromMap_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Model_getIntVariableFromMap__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Model_getIntVariableFromMap__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_Model_getVariableFromMapRW__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getVariableFromMapRW",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getVariableFromMapRW" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Model_getVariableFromMapRW" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getVariableFromMapRW(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getVariableFromMapRW, _wrap_Model_getVariableFromMapRW, _wrap_Model_getVariableFromMapRW_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Model_getVariableFromMapRW__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Model_getVariableFromMapRW__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_Model_getIntVariableFromMapRW__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< int,std::allocator< int > > *result = 0 ;
  
  if (!SWIG_check_num_args("Model_getIntVariableFromMapRW",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getIntVariableFromMapRW" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Model_getIntVariableFromMapRW" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< int,std::allocator< int > > *)(arg1)->getIntVariableFromMapRW(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_int_std__allocatorT_int_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getIntVariableFromMapRW, _wrap_Model_getIntVariableFromMapRW, _wrap_Model_getIntVariableFromMapRW_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_Model_getIntVariableFromMapRW__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__Model, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_Model_getIntVariableFromMapRW__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Model_getLoadedVariables, _wrap_Model_getLoadedVariables, _wrap_Model_getLoadedVariables_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("Model_getLoadedVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getLoadedVariables" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (arg1)->getLoadedVariables();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_setMissingValue, _wrap_Model_setMissingValue, _wrap_Model_setMissingValue_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  float arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Model_setMissingValue",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_setMissingValue" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Model_setMissingValue" "', argument " "2"" of type '" "float""'");
  } 
  arg2 = (float)(val2);
  (arg1)->setMissingValue(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getMissingValue, _wrap_Model_getMissingValue, _wrap_Model_getMissingValue_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Model_getMissingValue",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getMissingValue" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (float)(arg1)->getMissingValue();
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getConversionFactorToSI, _wrap_Model_getConversionFactorToSI, _wrap_Model_getConversionFactorToSI_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("Model_getConversionFactorToSI",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getConversionFactorToSI" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_getConversionFactorToSI" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_getConversionFactorToSI" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (float)(arg1)->getConversionFactorToSI((std::string const &)*arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Model_getNativeUnit, _wrap_Model_getNativeUnit, _wrap_Model_getNativeUnit_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Model_getNativeUnit",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getNativeUnit" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_getNativeUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_getNativeUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getNativeUnit((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Model_getSIUnit, _wrap_Model_getSIUnit, _wrap_Model_getSIUnit_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Model_getSIUnit",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getSIUnit" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Model_getSIUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Model_getSIUnit" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getSIUnit((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( Model_getProgress, _wrap_Model_getProgress, _wrap_Model_getProgress_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Model_getProgress",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getProgress" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (int)(arg1)->getProgress();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_getBusyStatus, _wrap_Model_getBusyStatus, _wrap_Model_getBusyStatus_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  int result;
  
  if (!SWIG_check_num_args("Model_getBusyStatus",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_getBusyStatus" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (int)(arg1)->getBusyStatus();
  _outv = SWIG_From_int((int)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_close, _wrap_Model_close, _wrap_Model_close_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("Model_close",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_close" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (long)(arg1)->close();
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Model_createNewInterpolator, _wrap_Model_createNewInterpolator, _wrap_Model_createNewInterpolator_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("Model_createNewInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Model_createNewInterpolator" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (ccmc::Interpolator *)(arg1)->createNewInterpolator();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Model, _wrap_delete_Model, _wrap_delete_Model_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Model",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Model" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Model_members[] = {
{"open",_wrap_Model_open,0,0,0,0},
{"setModelName",_wrap_Model_setModelName,0,0,0,0},
{"getModelName",_wrap_Model_getModelName,0,0,0,0},
{"loadVariable",_wrap_Model_loadVariable,0,0,0,0},
{"unloadVariable",_wrap_Model_unloadVariable,0,0,0,0},
{"loadVariableInt",_wrap_Model_loadVariableInt,0,0,0,0},
{"addFloatVariableToMap",_wrap_Model_addFloatVariableToMap,0,0,0,0},
{"getVariableFromMap",_wrap_Model_getVariableFromMap,0,0,0,0},
{"getIntVariableFromMap",_wrap_Model_getIntVariableFromMap,0,0,0,0},
{"getVariableFromMapRW",_wrap_Model_getVariableFromMapRW,0,0,0,0},
{"getIntVariableFromMapRW",_wrap_Model_getIntVariableFromMapRW,0,0,0,0},
{"getLoadedVariables",_wrap_Model_getLoadedVariables,0,0,0,0},
{"setMissingValue",_wrap_Model_setMissingValue,0,0,0,0},
{"getMissingValue",_wrap_Model_getMissingValue,0,0,0,0},
{"getConversionFactorToSI",_wrap_Model_getConversionFactorToSI,0,0,0,0},
{"getNativeUnit",_wrap_Model_getNativeUnit,0,0,0,0},
{"getSIUnit",_wrap_Model_getSIUnit,0,0,0,0},
{"getProgress",_wrap_Model_getProgress,0,0,0,0},
{"getBusyStatus",_wrap_Model_getBusyStatus,0,0,0,0},
{"close",_wrap_Model_close,0,0,0,0},
{"createNewInterpolator",_wrap_Model_createNewInterpolator,0,0,0,0},
{0,0,0,0}
};
static const char *swig_Model_base_names[] = {"_p_ccmc__GeneralFileReader",0};
static const swig_type_info *swig_Model_base[] = {0,0};
static swig_octave_class _wrap_class_Model = {"Model", &SWIGTYPE_p_ccmc__Model,0,0,0,_wrap_delete_Model,swig_Model_members,swig_Model_base_names,swig_Model_base };

SWIG_DEFUN( new_OpenGGCM, _wrap_new_OpenGGCM, _wrap_new_OpenGGCM_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::OpenGGCM *result = 0 ;
  
  if (!SWIG_check_num_args("new_OpenGGCM",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::OpenGGCM *)new ccmc::OpenGGCM();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__OpenGGCM, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_open, _wrap_OpenGGCM_open, _wrap_OpenGGCM_open_texinfo ) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("OpenGGCM_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_open" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCM_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCM_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_createNewInterpolator, _wrap_OpenGGCM_createNewInterpolator, _wrap_OpenGGCM_createNewInterpolator_texinfo ) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("OpenGGCM_createNewInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_createNewInterpolator" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  result = (ccmc::Interpolator *)(arg1)->createNewInterpolator();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCM_getXGrid__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("OpenGGCM_getXGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getXGrid" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCM_getXGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCM_getXGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getXGrid((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCM_getXGrid__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("OpenGGCM_getXGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getXGrid" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCM_getXGrid" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getXGrid(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_getXGrid, _wrap_OpenGGCM_getXGrid, _wrap_OpenGGCM_getXGrid_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OpenGGCM_getXGrid__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OpenGGCM_getXGrid__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_OpenGGCM_getYGrid__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("OpenGGCM_getYGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getYGrid" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCM_getYGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCM_getYGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getYGrid((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCM_getYGrid__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("OpenGGCM_getYGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getYGrid" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCM_getYGrid" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getYGrid(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_getYGrid, _wrap_OpenGGCM_getYGrid, _wrap_OpenGGCM_getYGrid_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OpenGGCM_getYGrid__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OpenGGCM_getYGrid__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_OpenGGCM_getZGrid__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("OpenGGCM_getZGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getZGrid" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCM_getZGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCM_getZGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getZGrid((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCM_getZGrid__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("OpenGGCM_getZGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getZGrid" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCM_getZGrid" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getZGrid(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_getZGrid, _wrap_OpenGGCM_getZGrid, _wrap_OpenGGCM_getZGrid_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OpenGGCM_getZGrid__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OpenGGCM_getZGrid__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_OpenGGCM_getXGridName__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("OpenGGCM_getXGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getXGridName" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCM_getXGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCM_getXGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getXGridName((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCM_getXGridName__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("OpenGGCM_getXGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getXGridName" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCM_getXGridName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getXGridName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_getXGridName, _wrap_OpenGGCM_getXGridName, _wrap_OpenGGCM_getXGridName_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OpenGGCM_getXGridName__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OpenGGCM_getXGridName__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_OpenGGCM_getYGridName__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("OpenGGCM_getYGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getYGridName" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCM_getYGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCM_getYGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getYGridName((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCM_getYGridName__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("OpenGGCM_getYGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getYGridName" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCM_getYGridName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getYGridName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_getYGridName, _wrap_OpenGGCM_getYGridName, _wrap_OpenGGCM_getYGridName_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OpenGGCM_getYGridName__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OpenGGCM_getYGridName__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_OpenGGCM_getZGridName__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("OpenGGCM_getZGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getZGridName" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCM_getZGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCM_getZGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getZGridName((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCM_getZGridName__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("OpenGGCM_getZGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getZGridName" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCM_getZGridName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getZGridName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCM_getZGridName, _wrap_OpenGGCM_getZGridName, _wrap_OpenGGCM_getZGridName_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OpenGGCM_getZGridName__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCM, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OpenGGCM_getZGridName__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( OpenGGCM_getLoadedVariables, _wrap_OpenGGCM_getLoadedVariables, _wrap_OpenGGCM_getLoadedVariables_texinfo ) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("OpenGGCM_getLoadedVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCM_getLoadedVariables" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  result = (arg1)->getLoadedVariables();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_OpenGGCM, _wrap_delete_OpenGGCM, _wrap_delete_OpenGGCM_texinfo ) {
  ccmc::OpenGGCM *arg1 = (ccmc::OpenGGCM *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_OpenGGCM",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCM, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_OpenGGCM" "', argument " "1"" of type '" "ccmc::OpenGGCM *""'"); 
  }
  arg1 = (ccmc::OpenGGCM *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_OpenGGCM_members[] = {
{"open",_wrap_OpenGGCM_open,0,0,0,0},
{"createNewInterpolator",_wrap_OpenGGCM_createNewInterpolator,0,0,0,0},
{"getXGrid",_wrap_OpenGGCM_getXGrid,0,0,0,0},
{"getYGrid",_wrap_OpenGGCM_getYGrid,0,0,0,0},
{"getZGrid",_wrap_OpenGGCM_getZGrid,0,0,0,0},
{"getXGridName",_wrap_OpenGGCM_getXGridName,0,0,0,0},
{"getYGridName",_wrap_OpenGGCM_getYGridName,0,0,0,0},
{"getZGridName",_wrap_OpenGGCM_getZGridName,0,0,0,0},
{"getLoadedVariables",_wrap_OpenGGCM_getLoadedVariables,0,0,0,0},
{0,0,0,0}
};
static const char *swig_OpenGGCM_base_names[] = {"_p_ccmc__Model",0};
static const swig_type_info *swig_OpenGGCM_base[] = {0,0};
static swig_octave_class _wrap_class_OpenGGCM = {"OpenGGCM", &SWIGTYPE_p_ccmc__OpenGGCM,0,_wrap_new_OpenGGCM,0,_wrap_delete_OpenGGCM,swig_OpenGGCM_members,swig_OpenGGCM_base_names,swig_OpenGGCM_base };

SWIG_DEFUN( new_BATSRUS, _wrap_new_BATSRUS, _wrap_new_BATSRUS_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::BATSRUS *result = 0 ;
  
  if (!SWIG_check_num_args("new_BATSRUS",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::BATSRUS *)new ccmc::BATSRUS();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__BATSRUS, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( BATSRUS_open, _wrap_BATSRUS_open, _wrap_BATSRUS_open_texinfo ) {
  ccmc::BATSRUS *arg1 = (ccmc::BATSRUS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("BATSRUS_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "BATSRUS_open" "', argument " "1"" of type '" "ccmc::BATSRUS *""'"); 
  }
  arg1 = (ccmc::BATSRUS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "BATSRUS_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUS_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( BATSRUS_createNewInterpolator, _wrap_BATSRUS_createNewInterpolator, _wrap_BATSRUS_createNewInterpolator_texinfo ) {
  ccmc::BATSRUS *arg1 = (ccmc::BATSRUS *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("BATSRUS_createNewInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "BATSRUS_createNewInterpolator" "', argument " "1"" of type '" "ccmc::BATSRUS *""'"); 
  }
  arg1 = (ccmc::BATSRUS *)(argp1);
  result = (ccmc::Interpolator *)(arg1)->createNewInterpolator();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( BATSRUS_getLoadedVariables, _wrap_BATSRUS_getLoadedVariables, _wrap_BATSRUS_getLoadedVariables_texinfo ) {
  ccmc::BATSRUS *arg1 = (ccmc::BATSRUS *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("BATSRUS_getLoadedVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "BATSRUS_getLoadedVariables" "', argument " "1"" of type '" "ccmc::BATSRUS *""'"); 
  }
  arg1 = (ccmc::BATSRUS *)(argp1);
  result = (arg1)->getLoadedVariables();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_BATSRUS, _wrap_delete_BATSRUS, _wrap_delete_BATSRUS_texinfo ) {
  ccmc::BATSRUS *arg1 = (ccmc::BATSRUS *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_BATSRUS",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUS, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_BATSRUS" "', argument " "1"" of type '" "ccmc::BATSRUS *""'"); 
  }
  arg1 = (ccmc::BATSRUS *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_BATSRUS_members[] = {
{"open",_wrap_BATSRUS_open,0,0,0,0},
{"createNewInterpolator",_wrap_BATSRUS_createNewInterpolator,0,0,0,0},
{"getLoadedVariables",_wrap_BATSRUS_getLoadedVariables,0,0,0,0},
{0,0,0,0}
};
static const char *swig_BATSRUS_base_names[] = {"_p_ccmc__Model",0};
static const swig_type_info *swig_BATSRUS_base[] = {0,0};
static swig_octave_class _wrap_class_BATSRUS = {"BATSRUS", &SWIGTYPE_p_ccmc__BATSRUS,0,_wrap_new_BATSRUS,0,_wrap_delete_BATSRUS,swig_BATSRUS_members,swig_BATSRUS_base_names,swig_BATSRUS_base };

SWIG_DEFUN( new_ENLIL, _wrap_new_ENLIL, _wrap_new_ENLIL_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::ENLIL *result = 0 ;
  
  if (!SWIG_check_num_args("new_ENLIL",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::ENLIL *)new ccmc::ENLIL();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__ENLIL, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( ENLIL_open, _wrap_ENLIL_open, _wrap_ENLIL_open_texinfo ) {
  ccmc::ENLIL *arg1 = (ccmc::ENLIL *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("ENLIL_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLIL, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLIL_open" "', argument " "1"" of type '" "ccmc::ENLIL *""'"); 
  }
  arg1 = (ccmc::ENLIL *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ENLIL_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLIL_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( ENLIL_createNewInterpolator, _wrap_ENLIL_createNewInterpolator, _wrap_ENLIL_createNewInterpolator_texinfo ) {
  ccmc::ENLIL *arg1 = (ccmc::ENLIL *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("ENLIL_createNewInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLIL, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLIL_createNewInterpolator" "', argument " "1"" of type '" "ccmc::ENLIL *""'"); 
  }
  arg1 = (ccmc::ENLIL *)(argp1);
  result = (ccmc::Interpolator *)(arg1)->createNewInterpolator();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( ENLIL_getChangeSignFlag, _wrap_ENLIL_getChangeSignFlag, _wrap_ENLIL_getChangeSignFlag_texinfo ) {
  ccmc::ENLIL *arg1 = (ccmc::ENLIL *) 0 ;
  std::string arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("ENLIL_getChangeSignFlag",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLIL, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLIL_getChangeSignFlag" "', argument " "1"" of type '" "ccmc::ENLIL *""'"); 
  }
  arg1 = (ccmc::ENLIL *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    int res = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res) || !ptr) {
      SWIG_exception_fail(SWIG_ArgError((ptr ? res : SWIG_TypeError)), "in method '" "ENLIL_getChangeSignFlag" "', argument " "2"" of type '" "std::string""'"); 
    }
    arg2 = *ptr;
    if (SWIG_IsNewObj(res)) delete ptr;
  }
  result = (bool)(arg1)->getChangeSignFlag(arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( ENLIL_getChangeSignFlagByID, _wrap_ENLIL_getChangeSignFlagByID, _wrap_ENLIL_getChangeSignFlagByID_texinfo ) {
  ccmc::ENLIL *arg1 = (ccmc::ENLIL *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("ENLIL_getChangeSignFlagByID",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLIL, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLIL_getChangeSignFlagByID" "', argument " "1"" of type '" "ccmc::ENLIL *""'"); 
  }
  arg1 = (ccmc::ENLIL *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ENLIL_getChangeSignFlagByID" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (bool)(arg1)->getChangeSignFlagByID(arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( ENLIL_getLoadedVariables, _wrap_ENLIL_getLoadedVariables, _wrap_ENLIL_getLoadedVariables_texinfo ) {
  ccmc::ENLIL *arg1 = (ccmc::ENLIL *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("ENLIL_getLoadedVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLIL, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLIL_getLoadedVariables" "', argument " "1"" of type '" "ccmc::ENLIL *""'"); 
  }
  arg1 = (ccmc::ENLIL *)(argp1);
  result = (arg1)->getLoadedVariables();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_ENLIL, _wrap_delete_ENLIL, _wrap_delete_ENLIL_texinfo ) {
  ccmc::ENLIL *arg1 = (ccmc::ENLIL *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_ENLIL",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLIL, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_ENLIL" "', argument " "1"" of type '" "ccmc::ENLIL *""'"); 
  }
  arg1 = (ccmc::ENLIL *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_ENLIL_members[] = {
{"open",_wrap_ENLIL_open,0,0,0,0},
{"createNewInterpolator",_wrap_ENLIL_createNewInterpolator,0,0,0,0},
{"getChangeSignFlag",_wrap_ENLIL_getChangeSignFlag,0,0,0,0},
{"getChangeSignFlagByID",_wrap_ENLIL_getChangeSignFlagByID,0,0,0,0},
{"getLoadedVariables",_wrap_ENLIL_getLoadedVariables,0,0,0,0},
{0,0,0,0}
};
static const char *swig_ENLIL_base_names[] = {"_p_ccmc__Model",0};
static const swig_type_info *swig_ENLIL_base[] = {0,0};
static swig_octave_class _wrap_class_ENLIL = {"ENLIL", &SWIGTYPE_p_ccmc__ENLIL,0,_wrap_new_ENLIL,0,_wrap_delete_ENLIL,swig_ENLIL_members,swig_ENLIL_base_names,swig_ENLIL_base };

SWIG_DEFUN( new_MAS, _wrap_new_MAS, _wrap_new_MAS_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::MAS *result = 0 ;
  
  if (!SWIG_check_num_args("new_MAS",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::MAS *)new ccmc::MAS();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__MAS, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_open, _wrap_MAS_open, _wrap_MAS_open_texinfo ) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("MAS_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_open" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MAS_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MAS_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( MAS_createNewInterpolator, _wrap_MAS_createNewInterpolator, _wrap_MAS_createNewInterpolator_texinfo ) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("MAS_createNewInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_createNewInterpolator" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  result = (ccmc::Interpolator *)(arg1)->createNewInterpolator();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getRPosGrid__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("MAS_getRPosGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getRPosGrid" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MAS_getRPosGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MAS_getRPosGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getRPosGrid((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getRPosGrid__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("MAS_getRPosGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getRPosGrid" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MAS_getRPosGrid" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getRPosGrid(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_getRPosGrid, _wrap_MAS_getRPosGrid, _wrap_MAS_getRPosGrid_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_MAS_getRPosGrid__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_MAS_getRPosGrid__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_MAS_getRPosGridName__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("MAS_getRPosGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getRPosGridName" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MAS_getRPosGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MAS_getRPosGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getRPosGridName((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getRPosGridName__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("MAS_getRPosGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getRPosGridName" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MAS_getRPosGridName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getRPosGridName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_getRPosGridName, _wrap_MAS_getRPosGridName, _wrap_MAS_getRPosGridName_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_MAS_getRPosGridName__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_MAS_getRPosGridName__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_MAS_getLatPosGrid__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("MAS_getLatPosGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLatPosGrid" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MAS_getLatPosGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MAS_getLatPosGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getLatPosGrid((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getLatPosGrid__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("MAS_getLatPosGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLatPosGrid" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MAS_getLatPosGrid" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getLatPosGrid(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_getLatPosGrid, _wrap_MAS_getLatPosGrid, _wrap_MAS_getLatPosGrid_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_MAS_getLatPosGrid__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_MAS_getLatPosGrid__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_MAS_getLatPosGridName__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("MAS_getLatPosGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLatPosGridName" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MAS_getLatPosGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MAS_getLatPosGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getLatPosGridName((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getLatPosGridName__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("MAS_getLatPosGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLatPosGridName" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MAS_getLatPosGridName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getLatPosGridName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_getLatPosGridName, _wrap_MAS_getLatPosGridName, _wrap_MAS_getLatPosGridName_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_MAS_getLatPosGridName__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_MAS_getLatPosGridName__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( MAS_getLonPosGrid, _wrap_MAS_getLonPosGrid, _wrap_MAS_getLonPosGrid_texinfo ) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("MAS_getLonPosGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLonPosGrid" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MAS_getLonPosGrid" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getLonPosGrid(arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_getlonPosGrid, _wrap_MAS_getlonPosGrid, _wrap_MAS_getlonPosGrid_texinfo ) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::vector< float,std::allocator< float > > *result = 0 ;
  
  if (!SWIG_check_num_args("MAS_getlonPosGrid",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getlonPosGrid" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MAS_getlonPosGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MAS_getlonPosGrid" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (std::vector< float,std::allocator< float > > *)(arg1)->getlonPosGrid((std::string const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getLonPosGridName__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("MAS_getLonPosGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLonPosGridName" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MAS_getLonPosGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MAS_getLonPosGridName" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (arg1)->getLonPosGridName((std::string const &)*arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getLonPosGridName__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("MAS_getLonPosGridName",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLonPosGridName" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MAS_getLonPosGridName" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (arg1)->getLonPosGridName(arg2);
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_getLonPosGridName, _wrap_MAS_getLonPosGridName, _wrap_MAS_getLonPosGridName_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_MAS_getLonPosGridName__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_MAS_getLonPosGridName__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_MAS_getChangeSignFlag__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  std::string arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("MAS_getChangeSignFlag",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getChangeSignFlag" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    int res = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res) || !ptr) {
      SWIG_exception_fail(SWIG_ArgError((ptr ? res : SWIG_TypeError)), "in method '" "MAS_getChangeSignFlag" "', argument " "2"" of type '" "std::string""'"); 
    }
    arg2 = *ptr;
    if (SWIG_IsNewObj(res)) delete ptr;
  }
  result = (bool)(arg1)->getChangeSignFlag(arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_MAS_getChangeSignFlag__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  long arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("MAS_getChangeSignFlag",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getChangeSignFlag" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MAS_getChangeSignFlag" "', argument " "2"" of type '" "long""'");
  } 
  arg2 = (long)(val2);
  result = (bool)(arg1)->getChangeSignFlag(arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MAS_getChangeSignFlag, _wrap_MAS_getChangeSignFlag, _wrap_MAS_getChangeSignFlag_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_MAS_getChangeSignFlag__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MAS, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_MAS_getChangeSignFlag__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( MAS_getLoadedVariables, _wrap_MAS_getLoadedVariables, _wrap_MAS_getLoadedVariables_texinfo ) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("MAS_getLoadedVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MAS_getLoadedVariables" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  result = (arg1)->getLoadedVariables();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_MAS, _wrap_delete_MAS, _wrap_delete_MAS_texinfo ) {
  ccmc::MAS *arg1 = (ccmc::MAS *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_MAS",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MAS, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_MAS" "', argument " "1"" of type '" "ccmc::MAS *""'"); 
  }
  arg1 = (ccmc::MAS *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_MAS_members[] = {
{"open",_wrap_MAS_open,0,0,0,0},
{"createNewInterpolator",_wrap_MAS_createNewInterpolator,0,0,0,0},
{"getRPosGrid",_wrap_MAS_getRPosGrid,0,0,0,0},
{"getRPosGridName",_wrap_MAS_getRPosGridName,0,0,0,0},
{"getLatPosGrid",_wrap_MAS_getLatPosGrid,0,0,0,0},
{"getLatPosGridName",_wrap_MAS_getLatPosGridName,0,0,0,0},
{"getLonPosGrid",_wrap_MAS_getLonPosGrid,0,0,0,0},
{"getlonPosGrid",_wrap_MAS_getlonPosGrid,0,0,0,0},
{"getLonPosGridName",_wrap_MAS_getLonPosGridName,0,0,0,0},
{"getChangeSignFlag",_wrap_MAS_getChangeSignFlag,0,0,0,0},
{"getLoadedVariables",_wrap_MAS_getLoadedVariables,0,0,0,0},
{0,0,0,0}
};
static const char *swig_MAS_base_names[] = {"_p_ccmc__Model",0};
static const swig_type_info *swig_MAS_base[] = {0,0};
static swig_octave_class _wrap_class_MAS = {"MAS", &SWIGTYPE_p_ccmc__MAS,0,_wrap_new_MAS,0,_wrap_delete_MAS,swig_MAS_members,swig_MAS_base_names,swig_MAS_base };

SWIG_DEFUN( new_SWMFIono, _wrap_new_SWMFIono, _wrap_new_SWMFIono_texinfo ) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::SWMFIono *result = 0 ;
  
  if (!SWIG_check_num_args("new_SWMFIono",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::SWMFIono *)new ccmc::SWMFIono();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__SWMFIono, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( SWMFIono_open, _wrap_SWMFIono_open, _wrap_SWMFIono_open_texinfo ) {
  ccmc::SWMFIono *arg1 = (ccmc::SWMFIono *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  long result;
  
  if (!SWIG_check_num_args("SWMFIono_open",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIono, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SWMFIono_open" "', argument " "1"" of type '" "ccmc::SWMFIono *""'"); 
  }
  arg1 = (ccmc::SWMFIono *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SWMFIono_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIono_open" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (long)(arg1)->open((std::string const &)*arg2);
  _outv = SWIG_From_long((long)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( SWMFIono_createNewInterpolator, _wrap_SWMFIono_createNewInterpolator, _wrap_SWMFIono_createNewInterpolator_texinfo ) {
  ccmc::SWMFIono *arg1 = (ccmc::SWMFIono *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Interpolator *result = 0 ;
  
  if (!SWIG_check_num_args("SWMFIono_createNewInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIono, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SWMFIono_createNewInterpolator" "', argument " "1"" of type '" "ccmc::SWMFIono *""'"); 
  }
  arg1 = (ccmc::SWMFIono *)(argp1);
  result = (ccmc::Interpolator *)(arg1)->createNewInterpolator();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Interpolator, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( SWMFIono_getLoadedVariables, _wrap_SWMFIono_getLoadedVariables, _wrap_SWMFIono_getLoadedVariables_texinfo ) {
  ccmc::SWMFIono *arg1 = (ccmc::SWMFIono *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::vector< std::string,std::allocator< std::string > > > result;
  
  if (!SWIG_check_num_args("SWMFIono_getLoadedVariables",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIono, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SWMFIono_getLoadedVariables" "', argument " "1"" of type '" "ccmc::SWMFIono *""'"); 
  }
  arg1 = (ccmc::SWMFIono *)(argp1);
  result = (arg1)->getLoadedVariables();
  _outv = SWIG_NewPointerObj((new std::vector< std::string,std::allocator< std::string > >((const std::vector< std::string,std::allocator< std::string > >&)(result))), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_SWMFIono, _wrap_delete_SWMFIono, _wrap_delete_SWMFIono_texinfo ) {
  ccmc::SWMFIono *arg1 = (ccmc::SWMFIono *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_SWMFIono",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIono, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SWMFIono" "', argument " "1"" of type '" "ccmc::SWMFIono *""'"); 
  }
  arg1 = (ccmc::SWMFIono *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_SWMFIono_members[] = {
{"open",_wrap_SWMFIono_open,0,0,0,0},
{"createNewInterpolator",_wrap_SWMFIono_createNewInterpolator,0,0,0,0},
{"getLoadedVariables",_wrap_SWMFIono_getLoadedVariables,0,0,0,0},
{0,0,0,0}
};
static const char *swig_SWMFIono_base_names[] = {"_p_ccmc__Model",0};
static const swig_type_info *swig_SWMFIono_base[] = {0,0};
static swig_octave_class _wrap_class_SWMFIono = {"SWMFIono", &SWIGTYPE_p_ccmc__SWMFIono,0,_wrap_new_SWMFIono,0,_wrap_delete_SWMFIono,swig_SWMFIono_members,swig_SWMFIono_base_names,swig_SWMFIono_base };

SWIG_DEFUN( new_BATSRUSInterpolator, _wrap_new_BATSRUSInterpolator, _wrap_new_BATSRUSInterpolator_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::BATSRUSInterpolator *result = 0 ;
  
  if (!SWIG_check_num_args("new_BATSRUSInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_BATSRUSInterpolator" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (ccmc::BATSRUSInterpolator *)new ccmc::BATSRUSInterpolator(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__BATSRUSInterpolator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_BATSRUSInterpolator_interpolate__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::BATSRUSInterpolator *arg1 = (ccmc::BATSRUSInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("BATSRUSInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::BATSRUSInterpolator *""'"); 
  }
  arg1 = (ccmc::BATSRUSInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_BATSRUSInterpolator_interpolate__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::BATSRUSInterpolator *arg1 = (ccmc::BATSRUSInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("BATSRUSInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::BATSRUSInterpolator *""'"); 
  }
  arg1 = (ccmc::BATSRUSInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_BATSRUSInterpolator_interpolate__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::BATSRUSInterpolator *arg1 = (ccmc::BATSRUSInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("BATSRUSInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::BATSRUSInterpolator *""'"); 
  }
  arg1 = (ccmc::BATSRUSInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_BATSRUSInterpolator_interpolate__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::BATSRUSInterpolator *arg1 = (ccmc::BATSRUSInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("BATSRUSInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::BATSRUSInterpolator *""'"); 
  }
  arg1 = (ccmc::BATSRUSInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "BATSRUSInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "BATSRUSInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( BATSRUSInterpolator_interpolate, _wrap_BATSRUSInterpolator_interpolate, _wrap_BATSRUSInterpolator_interpolate_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[8]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5),octave_value_ref(args,6),octave_value_ref(args,7)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_BATSRUSInterpolator_interpolate__SWIG_2(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_BATSRUSInterpolator_interpolate__SWIG_0(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_BATSRUSInterpolator_interpolate__SWIG_3(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__BATSRUSInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_BATSRUSInterpolator_interpolate__SWIG_1(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( delete_BATSRUSInterpolator, _wrap_delete_BATSRUSInterpolator, _wrap_delete_BATSRUSInterpolator_texinfo ) {
  ccmc::BATSRUSInterpolator *arg1 = (ccmc::BATSRUSInterpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_BATSRUSInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__BATSRUSInterpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_BATSRUSInterpolator" "', argument " "1"" of type '" "ccmc::BATSRUSInterpolator *""'"); 
  }
  arg1 = (ccmc::BATSRUSInterpolator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_BATSRUSInterpolator_members[] = {
{"interpolate",_wrap_BATSRUSInterpolator_interpolate,0,0,0,0},
{0,0,0,0}
};
static const char *swig_BATSRUSInterpolator_base_names[] = {"_p_ccmc__Interpolator",0};
static const swig_type_info *swig_BATSRUSInterpolator_base[] = {0,0};
static swig_octave_class _wrap_class_BATSRUSInterpolator = {"BATSRUSInterpolator", &SWIGTYPE_p_ccmc__BATSRUSInterpolator,0,_wrap_new_BATSRUSInterpolator,0,_wrap_delete_BATSRUSInterpolator,swig_BATSRUSInterpolator_members,swig_BATSRUSInterpolator_base_names,swig_BATSRUSInterpolator_base };

SWIG_DEFUN( new_ENLILInterpolator, _wrap_new_ENLILInterpolator, _wrap_new_ENLILInterpolator_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::ENLILInterpolator *result = 0 ;
  
  if (!SWIG_check_num_args("new_ENLILInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_ENLILInterpolator" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (ccmc::ENLILInterpolator *)new ccmc::ENLILInterpolator(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__ENLILInterpolator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_ENLILInterpolator_interpolate__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::ENLILInterpolator *arg1 = (ccmc::ENLILInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("ENLILInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLILInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLILInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::ENLILInterpolator *""'"); 
  }
  arg1 = (ccmc::ENLILInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ENLILInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ENLILInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "ENLILInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "ENLILInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_ENLILInterpolator_interpolate__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::ENLILInterpolator *arg1 = (ccmc::ENLILInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("ENLILInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLILInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLILInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::ENLILInterpolator *""'"); 
  }
  arg1 = (ccmc::ENLILInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "ENLILInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ENLILInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "ENLILInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "ENLILInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "ENLILInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "ENLILInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "ENLILInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_ENLILInterpolator_interpolate__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::ENLILInterpolator *arg1 = (ccmc::ENLILInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("ENLILInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLILInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLILInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::ENLILInterpolator *""'"); 
  }
  arg1 = (ccmc::ENLILInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ENLILInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ENLILInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "ENLILInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "ENLILInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_ENLILInterpolator_interpolate__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::ENLILInterpolator *arg1 = (ccmc::ENLILInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("ENLILInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLILInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "ENLILInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::ENLILInterpolator *""'"); 
  }
  arg1 = (ccmc::ENLILInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "ENLILInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "ENLILInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "ENLILInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "ENLILInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "ENLILInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "ENLILInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "ENLILInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "ENLILInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( ENLILInterpolator_interpolate, _wrap_ENLILInterpolator_interpolate, _wrap_ENLILInterpolator_interpolate_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[8]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5),octave_value_ref(args,6),octave_value_ref(args,7)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__ENLILInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_ENLILInterpolator_interpolate__SWIG_2(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__ENLILInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_ENLILInterpolator_interpolate__SWIG_0(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__ENLILInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_ENLILInterpolator_interpolate__SWIG_3(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__ENLILInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_ENLILInterpolator_interpolate__SWIG_1(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( delete_ENLILInterpolator, _wrap_delete_ENLILInterpolator, _wrap_delete_ENLILInterpolator_texinfo ) {
  ccmc::ENLILInterpolator *arg1 = (ccmc::ENLILInterpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_ENLILInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__ENLILInterpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_ENLILInterpolator" "', argument " "1"" of type '" "ccmc::ENLILInterpolator *""'"); 
  }
  arg1 = (ccmc::ENLILInterpolator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_ENLILInterpolator_members[] = {
{"interpolate",_wrap_ENLILInterpolator_interpolate,0,0,0,0},
{0,0,0,0}
};
static const char *swig_ENLILInterpolator_base_names[] = {"_p_ccmc__Interpolator",0};
static const swig_type_info *swig_ENLILInterpolator_base[] = {0,0};
static swig_octave_class _wrap_class_ENLILInterpolator = {"ENLILInterpolator", &SWIGTYPE_p_ccmc__ENLILInterpolator,0,_wrap_new_ENLILInterpolator,0,_wrap_delete_ENLILInterpolator,swig_ENLILInterpolator_members,swig_ENLILInterpolator_base_names,swig_ENLILInterpolator_base };

SWIG_DEFUN( new_MASInterpolator, _wrap_new_MASInterpolator, _wrap_new_MASInterpolator_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::MASInterpolator *result = 0 ;
  
  if (!SWIG_check_num_args("new_MASInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_MASInterpolator" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (ccmc::MASInterpolator *)new ccmc::MASInterpolator(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__MASInterpolator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_MASInterpolator_interpolate__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::MASInterpolator *arg1 = (ccmc::MASInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("MASInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MASInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MASInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::MASInterpolator *""'"); 
  }
  arg1 = (ccmc::MASInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MASInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "MASInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "MASInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "MASInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MASInterpolator_interpolate__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::MASInterpolator *arg1 = (ccmc::MASInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("MASInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MASInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MASInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::MASInterpolator *""'"); 
  }
  arg1 = (ccmc::MASInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "MASInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "MASInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "MASInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "MASInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "MASInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "MASInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "MASInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_MASInterpolator_interpolate__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::MASInterpolator *arg1 = (ccmc::MASInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("MASInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MASInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MASInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::MASInterpolator *""'"); 
  }
  arg1 = (ccmc::MASInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MASInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "MASInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "MASInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "MASInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_MASInterpolator_interpolate__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::MASInterpolator *arg1 = (ccmc::MASInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("MASInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MASInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MASInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::MASInterpolator *""'"); 
  }
  arg1 = (ccmc::MASInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MASInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "MASInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "MASInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "MASInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "MASInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "MASInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "MASInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "MASInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( MASInterpolator_interpolate, _wrap_MASInterpolator_interpolate, _wrap_MASInterpolator_interpolate_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[8]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5),octave_value_ref(args,6),octave_value_ref(args,7)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MASInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_MASInterpolator_interpolate__SWIG_2(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MASInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_MASInterpolator_interpolate__SWIG_0(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MASInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_MASInterpolator_interpolate__SWIG_3(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__MASInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_MASInterpolator_interpolate__SWIG_1(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( delete_MASInterpolator, _wrap_delete_MASInterpolator, _wrap_delete_MASInterpolator_texinfo ) {
  ccmc::MASInterpolator *arg1 = (ccmc::MASInterpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_MASInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__MASInterpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_MASInterpolator" "', argument " "1"" of type '" "ccmc::MASInterpolator *""'"); 
  }
  arg1 = (ccmc::MASInterpolator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_MASInterpolator_members[] = {
{"interpolate",_wrap_MASInterpolator_interpolate,0,0,0,0},
{0,0,0,0}
};
static const char *swig_MASInterpolator_base_names[] = {"_p_ccmc__Interpolator",0};
static const swig_type_info *swig_MASInterpolator_base[] = {0,0};
static swig_octave_class _wrap_class_MASInterpolator = {"MASInterpolator", &SWIGTYPE_p_ccmc__MASInterpolator,0,_wrap_new_MASInterpolator,0,_wrap_delete_MASInterpolator,swig_MASInterpolator_members,swig_MASInterpolator_base_names,swig_MASInterpolator_base };

SWIG_DEFUN( new_OpenGGCMInterpolator, _wrap_new_OpenGGCMInterpolator, _wrap_new_OpenGGCMInterpolator_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::OpenGGCMInterpolator *result = 0 ;
  
  if (!SWIG_check_num_args("new_OpenGGCMInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_OpenGGCMInterpolator" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (ccmc::OpenGGCMInterpolator *)new ccmc::OpenGGCMInterpolator(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCMInterpolator_interpolate__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCMInterpolator *arg1 = (ccmc::OpenGGCMInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("OpenGGCMInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::OpenGGCMInterpolator *""'"); 
  }
  arg1 = (ccmc::OpenGGCMInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCMInterpolator_interpolate__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCMInterpolator *arg1 = (ccmc::OpenGGCMInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("OpenGGCMInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::OpenGGCMInterpolator *""'"); 
  }
  arg1 = (ccmc::OpenGGCMInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCMInterpolator_interpolate__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCMInterpolator *arg1 = (ccmc::OpenGGCMInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("OpenGGCMInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::OpenGGCMInterpolator *""'"); 
  }
  arg1 = (ccmc::OpenGGCMInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCMInterpolator_interpolate__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCMInterpolator *arg1 = (ccmc::OpenGGCMInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("OpenGGCMInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::OpenGGCMInterpolator *""'"); 
  }
  arg1 = (ccmc::OpenGGCMInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCMInterpolator_interpolate, _wrap_OpenGGCMInterpolator_interpolate, _wrap_OpenGGCMInterpolator_interpolate_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[8]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5),octave_value_ref(args,6),octave_value_ref(args,7)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_OpenGGCMInterpolator_interpolate__SWIG_2(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_OpenGGCMInterpolator_interpolate__SWIG_0(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_OpenGGCMInterpolator_interpolate__SWIG_3(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_OpenGGCMInterpolator_interpolate__SWIG_1(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_OpenGGCMInterpolator_getConversionFactor__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCMInterpolator *arg1 = (ccmc::OpenGGCMInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("OpenGGCMInterpolator_getConversionFactor",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCMInterpolator_getConversionFactor" "', argument " "1"" of type '" "ccmc::OpenGGCMInterpolator *""'"); 
  }
  arg1 = (ccmc::OpenGGCMInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "OpenGGCMInterpolator_getConversionFactor" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "OpenGGCMInterpolator_getConversionFactor" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  result = (float)(arg1)->getConversionFactor((std::string const &)*arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_OpenGGCMInterpolator_getConversionFactor__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::OpenGGCMInterpolator *arg1 = (ccmc::OpenGGCMInterpolator *) 0 ;
  long *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("OpenGGCMInterpolator_getConversionFactor",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "OpenGGCMInterpolator_getConversionFactor" "', argument " "1"" of type '" "ccmc::OpenGGCMInterpolator *""'"); 
  }
  arg1 = (ccmc::OpenGGCMInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "OpenGGCMInterpolator_getConversionFactor" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  result = (float)(arg1)->getConversionFactor((long const &)*arg2);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( OpenGGCMInterpolator_getConversionFactor, _wrap_OpenGGCMInterpolator_getConversionFactor, _wrap_OpenGGCMInterpolator_getConversionFactor_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_OpenGGCMInterpolator_getConversionFactor__SWIG_1(args, nargout);
      }
    }
  }
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__OpenGGCMInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_OpenGGCMInterpolator_getConversionFactor__SWIG_0(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( delete_OpenGGCMInterpolator, _wrap_delete_OpenGGCMInterpolator, _wrap_delete_OpenGGCMInterpolator_texinfo ) {
  ccmc::OpenGGCMInterpolator *arg1 = (ccmc::OpenGGCMInterpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_OpenGGCMInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__OpenGGCMInterpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_OpenGGCMInterpolator" "', argument " "1"" of type '" "ccmc::OpenGGCMInterpolator *""'"); 
  }
  arg1 = (ccmc::OpenGGCMInterpolator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_OpenGGCMInterpolator_members[] = {
{"interpolate",_wrap_OpenGGCMInterpolator_interpolate,0,0,0,0},
{"getConversionFactor",_wrap_OpenGGCMInterpolator_getConversionFactor,0,0,0,0},
{0,0,0,0}
};
static const char *swig_OpenGGCMInterpolator_base_names[] = {"_p_ccmc__Interpolator",0};
static const swig_type_info *swig_OpenGGCMInterpolator_base[] = {0,0};
static swig_octave_class _wrap_class_OpenGGCMInterpolator = {"OpenGGCMInterpolator", &SWIGTYPE_p_ccmc__OpenGGCMInterpolator,0,_wrap_new_OpenGGCMInterpolator,0,_wrap_delete_OpenGGCMInterpolator,swig_OpenGGCMInterpolator_members,swig_OpenGGCMInterpolator_base_names,swig_OpenGGCMInterpolator_base };

SWIG_DEFUN( new_SWMFIonoInterpolator, _wrap_new_SWMFIonoInterpolator, _wrap_new_SWMFIonoInterpolator_texinfo ) {
  ccmc::Model *arg1 = (ccmc::Model *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::SWMFIonoInterpolator *result = 0 ;
  
  if (!SWIG_check_num_args("new_SWMFIonoInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Model, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_SWMFIonoInterpolator" "', argument " "1"" of type '" "ccmc::Model *""'"); 
  }
  arg1 = (ccmc::Model *)(argp1);
  result = (ccmc::SWMFIonoInterpolator *)new ccmc::SWMFIonoInterpolator(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_SWMFIonoInterpolator_interpolate__SWIG_0 (const octave_value_list& args, int nargout) {
  ccmc::SWMFIonoInterpolator *arg1 = (ccmc::SWMFIonoInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("SWMFIonoInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::SWMFIonoInterpolator *""'"); 
  }
  arg1 = (ccmc::SWMFIonoInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_SWMFIonoInterpolator_interpolate__SWIG_1 (const octave_value_list& args, int nargout) {
  ccmc::SWMFIonoInterpolator *arg1 = (ccmc::SWMFIonoInterpolator *) 0 ;
  std::string *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("SWMFIonoInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::SWMFIonoInterpolator *""'"); 
  }
  arg1 = (ccmc::SWMFIonoInterpolator *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "2"" of type '" "std::string const &""'"); 
    }
    arg2 = ptr;
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((std::string const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


static octave_value_list _wrap_SWMFIonoInterpolator_interpolate__SWIG_2 (const octave_value_list& args, int nargout) {
  ccmc::SWMFIonoInterpolator *arg1 = (ccmc::SWMFIonoInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("SWMFIonoInterpolator_interpolate",args.length(),5,5,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::SWMFIonoInterpolator *""'"); 
  }
  arg1 = (ccmc::SWMFIonoInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_SWMFIonoInterpolator_interpolate__SWIG_3 (const octave_value_list& args, int nargout) {
  ccmc::SWMFIonoInterpolator *arg1 = (ccmc::SWMFIonoInterpolator *) 0 ;
  long *arg2 = 0 ;
  float *arg3 = 0 ;
  float *arg4 = 0 ;
  float *arg5 = 0 ;
  float *arg6 = 0 ;
  float *arg7 = 0 ;
  float *arg8 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  long temp2 ;
  long val2 ;
  int ecode2 = 0 ;
  float temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  float temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  float temp5 ;
  float val5 ;
  int ecode5 = 0 ;
  void *argp6 = 0 ;
  int res6 = 0 ;
  void *argp7 = 0 ;
  int res7 = 0 ;
  void *argp8 = 0 ;
  int res8 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  float result;
  
  if (!SWIG_check_num_args("SWMFIonoInterpolator_interpolate",args.length(),8,8,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "1"" of type '" "ccmc::SWMFIonoInterpolator *""'"); 
  }
  arg1 = (ccmc::SWMFIonoInterpolator *)(argp1);
  ecode2 = SWIG_AsVal_long(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "2"" of type '" "long""'");
  } 
  temp2 = (long)(val2);
  arg2 = &temp2;
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "3"" of type '" "float""'");
  } 
  temp3 = (float)(val3);
  arg3 = &temp3;
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "4"" of type '" "float""'");
  } 
  temp4 = (float)(val4);
  arg4 = &temp4;
  ecode5 = SWIG_AsVal_float(args(4), &val5);
  if (!SWIG_IsOK(ecode5)) {
    SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "5"" of type '" "float""'");
  } 
  temp5 = (float)(val5);
  arg5 = &temp5;
  res6 = SWIG_ConvertPtr(args(5), &argp6, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res6)) {
    SWIG_exception_fail(SWIG_ArgError(res6), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  if (!argp6) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "6"" of type '" "float &""'"); 
  }
  arg6 = (float *)(argp6);
  res7 = SWIG_ConvertPtr(args(6), &argp7, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res7)) {
    SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  if (!argp7) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "7"" of type '" "float &""'"); 
  }
  arg7 = (float *)(argp7);
  res8 = SWIG_ConvertPtr(args(7), &argp8, SWIGTYPE_p_float,  0 );
  if (!SWIG_IsOK(res8)) {
    SWIG_exception_fail(SWIG_ArgError(res8), "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  if (!argp8) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SWMFIonoInterpolator_interpolate" "', argument " "8"" of type '" "float &""'"); 
  }
  arg8 = (float *)(argp8);
  result = (float)(arg1)->interpolate((long const &)*arg2,(float const &)*arg3,(float const &)*arg4,(float const &)*arg5,*arg6,*arg7,*arg8);
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( SWMFIonoInterpolator_interpolate, _wrap_SWMFIonoInterpolator_interpolate, _wrap_SWMFIonoInterpolator_interpolate_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[8]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3),octave_value_ref(args,4),octave_value_ref(args,5),octave_value_ref(args,6),octave_value_ref(args,7)
  };
  
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_SWMFIonoInterpolator_interpolate__SWIG_2(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              return _wrap_SWMFIonoInterpolator_interpolate__SWIG_0(args, nargout);
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_long(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_SWMFIonoInterpolator_interpolate__SWIG_3(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  if (argc == 8) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_ccmc__SWMFIonoInterpolator, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            {
              int res = SWIG_AsVal_float(argv[4], NULL);
              _v = SWIG_CheckState(res);
            }
            if (_v) {
              void *vptr = 0;
              int res = SWIG_ConvertPtr(argv[5], &vptr, SWIGTYPE_p_float, 0);
              _v = SWIG_CheckState(res);
              if (_v) {
                void *vptr = 0;
                int res = SWIG_ConvertPtr(argv[6], &vptr, SWIGTYPE_p_float, 0);
                _v = SWIG_CheckState(res);
                if (_v) {
                  void *vptr = 0;
                  int res = SWIG_ConvertPtr(argv[7], &vptr, SWIGTYPE_p_float, 0);
                  _v = SWIG_CheckState(res);
                  if (_v) {
                    return _wrap_SWMFIonoInterpolator_interpolate__SWIG_1(args, nargout);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( delete_SWMFIonoInterpolator, _wrap_delete_SWMFIonoInterpolator, _wrap_delete_SWMFIonoInterpolator_texinfo ) {
  ccmc::SWMFIonoInterpolator *arg1 = (ccmc::SWMFIonoInterpolator *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_SWMFIonoInterpolator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__SWMFIonoInterpolator, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SWMFIonoInterpolator" "', argument " "1"" of type '" "ccmc::SWMFIonoInterpolator *""'"); 
  }
  arg1 = (ccmc::SWMFIonoInterpolator *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_SWMFIonoInterpolator_members[] = {
{"interpolate",_wrap_SWMFIonoInterpolator_interpolate,0,0,0,0},
{0,0,0,0}
};
static const char *swig_SWMFIonoInterpolator_base_names[] = {"_p_ccmc__Interpolator",0};
static const swig_type_info *swig_SWMFIonoInterpolator_base[] = {0,0};
static swig_octave_class _wrap_class_SWMFIonoInterpolator = {"SWMFIonoInterpolator", &SWIGTYPE_p_ccmc__SWMFIonoInterpolator,0,_wrap_new_SWMFIonoInterpolator,0,_wrap_delete_SWMFIonoInterpolator,swig_SWMFIonoInterpolator_members,swig_SWMFIonoInterpolator_base_names,swig_SWMFIonoInterpolator_base };

static octave_value_list _wrap_new_Time__SWIG_0 (const octave_value_list& args, int nargout) {
  std::string *arg1 = 0 ;
  int res1 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Time *result = 0 ;
  
  if (!SWIG_check_num_args("new_Time",args.length(),1,1,0)) {
    SWIG_fail;
  }
  {
    std::string *ptr = (std::string *)0;
    res1 = SWIG_AsPtr_std_string(args(0), &ptr);
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_Time" "', argument " "1"" of type '" "std::string const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_Time" "', argument " "1"" of type '" "std::string const &""'"); 
    }
    arg1 = ptr;
  }
  result = (ccmc::Time *)new ccmc::Time((std::string const &)*arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Time, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res1)) delete arg1;
fail:
  return _out;
}


static octave_value_list _wrap_new_Time__SWIG_1 (const octave_value_list& args, int nargout) {
  double arg1 ;
  double val1 ;
  int ecode1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Time *result = 0 ;
  
  if (!SWIG_check_num_args("new_Time",args.length(),1,1,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_double(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_Time" "', argument " "1"" of type '" "double""'");
  } 
  arg1 = (double)(val1);
  result = (ccmc::Time *)new ccmc::Time(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Time, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_Time__SWIG_2 (const octave_value_list& args, int nargout) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  ccmc::Time *result = 0 ;
  
  if (!SWIG_check_num_args("new_Time",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (ccmc::Time *)new ccmc::Time();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Time, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( new_Time, _wrap_new_Time, _wrap_new_Time_texinfo ) {
  int argc = args.length();
  octave_value_ref argv[1]={
    octave_value_ref(args,0)
  };
  
  if (argc == 0) {
    return _wrap_new_Time__SWIG_2(args, nargout);
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_double(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_Time__SWIG_1(args, nargout);
    }
  }
  if (argc == 1) {
    int _v;
    int res = SWIG_AsPtr_std_string(argv[0], (std::string**)(0));
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_new_Time__SWIG_0(args, nargout);
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( Time_getDay, _wrap_Time_getDay, _wrap_Time_getDay_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  short result;
  
  if (!SWIG_check_num_args("Time_getDay",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getDay" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (short)((ccmc::Time const *)arg1)->getDay();
  _outv = SWIG_From_short((short)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setDay, _wrap_Time_setDay, _wrap_Time_setDay_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  short val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setDay",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setDay" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_short(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setDay" "', argument " "2"" of type '" "short""'");
  } 
  arg2 = (short)(val2);
  (arg1)->setDay(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setEpoch, _wrap_Time_setEpoch, _wrap_Time_setEpoch_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  double arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  double val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setEpoch",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setEpoch" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_double(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setEpoch" "', argument " "2"" of type '" "double""'");
  } 
  arg2 = (double)(val2);
  (arg1)->setEpoch(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_getHour, _wrap_Time_getHour, _wrap_Time_getHour_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  short result;
  
  if (!SWIG_check_num_args("Time_getHour",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getHour" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (short)((ccmc::Time const *)arg1)->getHour();
  _outv = SWIG_From_short((short)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setHour, _wrap_Time_setHour, _wrap_Time_setHour_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  short val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setHour",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setHour" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_short(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setHour" "', argument " "2"" of type '" "short""'");
  } 
  arg2 = (short)(val2);
  (arg1)->setHour(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_getMilliseconds, _wrap_Time_getMilliseconds, _wrap_Time_getMilliseconds_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  short result;
  
  if (!SWIG_check_num_args("Time_getMilliseconds",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getMilliseconds" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (short)((ccmc::Time const *)arg1)->getMilliseconds();
  _outv = SWIG_From_short((short)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setMilliseconds, _wrap_Time_setMilliseconds, _wrap_Time_setMilliseconds_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  short val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setMilliseconds",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setMilliseconds" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_short(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setMilliseconds" "', argument " "2"" of type '" "short""'");
  } 
  arg2 = (short)(val2);
  (arg1)->setMilliseconds(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_getMinute, _wrap_Time_getMinute, _wrap_Time_getMinute_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  short result;
  
  if (!SWIG_check_num_args("Time_getMinute",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getMinute" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (short)((ccmc::Time const *)arg1)->getMinute();
  _outv = SWIG_From_short((short)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setMinute, _wrap_Time_setMinute, _wrap_Time_setMinute_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  short val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setMinute",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setMinute" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_short(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setMinute" "', argument " "2"" of type '" "short""'");
  } 
  arg2 = (short)(val2);
  (arg1)->setMinute(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_getMonth, _wrap_Time_getMonth, _wrap_Time_getMonth_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  short result;
  
  if (!SWIG_check_num_args("Time_getMonth",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getMonth" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (short)((ccmc::Time const *)arg1)->getMonth();
  _outv = SWIG_From_short((short)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setMonth, _wrap_Time_setMonth, _wrap_Time_setMonth_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  short val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setMonth",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setMonth" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_short(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setMonth" "', argument " "2"" of type '" "short""'");
  } 
  arg2 = (short)(val2);
  (arg1)->setMonth(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_getSeconds, _wrap_Time_getSeconds, _wrap_Time_getSeconds_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  short result;
  
  if (!SWIG_check_num_args("Time_getSeconds",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getSeconds" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (short)((ccmc::Time const *)arg1)->getSeconds();
  _outv = SWIG_From_short((short)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setSeconds, _wrap_Time_setSeconds, _wrap_Time_setSeconds_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  double arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  double val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setSeconds",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setSeconds" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_double(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setSeconds" "', argument " "2"" of type '" "double""'");
  } 
  arg2 = (double)(val2);
  (arg1)->setSeconds(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_getYear, _wrap_Time_getYear, _wrap_Time_getYear_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  short result;
  
  if (!SWIG_check_num_args("Time_getYear",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getYear" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (short)((ccmc::Time const *)arg1)->getYear();
  _outv = SWIG_From_short((short)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_setYear, _wrap_Time_setYear, _wrap_Time_setYear_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  short arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  short val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("Time_setYear",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_setYear" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  ecode2 = SWIG_AsVal_short(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Time_setYear" "', argument " "2"" of type '" "short""'");
  } 
  arg2 = (short)(val2);
  (arg1)->setYear(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_toString, _wrap_Time_toString, _wrap_Time_toString_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::string result;
  
  if (!SWIG_check_num_args("Time_toString",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_toString" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = ((ccmc::Time const *)arg1)->toString();
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( Time_getEpoch, _wrap_Time_getEpoch, _wrap_Time_getEpoch_texinfo ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  double result;
  
  if (!SWIG_check_num_args("Time_getEpoch",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Time_getEpoch" "', argument " "1"" of type '" "ccmc::Time const *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  result = (double)((ccmc::Time const *)arg1)->getEpoch();
  _outv = SWIG_From_double((double)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_Time, _wrap_delete_Time, std::string() ) {
  ccmc::Time *arg1 = (ccmc::Time *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_Time",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_ccmc__Time, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Time" "', argument " "1"" of type '" "ccmc::Time *""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_Time_members[] = {
{"getDay",_wrap_Time_getDay,0,0,0,0},
{"setDay",_wrap_Time_setDay,0,0,0,0},
{"setEpoch",_wrap_Time_setEpoch,0,0,0,0},
{"getHour",_wrap_Time_getHour,0,0,0,0},
{"setHour",_wrap_Time_setHour,0,0,0,0},
{"getMilliseconds",_wrap_Time_getMilliseconds,0,0,0,0},
{"setMilliseconds",_wrap_Time_setMilliseconds,0,0,0,0},
{"getMinute",_wrap_Time_getMinute,0,0,0,0},
{"setMinute",_wrap_Time_setMinute,0,0,0,0},
{"getMonth",_wrap_Time_getMonth,0,0,0,0},
{"setMonth",_wrap_Time_setMonth,0,0,0,0},
{"getSeconds",_wrap_Time_getSeconds,0,0,0,0},
{"setSeconds",_wrap_Time_setSeconds,0,0,0,0},
{"getYear",_wrap_Time_getYear,0,0,0,0},
{"setYear",_wrap_Time_setYear,0,0,0,0},
{"toString",_wrap_Time_toString,0,0,0,0},
{"getEpoch",_wrap_Time_getEpoch,0,0,0,0},
{0,0,0,0}
};
static const char *swig_Time_base_names[] = {0};
static const swig_type_info *swig_Time_base[] = {0};
static swig_octave_class _wrap_class_Time = {"Time", &SWIGTYPE_p_ccmc__Time,0,_wrap_new_Time,0,_wrap_delete_Time,swig_Time_members,swig_Time_base_names,swig_Time_base };

SWIG_DEFUN( __lshift__, _wrap___lshift__, std::string() ) {
  std::ostream *arg1 = 0 ;
  ccmc::Time arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  std::ostream *result = 0 ;
  
  if (!SWIG_check_num_args("__lshift__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1, SWIGTYPE_p_std__ostream,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "__lshift__" "', argument " "1"" of type '" "std::ostream &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__lshift__" "', argument " "1"" of type '" "std::ostream &""'"); 
  }
  arg1 = (std::ostream *)(argp1);
  {
    res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Time,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "__lshift__" "', argument " "2"" of type '" "ccmc::Time const""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__lshift__" "', argument " "2"" of type '" "ccmc::Time const""'");
    } else {
      arg2 = *((ccmc::Time *)(argp2));
    }
  }
  result = (std::ostream *) &ccmc::operator <<(*arg1,arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__ostream, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( __sub__, _wrap___sub__, std::string() ) {
  ccmc::Time *arg1 = 0 ;
  ccmc::Time *arg2 = 0 ;
  void *argp1 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  double result;
  
  if (!SWIG_check_num_args("__sub__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "__sub__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__sub__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "__sub__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__sub__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  arg2 = (ccmc::Time *)(argp2);
  result = (double)ccmc::operator -((ccmc::Time const &)*arg1,(ccmc::Time const &)*arg2);
  _outv = SWIG_From_double((double)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( __eq__, _wrap___eq__, std::string() ) {
  ccmc::Time *arg1 = 0 ;
  ccmc::Time *arg2 = 0 ;
  void *argp1 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("__eq__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "__eq__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__eq__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "__eq__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__eq__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  arg2 = (ccmc::Time *)(argp2);
  result = (bool)ccmc::operator ==((ccmc::Time const &)*arg1,(ccmc::Time const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( __lt__, _wrap___lt__, std::string() ) {
  ccmc::Time *arg1 = 0 ;
  ccmc::Time *arg2 = 0 ;
  void *argp1 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("__lt__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "__lt__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__lt__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "__lt__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__lt__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  arg2 = (ccmc::Time *)(argp2);
  result = (bool)ccmc::operator <((ccmc::Time const &)*arg1,(ccmc::Time const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( __gt__, _wrap___gt__, std::string() ) {
  ccmc::Time *arg1 = 0 ;
  ccmc::Time *arg2 = 0 ;
  void *argp1 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("__gt__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "__gt__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__gt__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "__gt__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__gt__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  arg2 = (ccmc::Time *)(argp2);
  result = (bool)ccmc::operator >((ccmc::Time const &)*arg1,(ccmc::Time const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( __ge__, _wrap___ge__, std::string() ) {
  ccmc::Time *arg1 = 0 ;
  ccmc::Time *arg2 = 0 ;
  void *argp1 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("__ge__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "__ge__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp1) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__ge__" "', argument " "1"" of type '" "ccmc::Time const &""'"); 
  }
  arg1 = (ccmc::Time *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Time,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "__ge__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "__ge__" "', argument " "2"" of type '" "ccmc::Time const &""'"); 
  }
  arg2 = (ccmc::Time *)(argp2);
  result = (bool)ccmc::operator >=((ccmc::Time const &)*arg1,(ccmc::Time const &)*arg2);
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_pop, _wrap_vector_point3f_pop, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< ccmc::Point3f >::value_type result;
  
  if (!SWIG_check_num_args("vector_point3f_pop",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_pop" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  try {
    result = vector_Sl_Point3f_Sg__pop(arg1);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = SWIG_NewPointerObj((new vector< ccmc::Point3f >::value_type((const vector< ccmc::Point3f >::value_type&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f___paren__, _wrap_vector_point3f___paren__, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::difference_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< ccmc::Point3f >::value_type result;
  
  if (!SWIG_check_num_args("vector_point3f___paren__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f___paren__" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_point3f___paren__" "', argument " "2"" of type '" "vector< ccmc::Point3f >::difference_type""'");
  } 
  arg2 = (vector< ccmc::Point3f >::difference_type)(val2);
  try {
    result = vector_Sl_Point3f_Sg____paren__(arg1,arg2);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = SWIG_NewPointerObj((new vector< ccmc::Point3f >::value_type((const vector< ccmc::Point3f >::value_type&)(result))), SWIGTYPE_p_ccmc__Point3f, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f___paren_asgn__, _wrap_vector_point3f___paren_asgn__, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::difference_type arg2 ;
  vector< ccmc::Point3f >::value_type arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  void *argp3 ;
  int res3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f___paren_asgn__",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f___paren_asgn__" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_point3f___paren_asgn__" "', argument " "2"" of type '" "vector< ccmc::Point3f >::difference_type""'");
  } 
  arg2 = (vector< ccmc::Point3f >::difference_type)(val2);
  {
    res3 = SWIG_ConvertPtr(args(2), &argp3, SWIGTYPE_p_ccmc__Point3f,  0 );
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "vector_point3f___paren_asgn__" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type""'"); 
    }  
    if (!argp3) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f___paren_asgn__" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type""'");
    } else {
      arg3 = *((vector< ccmc::Point3f >::value_type *)(argp3));
    }
  }
  try {
    vector_Sl_Point3f_Sg____paren_asgn__(arg1,arg2,arg3);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_append, _wrap_vector_point3f_append, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::value_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_append",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_append" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  {
    res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "vector_point3f_append" "', argument " "2"" of type '" "vector< ccmc::Point3f >::value_type""'"); 
    }  
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f_append" "', argument " "2"" of type '" "vector< ccmc::Point3f >::value_type""'");
    } else {
      arg2 = *((vector< ccmc::Point3f >::value_type *)(argp2));
    }
  }
  vector_Sl_Point3f_Sg__append(arg1,arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_point3f__SWIG_0 (const octave_value_list& args, int nargout) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< Point3f > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_point3f",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (vector< Point3f > *)new vector< Point3f >();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_point3f__SWIG_1 (const octave_value_list& args, int nargout) {
  std::vector< Point3f > *arg1 = 0 ;
  int res1 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< Point3f > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_point3f",args.length(),1,1,0)) {
    SWIG_fail;
  }
  {
    std::vector<ccmc::Point3f,std::allocator< ccmc::Point3f > > *ptr = (std::vector<ccmc::Point3f,std::allocator< ccmc::Point3f > > *)0;
    res1 = swig::asptr(args(0), &ptr);
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_vector_point3f" "', argument " "1"" of type '" "std::vector< Point3f > const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_vector_point3f" "', argument " "1"" of type '" "std::vector< Point3f > const &""'"); 
    }
    arg1 = ptr;
  }
  result = (vector< Point3f > *)new vector< Point3f >((std::vector< Point3f > const &)*arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res1)) delete arg1;
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_empty, _wrap_vector_point3f_empty, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("vector_point3f_empty",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_empty" "', argument " "1"" of type '" "vector< Point3f > const *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = (bool)((vector< Point3f > const *)arg1)->empty();
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_size, _wrap_vector_point3f_size, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< ccmc::Point3f >::size_type result;
  
  if (!SWIG_check_num_args("vector_point3f_size",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_size" "', argument " "1"" of type '" "vector< Point3f > const *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = ((vector< Point3f > const *)arg1)->size();
  _outv = SWIG_From_size_t((size_t)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_clear, _wrap_vector_point3f_clear, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_clear",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_clear" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  (arg1)->clear();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_swap, _wrap_vector_point3f_swap, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  std::vector< Point3f > *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_swap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_swap" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "vector_point3f_swap" "', argument " "2"" of type '" "std::vector< Point3f > &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f_swap" "', argument " "2"" of type '" "std::vector< Point3f > &""'"); 
  }
  arg2 = (std::vector< Point3f > *)(argp2);
  (arg1)->swap(*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_get_allocator, _wrap_vector_point3f_get_allocator, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::allocator< ccmc::Point3f > > result;
  
  if (!SWIG_check_num_args("vector_point3f_get_allocator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_get_allocator" "', argument " "1"" of type '" "vector< Point3f > const *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = ((vector< Point3f > const *)arg1)->get_allocator();
  _outv = SWIG_NewPointerObj((new vector< ccmc::Point3f >::allocator_type((const vector< ccmc::Point3f >::allocator_type&)(result))), SWIGTYPE_p_std__allocatorT_ccmc__Point3f_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_begin, _wrap_vector_point3f_begin, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > result;
  
  if (!SWIG_check_num_args("vector_point3f_begin",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_begin" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = (arg1)->begin();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< ccmc::Point3f >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_end, _wrap_vector_point3f_end, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > result;
  
  if (!SWIG_check_num_args("vector_point3f_end",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_end" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = (arg1)->end();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< ccmc::Point3f >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_rbegin, _wrap_vector_point3f_rbegin, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< vector< ccmc::Point3f >::reverse_iterator > result;
  
  if (!SWIG_check_num_args("vector_point3f_rbegin",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_rbegin" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = (arg1)->rbegin();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< ccmc::Point3f >::reverse_iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_rend, _wrap_vector_point3f_rend, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< vector< ccmc::Point3f >::reverse_iterator > result;
  
  if (!SWIG_check_num_args("vector_point3f_rend",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_rend" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = (arg1)->rend();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< ccmc::Point3f >::reverse_iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_point3f__SWIG_2 (const octave_value_list& args, int nargout) {
  vector< ccmc::Point3f >::size_type arg1 ;
  size_t val1 ;
  int ecode1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< Point3f > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_point3f",args.length(),1,1,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_size_t(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_vector_point3f" "', argument " "1"" of type '" "vector< ccmc::Point3f >::size_type""'");
  } 
  arg1 = (vector< ccmc::Point3f >::size_type)(val1);
  result = (vector< Point3f > *)new vector< Point3f >(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_pop_back, _wrap_vector_point3f_pop_back, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_pop_back",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_pop_back" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  (arg1)->pop_back();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_point3f_resize__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::size_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_resize",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_resize" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_point3f_resize" "', argument " "2"" of type '" "vector< ccmc::Point3f >::size_type""'");
  } 
  arg2 = (vector< ccmc::Point3f >::size_type)(val2);
  (arg1)->resize(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_point3f_erase__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > result;
  
  if (!SWIG_check_num_args("vector_point3f_erase",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_erase" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_erase" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_erase" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
    }
  }
  result = (arg1)->erase(arg2);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< ccmc::Point3f >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_point3f_erase__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > arg2 ;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  swig::OctSwigIterator *iter3 = 0 ;
  int res3 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > result;
  
  if (!SWIG_check_num_args("vector_point3f_erase",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_erase" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_erase" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_erase" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
    }
  }
  res3 = SWIG_ConvertPtr(args(2), SWIG_as_voidptrptr(&iter3), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res3) || !iter3) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_erase" "', argument " "3"" of type '" "vector< ccmc::Point3f >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter3);
    if (iter_t) {
      arg3 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_erase" "', argument " "3"" of type '" "vector< ccmc::Point3f >::iterator""'");
    }
  }
  result = (arg1)->erase(arg2,arg3);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< ccmc::Point3f >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_erase, _wrap_vector_point3f_erase, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter) != 0));
      if (_v) {
        return _wrap_vector_point3f_erase__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter) != 0));
      if (_v) {
        swig::OctSwigIterator *iter = 0;
        int res = SWIG_ConvertPtr(argv[2], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
        _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter) != 0));
        if (_v) {
          return _wrap_vector_point3f_erase__SWIG_1(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_new_vector_point3f__SWIG_3 (const octave_value_list& args, int nargout) {
  vector< ccmc::Point3f >::size_type arg1 ;
  vector< ccmc::Point3f >::value_type *arg2 = 0 ;
  size_t val1 ;
  int ecode1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< Point3f > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_point3f",args.length(),2,2,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_size_t(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_vector_point3f" "', argument " "1"" of type '" "vector< ccmc::Point3f >::size_type""'");
  } 
  arg1 = (vector< ccmc::Point3f >::size_type)(val1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "new_vector_point3f" "', argument " "2"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_vector_point3f" "', argument " "2"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  arg2 = (vector< ccmc::Point3f >::value_type *)(argp2);
  result = (vector< Point3f > *)new vector< Point3f >(arg1,(vector< ccmc::Point3f >::value_type const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( new_vector_point3f, _wrap_new_vector_point3f, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 0) {
    return _wrap_new_vector_point3f__SWIG_0(args, nargout);
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_size_t(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_vector_point3f__SWIG_2(args, nargout);
    }
  }
  if (argc == 1) {
    int _v;
    int res = swig::asptr(argv[0], (std::vector<ccmc::Point3f,std::allocator< ccmc::Point3f > >**)(0));
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_new_vector_point3f__SWIG_1(args, nargout);
    }
  }
  if (argc == 2) {
    int _v;
    {
      int res = SWIG_AsVal_size_t(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      void *vptr = 0;
      int res = SWIG_ConvertPtr(argv[1], &vptr, SWIGTYPE_p_ccmc__Point3f, 0);
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_new_vector_point3f__SWIG_3(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( vector_point3f_push_back, _wrap_vector_point3f_push_back, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::value_type *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_push_back",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_push_back" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "vector_point3f_push_back" "', argument " "2"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f_push_back" "', argument " "2"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  arg2 = (vector< ccmc::Point3f >::value_type *)(argp2);
  (arg1)->push_back((vector< ccmc::Point3f >::value_type const &)*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_front, _wrap_vector_point3f_front, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< ccmc::Point3f >::value_type *result = 0 ;
  
  if (!SWIG_check_num_args("vector_point3f_front",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_front" "', argument " "1"" of type '" "vector< Point3f > const *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = (vector< ccmc::Point3f >::value_type *) &((vector< Point3f > const *)arg1)->front();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_back, _wrap_vector_point3f_back, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< ccmc::Point3f >::value_type *result = 0 ;
  
  if (!SWIG_check_num_args("vector_point3f_back",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_back" "', argument " "1"" of type '" "vector< Point3f > const *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = (vector< ccmc::Point3f >::value_type *) &((vector< Point3f > const *)arg1)->back();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ccmc__Point3f, 0 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_assign, _wrap_vector_point3f_assign, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::size_type arg2 ;
  vector< ccmc::Point3f >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  void *argp3 ;
  int res3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_assign",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_assign" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_point3f_assign" "', argument " "2"" of type '" "vector< ccmc::Point3f >::size_type""'");
  } 
  arg2 = (vector< ccmc::Point3f >::size_type)(val2);
  res3 = SWIG_ConvertPtr(args(2), &argp3, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res3)) {
    SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "vector_point3f_assign" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  if (!argp3) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f_assign" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  arg3 = (vector< ccmc::Point3f >::value_type *)(argp3);
  (arg1)->assign(arg2,(vector< ccmc::Point3f >::value_type const &)*arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_point3f_resize__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::size_type arg2 ;
  vector< ccmc::Point3f >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  void *argp3 ;
  int res3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_resize",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_resize" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_point3f_resize" "', argument " "2"" of type '" "vector< ccmc::Point3f >::size_type""'");
  } 
  arg2 = (vector< ccmc::Point3f >::size_type)(val2);
  res3 = SWIG_ConvertPtr(args(2), &argp3, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res3)) {
    SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "vector_point3f_resize" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  if (!argp3) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f_resize" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  arg3 = (vector< ccmc::Point3f >::value_type *)(argp3);
  (arg1)->resize(arg2,(vector< ccmc::Point3f >::value_type const &)*arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_resize, _wrap_vector_point3f_resize, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_vector_point3f_resize__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(argv[2], &vptr, SWIGTYPE_p_ccmc__Point3f, 0);
        _v = SWIG_CheckState(res);
        if (_v) {
          return _wrap_vector_point3f_resize__SWIG_1(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_vector_point3f_insert__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > arg2 ;
  vector< ccmc::Point3f >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  void *argp3 ;
  int res3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > result;
  
  if (!SWIG_check_num_args("vector_point3f_insert",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_insert" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_insert" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_insert" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
    }
  }
  res3 = SWIG_ConvertPtr(args(2), &argp3, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res3)) {
    SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "vector_point3f_insert" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  if (!argp3) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f_insert" "', argument " "3"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  arg3 = (vector< ccmc::Point3f >::value_type *)(argp3);
  result = (arg1)->insert(arg2,(vector< ccmc::Point3f >::value_type const &)*arg3);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< ccmc::Point3f >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_point3f_insert__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  SwigValueWrapper< vector< ccmc::Point3f >::iterator > arg2 ;
  vector< ccmc::Point3f >::size_type arg3 ;
  vector< ccmc::Point3f >::value_type *arg4 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  size_t val3 ;
  int ecode3 = 0 ;
  void *argp4 ;
  int res4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_insert",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_insert" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_insert" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_point3f_insert" "', argument " "2"" of type '" "vector< ccmc::Point3f >::iterator""'");
    }
  }
  ecode3 = SWIG_AsVal_size_t(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "vector_point3f_insert" "', argument " "3"" of type '" "vector< ccmc::Point3f >::size_type""'");
  } 
  arg3 = (vector< ccmc::Point3f >::size_type)(val3);
  res4 = SWIG_ConvertPtr(args(3), &argp4, SWIGTYPE_p_ccmc__Point3f,  0 );
  if (!SWIG_IsOK(res4)) {
    SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "vector_point3f_insert" "', argument " "4"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  if (!argp4) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_point3f_insert" "', argument " "4"" of type '" "vector< ccmc::Point3f >::value_type const &""'"); 
  }
  arg4 = (vector< ccmc::Point3f >::value_type *)(argp4);
  (arg1)->insert(arg2,arg3,(vector< ccmc::Point3f >::value_type const &)*arg4);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_insert, _wrap_vector_point3f_insert, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[4]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3)
  };
  
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter) != 0));
      if (_v) {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(argv[2], &vptr, SWIGTYPE_p_ccmc__Point3f, 0);
        _v = SWIG_CheckState(res);
        if (_v) {
          return _wrap_vector_point3f_insert__SWIG_0(args, nargout);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< ccmc::Point3f >::iterator > *>(iter) != 0));
      if (_v) {
        {
          int res = SWIG_AsVal_size_t(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          void *vptr = 0;
          int res = SWIG_ConvertPtr(argv[3], &vptr, SWIGTYPE_p_ccmc__Point3f, 0);
          _v = SWIG_CheckState(res);
          if (_v) {
            return _wrap_vector_point3f_insert__SWIG_1(args, nargout);
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( vector_point3f_reserve, _wrap_vector_point3f_reserve, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  vector< ccmc::Point3f >::size_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_point3f_reserve",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_reserve" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_point3f_reserve" "', argument " "2"" of type '" "vector< ccmc::Point3f >::size_type""'");
  } 
  arg2 = (vector< ccmc::Point3f >::size_type)(val2);
  (arg1)->reserve(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_point3f_capacity, _wrap_vector_point3f_capacity, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< ccmc::Point3f >::size_type result;
  
  if (!SWIG_check_num_args("vector_point3f_capacity",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_point3f_capacity" "', argument " "1"" of type '" "vector< Point3f > const *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  result = ((vector< Point3f > const *)arg1)->capacity();
  _outv = SWIG_From_size_t((size_t)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_vector_point3f, _wrap_delete_vector_point3f, std::string() ) {
  vector< Point3f > *arg1 = (vector< Point3f > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_vector_point3f",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_vector_point3f" "', argument " "1"" of type '" "vector< Point3f > *""'"); 
  }
  arg1 = (vector< Point3f > *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_vector_point3f_members[] = {
{"pop",_wrap_vector_point3f_pop,0,0,0,0},
{"__paren__",_wrap_vector_point3f___paren__,0,0,0,0},
{"__paren_asgn__",_wrap_vector_point3f___paren_asgn__,0,0,0,0},
{"append",_wrap_vector_point3f_append,0,0,0,0},
{"empty",_wrap_vector_point3f_empty,0,0,0,0},
{"size",_wrap_vector_point3f_size,0,0,0,0},
{"clear",_wrap_vector_point3f_clear,0,0,0,0},
{"swap",_wrap_vector_point3f_swap,0,0,0,0},
{"get_allocator",_wrap_vector_point3f_get_allocator,0,0,0,0},
{"begin",_wrap_vector_point3f_begin,0,0,0,0},
{"end",_wrap_vector_point3f_end,0,0,0,0},
{"rbegin",_wrap_vector_point3f_rbegin,0,0,0,0},
{"rend",_wrap_vector_point3f_rend,0,0,0,0},
{"pop_back",_wrap_vector_point3f_pop_back,0,0,0,0},
{"erase",_wrap_vector_point3f_erase,0,0,0,0},
{"push_back",_wrap_vector_point3f_push_back,0,0,0,0},
{"front",_wrap_vector_point3f_front,0,0,0,0},
{"back",_wrap_vector_point3f_back,0,0,0,0},
{"assign",_wrap_vector_point3f_assign,0,0,0,0},
{"resize",_wrap_vector_point3f_resize,0,0,0,0},
{"insert",_wrap_vector_point3f_insert,0,0,0,0},
{"reserve",_wrap_vector_point3f_reserve,0,0,0,0},
{"capacity",_wrap_vector_point3f_capacity,0,0,0,0},
{0,0,0,0}
};
static const char *swig_vector_point3f_base_names[] = {0};
static const swig_type_info *swig_vector_point3f_base[] = {0};
static swig_octave_class _wrap_class_vector_point3f = {"vector_point3f", &SWIGTYPE_p_std__vectorT_ccmc__Point3f_std__allocatorT_ccmc__Point3f_t_t,0,_wrap_new_vector_point3f,0,_wrap_delete_vector_point3f,swig_vector_point3f_members,swig_vector_point3f_base_names,swig_vector_point3f_base };

SWIG_DEFUN( vector_string_pop, _wrap_vector_string_pop, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::value_type result;
  
  if (!SWIG_check_num_args("vector_string_pop",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_pop" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  try {
    result = vector_Sl_std_string_Sg__pop(arg1);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string___paren__, _wrap_vector_string___paren__, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::difference_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::value_type result;
  
  if (!SWIG_check_num_args("vector_string___paren__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string___paren__" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_string___paren__" "', argument " "2"" of type '" "vector< std::string >::difference_type""'");
  } 
  arg2 = (vector< std::string >::difference_type)(val2);
  try {
    result = vector_Sl_std_string_Sg____paren__(arg1,arg2);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = SWIG_From_std_string((std::string)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string___paren_asgn__, _wrap_vector_string___paren_asgn__, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::difference_type arg2 ;
  vector< std::string >::value_type arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string___paren_asgn__",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string___paren_asgn__" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_string___paren_asgn__" "', argument " "2"" of type '" "vector< std::string >::difference_type""'");
  } 
  arg2 = (vector< std::string >::difference_type)(val2);
  {
    std::string *ptr = (std::string *)0;
    int res = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res) || !ptr) {
      SWIG_exception_fail(SWIG_ArgError((ptr ? res : SWIG_TypeError)), "in method '" "vector_string___paren_asgn__" "', argument " "3"" of type '" "vector< std::string >::value_type""'"); 
    }
    arg3 = *ptr;
    if (SWIG_IsNewObj(res)) delete ptr;
  }
  try {
    vector_Sl_std_string_Sg____paren_asgn__(arg1,arg2,arg3);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_append, _wrap_vector_string_append, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::value_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_append",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_append" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    int res = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res) || !ptr) {
      SWIG_exception_fail(SWIG_ArgError((ptr ? res : SWIG_TypeError)), "in method '" "vector_string_append" "', argument " "2"" of type '" "vector< std::string >::value_type""'"); 
    }
    arg2 = *ptr;
    if (SWIG_IsNewObj(res)) delete ptr;
  }
  vector_Sl_std_string_Sg__append(arg1,arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_string__SWIG_0 (const octave_value_list& args, int nargout) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_string",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (vector< std::string > *)new vector< std::string >();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_string__SWIG_1 (const octave_value_list& args, int nargout) {
  std::vector< std::string > *arg1 = 0 ;
  int res1 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_string",args.length(),1,1,0)) {
    SWIG_fail;
  }
  {
    std::vector<std::string,std::allocator< std::string > > *ptr = (std::vector<std::string,std::allocator< std::string > > *)0;
    res1 = swig::asptr(args(0), &ptr);
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_vector_string" "', argument " "1"" of type '" "std::vector< std::string > const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_vector_string" "', argument " "1"" of type '" "std::vector< std::string > const &""'"); 
    }
    arg1 = ptr;
  }
  result = (vector< std::string > *)new vector< std::string >((std::vector< std::string > const &)*arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res1)) delete arg1;
fail:
  return _out;
}


SWIG_DEFUN( vector_string_empty, _wrap_vector_string_empty, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("vector_string_empty",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_empty" "', argument " "1"" of type '" "vector< std::string > const *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = (bool)((vector< std::string > const *)arg1)->empty();
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_size, _wrap_vector_string_size, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::size_type result;
  
  if (!SWIG_check_num_args("vector_string_size",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_size" "', argument " "1"" of type '" "vector< std::string > const *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = ((vector< std::string > const *)arg1)->size();
  _outv = SWIG_From_size_t((size_t)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_clear, _wrap_vector_string_clear, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_clear",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_clear" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  (arg1)->clear();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_swap, _wrap_vector_string_swap, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  std::vector< std::string > *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_swap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_swap" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "vector_string_swap" "', argument " "2"" of type '" "std::vector< std::string > &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_string_swap" "', argument " "2"" of type '" "std::vector< std::string > &""'"); 
  }
  arg2 = (std::vector< std::string > *)(argp2);
  (arg1)->swap(*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_get_allocator, _wrap_vector_string_get_allocator, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::allocator< std::string > > result;
  
  if (!SWIG_check_num_args("vector_string_get_allocator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_get_allocator" "', argument " "1"" of type '" "vector< std::string > const *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = ((vector< std::string > const *)arg1)->get_allocator();
  _outv = SWIG_NewPointerObj((new vector< std::string >::allocator_type((const vector< std::string >::allocator_type&)(result))), SWIGTYPE_p_std__allocatorT_std__string_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_begin, _wrap_vector_string_begin, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::iterator result;
  
  if (!SWIG_check_num_args("vector_string_begin",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_begin" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = (arg1)->begin();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< std::string >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_end, _wrap_vector_string_end, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::iterator result;
  
  if (!SWIG_check_num_args("vector_string_end",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_end" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = (arg1)->end();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< std::string >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_rbegin, _wrap_vector_string_rbegin, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::reverse_iterator result;
  
  if (!SWIG_check_num_args("vector_string_rbegin",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_rbegin" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = (arg1)->rbegin();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< std::string >::reverse_iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_rend, _wrap_vector_string_rend, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::reverse_iterator result;
  
  if (!SWIG_check_num_args("vector_string_rend",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_rend" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = (arg1)->rend();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< std::string >::reverse_iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_string__SWIG_2 (const octave_value_list& args, int nargout) {
  vector< std::string >::size_type arg1 ;
  size_t val1 ;
  int ecode1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_string",args.length(),1,1,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_size_t(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_vector_string" "', argument " "1"" of type '" "vector< std::string >::size_type""'");
  } 
  arg1 = (vector< std::string >::size_type)(val1);
  result = (vector< std::string > *)new vector< std::string >(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_pop_back, _wrap_vector_string_pop_back, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_pop_back",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_pop_back" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  (arg1)->pop_back();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_string_resize__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::size_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_resize",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_resize" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_string_resize" "', argument " "2"" of type '" "vector< std::string >::size_type""'");
  } 
  arg2 = (vector< std::string >::size_type)(val2);
  (arg1)->resize(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_string_erase__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::iterator arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::iterator result;
  
  if (!SWIG_check_num_args("vector_string_erase",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_erase" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_erase" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< std::string >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_erase" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
    }
  }
  result = (arg1)->erase(arg2);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< std::string >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_string_erase__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::iterator arg2 ;
  vector< std::string >::iterator arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  swig::OctSwigIterator *iter3 = 0 ;
  int res3 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::iterator result;
  
  if (!SWIG_check_num_args("vector_string_erase",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_erase" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_erase" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< std::string >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_erase" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
    }
  }
  res3 = SWIG_ConvertPtr(args(2), SWIG_as_voidptrptr(&iter3), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res3) || !iter3) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_erase" "', argument " "3"" of type '" "vector< std::string >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< std::string >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter3);
    if (iter_t) {
      arg3 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_erase" "', argument " "3"" of type '" "vector< std::string >::iterator""'");
    }
  }
  result = (arg1)->erase(arg2,arg3);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< std::string >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_erase, _wrap_vector_string_erase, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter) != 0));
      if (_v) {
        return _wrap_vector_string_erase__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter) != 0));
      if (_v) {
        swig::OctSwigIterator *iter = 0;
        int res = SWIG_ConvertPtr(argv[2], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
        _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter) != 0));
        if (_v) {
          return _wrap_vector_string_erase__SWIG_1(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_new_vector_string__SWIG_3 (const octave_value_list& args, int nargout) {
  vector< std::string >::size_type arg1 ;
  vector< std::string >::value_type *arg2 = 0 ;
  size_t val1 ;
  int ecode1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_string",args.length(),2,2,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_size_t(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_vector_string" "', argument " "1"" of type '" "vector< std::string >::size_type""'");
  } 
  arg1 = (vector< std::string >::size_type)(val1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "new_vector_string" "', argument " "2"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_vector_string" "', argument " "2"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    arg2 = ptr;
  }
  result = (vector< std::string > *)new vector< std::string >(arg1,(vector< std::string >::value_type const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( new_vector_string, _wrap_new_vector_string, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 0) {
    return _wrap_new_vector_string__SWIG_0(args, nargout);
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_size_t(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_vector_string__SWIG_2(args, nargout);
    }
  }
  if (argc == 1) {
    int _v;
    int res = swig::asptr(argv[0], (std::vector<std::string,std::allocator< std::string > >**)(0));
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_new_vector_string__SWIG_1(args, nargout);
    }
  }
  if (argc == 2) {
    int _v;
    {
      int res = SWIG_AsVal_size_t(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      int res = SWIG_AsPtr_std_string(argv[1], (std::string**)(0));
      _v = SWIG_CheckState(res);
      if (_v) {
        return _wrap_new_vector_string__SWIG_3(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( vector_string_push_back, _wrap_vector_string_push_back, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::value_type *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  int res2 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_push_back",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_push_back" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  {
    std::string *ptr = (std::string *)0;
    res2 = SWIG_AsPtr_std_string(args(1), &ptr);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "vector_string_push_back" "', argument " "2"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_string_push_back" "', argument " "2"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    arg2 = ptr;
  }
  (arg1)->push_back((vector< std::string >::value_type const &)*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res2)) delete arg2;
fail:
  return _out;
}


SWIG_DEFUN( vector_string_front, _wrap_vector_string_front, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::value_type *result = 0 ;
  
  if (!SWIG_check_num_args("vector_string_front",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_front" "', argument " "1"" of type '" "vector< std::string > const *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = (vector< std::string >::value_type *) &((vector< std::string > const *)arg1)->front();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_back, _wrap_vector_string_back, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::value_type *result = 0 ;
  
  if (!SWIG_check_num_args("vector_string_back",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_back" "', argument " "1"" of type '" "vector< std::string > const *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = (vector< std::string >::value_type *) &((vector< std::string > const *)arg1)->back();
  _outv = SWIG_From_std_string((std::string)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_assign, _wrap_vector_string_assign, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::size_type arg2 ;
  vector< std::string >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  int res3 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_assign",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_assign" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_string_assign" "', argument " "2"" of type '" "vector< std::string >::size_type""'");
  } 
  arg2 = (vector< std::string >::size_type)(val2);
  {
    std::string *ptr = (std::string *)0;
    res3 = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "vector_string_assign" "', argument " "3"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_string_assign" "', argument " "3"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    arg3 = ptr;
  }
  (arg1)->assign(arg2,(vector< std::string >::value_type const &)*arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res3)) delete arg3;
fail:
  return _out;
}


static octave_value_list _wrap_vector_string_resize__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::size_type arg2 ;
  vector< std::string >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  int res3 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_resize",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_resize" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_string_resize" "', argument " "2"" of type '" "vector< std::string >::size_type""'");
  } 
  arg2 = (vector< std::string >::size_type)(val2);
  {
    std::string *ptr = (std::string *)0;
    res3 = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "vector_string_resize" "', argument " "3"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_string_resize" "', argument " "3"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    arg3 = ptr;
  }
  (arg1)->resize(arg2,(vector< std::string >::value_type const &)*arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res3)) delete arg3;
fail:
  return _out;
}


SWIG_DEFUN( vector_string_resize, _wrap_vector_string_resize, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_vector_string_resize__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        int res = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
        _v = SWIG_CheckState(res);
        if (_v) {
          return _wrap_vector_string_resize__SWIG_1(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_vector_string_insert__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::iterator arg2 ;
  vector< std::string >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  int res3 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::iterator result;
  
  if (!SWIG_check_num_args("vector_string_insert",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_insert" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_insert" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< std::string >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_insert" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
    }
  }
  {
    std::string *ptr = (std::string *)0;
    res3 = SWIG_AsPtr_std_string(args(2), &ptr);
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "vector_string_insert" "', argument " "3"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_string_insert" "', argument " "3"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    arg3 = ptr;
  }
  result = (arg1)->insert(arg2,(vector< std::string >::value_type const &)*arg3);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< std::string >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res3)) delete arg3;
fail:
  return _out;
}


static octave_value_list _wrap_vector_string_insert__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::iterator arg2 ;
  vector< std::string >::size_type arg3 ;
  vector< std::string >::value_type *arg4 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  size_t val3 ;
  int ecode3 = 0 ;
  int res4 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_insert",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_insert" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_insert" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< std::string >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_string_insert" "', argument " "2"" of type '" "vector< std::string >::iterator""'");
    }
  }
  ecode3 = SWIG_AsVal_size_t(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "vector_string_insert" "', argument " "3"" of type '" "vector< std::string >::size_type""'");
  } 
  arg3 = (vector< std::string >::size_type)(val3);
  {
    std::string *ptr = (std::string *)0;
    res4 = SWIG_AsPtr_std_string(args(3), &ptr);
    if (!SWIG_IsOK(res4)) {
      SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "vector_string_insert" "', argument " "4"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_string_insert" "', argument " "4"" of type '" "vector< std::string >::value_type const &""'"); 
    }
    arg4 = ptr;
  }
  (arg1)->insert(arg2,arg3,(vector< std::string >::value_type const &)*arg4);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res4)) delete arg4;
fail:
  return _out;
}


SWIG_DEFUN( vector_string_insert, _wrap_vector_string_insert, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[4]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3)
  };
  
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter) != 0));
      if (_v) {
        int res = SWIG_AsPtr_std_string(argv[2], (std::string**)(0));
        _v = SWIG_CheckState(res);
        if (_v) {
          return _wrap_vector_string_insert__SWIG_0(args, nargout);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< std::string >::iterator > *>(iter) != 0));
      if (_v) {
        {
          int res = SWIG_AsVal_size_t(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          int res = SWIG_AsPtr_std_string(argv[3], (std::string**)(0));
          _v = SWIG_CheckState(res);
          if (_v) {
            return _wrap_vector_string_insert__SWIG_1(args, nargout);
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( vector_string_reserve, _wrap_vector_string_reserve, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  vector< std::string >::size_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_string_reserve",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_reserve" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_string_reserve" "', argument " "2"" of type '" "vector< std::string >::size_type""'");
  } 
  arg2 = (vector< std::string >::size_type)(val2);
  (arg1)->reserve(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_string_capacity, _wrap_vector_string_capacity, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< std::string >::size_type result;
  
  if (!SWIG_check_num_args("vector_string_capacity",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_string_capacity" "', argument " "1"" of type '" "vector< std::string > const *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  result = ((vector< std::string > const *)arg1)->capacity();
  _outv = SWIG_From_size_t((size_t)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( delete_vector_string, _wrap_delete_vector_string, std::string() ) {
  vector< std::string > *arg1 = (vector< std::string > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("delete_vector_string",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t, SWIG_POINTER_DISOWN |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_vector_string" "', argument " "1"" of type '" "vector< std::string > *""'"); 
  }
  arg1 = (vector< std::string > *)(argp1);
  delete arg1;
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static swig_octave_member swig_vector_string_members[] = {
{"pop",_wrap_vector_string_pop,0,0,0,0},
{"__paren__",_wrap_vector_string___paren__,0,0,0,0},
{"__paren_asgn__",_wrap_vector_string___paren_asgn__,0,0,0,0},
{"append",_wrap_vector_string_append,0,0,0,0},
{"empty",_wrap_vector_string_empty,0,0,0,0},
{"size",_wrap_vector_string_size,0,0,0,0},
{"clear",_wrap_vector_string_clear,0,0,0,0},
{"swap",_wrap_vector_string_swap,0,0,0,0},
{"get_allocator",_wrap_vector_string_get_allocator,0,0,0,0},
{"begin",_wrap_vector_string_begin,0,0,0,0},
{"end",_wrap_vector_string_end,0,0,0,0},
{"rbegin",_wrap_vector_string_rbegin,0,0,0,0},
{"rend",_wrap_vector_string_rend,0,0,0,0},
{"pop_back",_wrap_vector_string_pop_back,0,0,0,0},
{"erase",_wrap_vector_string_erase,0,0,0,0},
{"push_back",_wrap_vector_string_push_back,0,0,0,0},
{"front",_wrap_vector_string_front,0,0,0,0},
{"back",_wrap_vector_string_back,0,0,0,0},
{"assign",_wrap_vector_string_assign,0,0,0,0},
{"resize",_wrap_vector_string_resize,0,0,0,0},
{"insert",_wrap_vector_string_insert,0,0,0,0},
{"reserve",_wrap_vector_string_reserve,0,0,0,0},
{"capacity",_wrap_vector_string_capacity,0,0,0,0},
{0,0,0,0}
};
static const char *swig_vector_string_base_names[] = {0};
static const swig_type_info *swig_vector_string_base[] = {0};
static swig_octave_class _wrap_class_vector_string = {"vector_string", &SWIGTYPE_p_std__vectorT_std__string_std__allocatorT_std__string_t_t,0,_wrap_new_vector_string,0,_wrap_delete_vector_string,swig_vector_string_members,swig_vector_string_base_names,swig_vector_string_base };

SWIG_DEFUN( vector_float_pop, _wrap_vector_float_pop, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::value_type result;
  
  if (!SWIG_check_num_args("vector_float_pop",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_pop" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  try {
    result = (vector< float >::value_type)vector_Sl_float_Sg__pop(arg1);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float___paren__, _wrap_vector_float___paren__, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::difference_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::value_type result;
  
  if (!SWIG_check_num_args("vector_float___paren__",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float___paren__" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_float___paren__" "', argument " "2"" of type '" "vector< float >::difference_type""'");
  } 
  arg2 = (vector< float >::difference_type)(val2);
  try {
    result = (vector< float >::value_type)vector_Sl_float_Sg____paren__(arg1,arg2);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = SWIG_From_float((float)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float___paren_asgn__, _wrap_vector_float___paren_asgn__, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::difference_type arg2 ;
  vector< float >::value_type arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  ptrdiff_t val2 ;
  int ecode2 = 0 ;
  float val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float___paren_asgn__",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float___paren_asgn__" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  ecode2 = SWIG_AsVal_ptrdiff_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_float___paren_asgn__" "', argument " "2"" of type '" "vector< float >::difference_type""'");
  } 
  arg2 = (vector< float >::difference_type)(val2);
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "vector_float___paren_asgn__" "', argument " "3"" of type '" "vector< float >::value_type""'");
  } 
  arg3 = (vector< float >::value_type)(val3);
  try {
    vector_Sl_float_Sg____paren_asgn__(arg1,arg2,arg3);
  }
  catch(std::out_of_range &_e) {
    SWIG_exception_fail(SWIG_IndexError, (&_e)->what());
  }
  
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_append, _wrap_vector_float_append, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::value_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_append",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_append" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_float_append" "', argument " "2"" of type '" "vector< float >::value_type""'");
  } 
  arg2 = (vector< float >::value_type)(val2);
  vector_Sl_float_Sg__append(arg1,arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_float__SWIG_0 (const octave_value_list& args, int nargout) {
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_float",args.length(),0,0,0)) {
    SWIG_fail;
  }
  result = (vector< float > *)new vector< float >();
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_float__SWIG_1 (const octave_value_list& args, int nargout) {
  std::vector< float > *arg1 = 0 ;
  int res1 = SWIG_OLDOBJ ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_float",args.length(),1,1,0)) {
    SWIG_fail;
  }
  {
    std::vector<float,std::allocator< float > > *ptr = (std::vector<float,std::allocator< float > > *)0;
    res1 = swig::asptr(args(0), &ptr);
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_vector_float" "', argument " "1"" of type '" "std::vector< float > const &""'"); 
    }
    if (!ptr) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_vector_float" "', argument " "1"" of type '" "std::vector< float > const &""'"); 
    }
    arg1 = ptr;
  }
  result = (vector< float > *)new vector< float >((std::vector< float > const &)*arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
  if (SWIG_IsNewObj(res1)) delete arg1;
fail:
  return _out;
}


SWIG_DEFUN( vector_float_empty, _wrap_vector_float_empty, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  bool result;
  
  if (!SWIG_check_num_args("vector_float_empty",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_empty" "', argument " "1"" of type '" "vector< float > const *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = (bool)((vector< float > const *)arg1)->empty();
  _outv = SWIG_From_bool((bool)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_size, _wrap_vector_float_size, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::size_type result;
  
  if (!SWIG_check_num_args("vector_float_size",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_size" "', argument " "1"" of type '" "vector< float > const *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = ((vector< float > const *)arg1)->size();
  _outv = SWIG_From_size_t((size_t)(result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_clear, _wrap_vector_float_clear, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_clear",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_clear" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  (arg1)->clear();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_swap, _wrap_vector_float_swap, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  std::vector< float > *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  void *argp2 = 0 ;
  int res2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_swap",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_swap" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), &argp2, SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t,  0 );
  if (!SWIG_IsOK(res2)) {
    SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "vector_float_swap" "', argument " "2"" of type '" "std::vector< float > &""'"); 
  }
  if (!argp2) {
    SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "vector_float_swap" "', argument " "2"" of type '" "std::vector< float > &""'"); 
  }
  arg2 = (std::vector< float > *)(argp2);
  (arg1)->swap(*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_get_allocator, _wrap_vector_float_get_allocator, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  SwigValueWrapper< std::allocator< float > > result;
  
  if (!SWIG_check_num_args("vector_float_get_allocator",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_get_allocator" "', argument " "1"" of type '" "vector< float > const *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = ((vector< float > const *)arg1)->get_allocator();
  _outv = SWIG_NewPointerObj((new vector< float >::allocator_type((const vector< float >::allocator_type&)(result))), SWIGTYPE_p_std__allocatorT_float_t, SWIG_POINTER_OWN |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_begin, _wrap_vector_float_begin, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::iterator result;
  
  if (!SWIG_check_num_args("vector_float_begin",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_begin" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = (arg1)->begin();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< float >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_end, _wrap_vector_float_end, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::iterator result;
  
  if (!SWIG_check_num_args("vector_float_end",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_end" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = (arg1)->end();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< float >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_rbegin, _wrap_vector_float_rbegin, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::reverse_iterator result;
  
  if (!SWIG_check_num_args("vector_float_rbegin",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_rbegin" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = (arg1)->rbegin();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< float >::reverse_iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_rend, _wrap_vector_float_rend, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::reverse_iterator result;
  
  if (!SWIG_check_num_args("vector_float_rend",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_rend" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = (arg1)->rend();
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< float >::reverse_iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_new_vector_float__SWIG_2 (const octave_value_list& args, int nargout) {
  vector< float >::size_type arg1 ;
  size_t val1 ;
  int ecode1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_float",args.length(),1,1,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_size_t(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_vector_float" "', argument " "1"" of type '" "vector< float >::size_type""'");
  } 
  arg1 = (vector< float >::size_type)(val1);
  result = (vector< float > *)new vector< float >(arg1);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_pop_back, _wrap_vector_float_pop_back, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_pop_back",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_pop_back" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  (arg1)->pop_back();
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_float_resize__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::size_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_resize",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_resize" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_float_resize" "', argument " "2"" of type '" "vector< float >::size_type""'");
  } 
  arg2 = (vector< float >::size_type)(val2);
  (arg1)->resize(arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_float_erase__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::iterator arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::iterator result;
  
  if (!SWIG_check_num_args("vector_float_erase",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_erase" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_erase" "', argument " "2"" of type '" "vector< float >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< float >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_erase" "', argument " "2"" of type '" "vector< float >::iterator""'");
    }
  }
  result = (arg1)->erase(arg2);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< float >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_float_erase__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::iterator arg2 ;
  vector< float >::iterator arg3 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  swig::OctSwigIterator *iter3 = 0 ;
  int res3 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::iterator result;
  
  if (!SWIG_check_num_args("vector_float_erase",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_erase" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_erase" "', argument " "2"" of type '" "vector< float >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< float >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_erase" "', argument " "2"" of type '" "vector< float >::iterator""'");
    }
  }
  res3 = SWIG_ConvertPtr(args(2), SWIG_as_voidptrptr(&iter3), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res3) || !iter3) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_erase" "', argument " "3"" of type '" "vector< float >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< float >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter3);
    if (iter_t) {
      arg3 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_erase" "', argument " "3"" of type '" "vector< float >::iterator""'");
    }
  }
  result = (arg1)->erase(arg2,arg3);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< float >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_erase, _wrap_vector_float_erase, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter) != 0));
      if (_v) {
        return _wrap_vector_float_erase__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter) != 0));
      if (_v) {
        swig::OctSwigIterator *iter = 0;
        int res = SWIG_ConvertPtr(argv[2], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
        _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter) != 0));
        if (_v) {
          return _wrap_vector_float_erase__SWIG_1(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_new_vector_float__SWIG_3 (const octave_value_list& args, int nargout) {
  vector< float >::size_type arg1 ;
  vector< float >::value_type *arg2 = 0 ;
  size_t val1 ;
  int ecode1 = 0 ;
  vector< float >::value_type temp2 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float > *result = 0 ;
  
  if (!SWIG_check_num_args("new_vector_float",args.length(),2,2,0)) {
    SWIG_fail;
  }
  ecode1 = SWIG_AsVal_size_t(args(0), &val1);
  if (!SWIG_IsOK(ecode1)) {
    SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "new_vector_float" "', argument " "1"" of type '" "vector< float >::size_type""'");
  } 
  arg1 = (vector< float >::size_type)(val1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "new_vector_float" "', argument " "2"" of type '" "vector< float >::value_type""'");
  } 
  temp2 = (vector< float >::value_type)(val2);
  arg2 = &temp2;
  result = (vector< float > *)new vector< float >(arg1,(vector< float >::value_type const &)*arg2);
  _outv = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 1 |  0 );
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( new_vector_float, _wrap_new_vector_float, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[2]={
    octave_value_ref(args,0),octave_value_ref(args,1)
  };
  
  if (argc == 0) {
    return _wrap_new_vector_float__SWIG_0(args, nargout);
  }
  if (argc == 1) {
    int _v;
    {
      int res = SWIG_AsVal_size_t(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      return _wrap_new_vector_float__SWIG_2(args, nargout);
    }
  }
  if (argc == 1) {
    int _v;
    int res = swig::asptr(argv[0], (std::vector<float,std::allocator< float > >**)(0));
    _v = SWIG_CheckState(res);
    if (_v) {
      return _wrap_new_vector_float__SWIG_1(args, nargout);
    }
  }
  if (argc == 2) {
    int _v;
    {
      int res = SWIG_AsVal_size_t(argv[0], NULL);
      _v = SWIG_CheckState(res);
    }
    if (_v) {
      {
        int res = SWIG_AsVal_float(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_new_vector_float__SWIG_3(args, nargout);
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( vector_float_push_back, _wrap_vector_float_push_back, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::value_type *arg2 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  vector< float >::value_type temp2 ;
  float val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_push_back",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_push_back" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  ecode2 = SWIG_AsVal_float(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_float_push_back" "', argument " "2"" of type '" "vector< float >::value_type""'");
  } 
  temp2 = (vector< float >::value_type)(val2);
  arg2 = &temp2;
  (arg1)->push_back((vector< float >::value_type const &)*arg2);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_front, _wrap_vector_float_front, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::value_type *result = 0 ;
  
  if (!SWIG_check_num_args("vector_float_front",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_front" "', argument " "1"" of type '" "vector< float > const *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = (vector< float >::value_type *) &((vector< float > const *)arg1)->front();
  _outv = SWIG_From_float((float)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_back, _wrap_vector_float_back, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::value_type *result = 0 ;
  
  if (!SWIG_check_num_args("vector_float_back",args.length(),1,1,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_back" "', argument " "1"" of type '" "vector< float > const *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  result = (vector< float >::value_type *) &((vector< float > const *)arg1)->back();
  _outv = SWIG_From_float((float)(*result));
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_assign, _wrap_vector_float_assign, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::size_type arg2 ;
  vector< float >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  vector< float >::value_type temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_assign",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_assign" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_float_assign" "', argument " "2"" of type '" "vector< float >::size_type""'");
  } 
  arg2 = (vector< float >::size_type)(val2);
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "vector_float_assign" "', argument " "3"" of type '" "vector< float >::value_type""'");
  } 
  temp3 = (vector< float >::value_type)(val3);
  arg3 = &temp3;
  (arg1)->assign(arg2,(vector< float >::value_type const &)*arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_float_resize__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::size_type arg2 ;
  vector< float >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  vector< float >::value_type temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_resize",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_resize" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  ecode2 = SWIG_AsVal_size_t(args(1), &val2);
  if (!SWIG_IsOK(ecode2)) {
    SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "vector_float_resize" "', argument " "2"" of type '" "vector< float >::size_type""'");
  } 
  arg2 = (vector< float >::size_type)(val2);
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "vector_float_resize" "', argument " "3"" of type '" "vector< float >::value_type""'");
  } 
  temp3 = (vector< float >::value_type)(val3);
  arg3 = &temp3;
  (arg1)->resize(arg2,(vector< float >::value_type const &)*arg3);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_resize, _wrap_vector_float_resize, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[3]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2)
  };
  
  if (argc == 2) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        return _wrap_vector_float_resize__SWIG_0(args, nargout);
      }
    }
  }
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      {
        int res = SWIG_AsVal_size_t(argv[1], NULL);
        _v = SWIG_CheckState(res);
      }
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_vector_float_resize__SWIG_1(args, nargout);
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


static octave_value_list _wrap_vector_float_insert__SWIG_0 (const octave_value_list& args, int nargout) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::iterator arg2 ;
  vector< float >::value_type *arg3 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  vector< float >::value_type temp3 ;
  float val3 ;
  int ecode3 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  vector< float >::iterator result;
  
  if (!SWIG_check_num_args("vector_float_insert",args.length(),3,3,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_insert" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_insert" "', argument " "2"" of type '" "vector< float >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< float >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_insert" "', argument " "2"" of type '" "vector< float >::iterator""'");
    }
  }
  ecode3 = SWIG_AsVal_float(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "vector_float_insert" "', argument " "3"" of type '" "vector< float >::value_type""'");
  } 
  temp3 = (vector< float >::value_type)(val3);
  arg3 = &temp3;
  result = (arg1)->insert(arg2,(vector< float >::value_type const &)*arg3);
  _outv = SWIG_NewPointerObj(swig::make_output_iterator((const vector< float >::iterator &)(result)),
    swig::OctSwigIterator::descriptor(),SWIG_POINTER_OWN);
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


static octave_value_list _wrap_vector_float_insert__SWIG_1 (const octave_value_list& args, int nargout) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::iterator arg2 ;
  vector< float >::size_type arg3 ;
  vector< float >::value_type *arg4 = 0 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  swig::OctSwigIterator *iter2 = 0 ;
  int res2 ;
  size_t val3 ;
  int ecode3 = 0 ;
  vector< float >::value_type temp4 ;
  float val4 ;
  int ecode4 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_insert",args.length(),4,4,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_float_insert" "', argument " "1"" of type '" "vector< float > *""'"); 
  }
  arg1 = (vector< float > *)(argp1);
  res2 = SWIG_ConvertPtr(args(1), SWIG_as_voidptrptr(&iter2), swig::OctSwigIterator::descriptor(), 0);
  if (!SWIG_IsOK(res2) || !iter2) {
    SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_insert" "', argument " "2"" of type '" "vector< float >::iterator""'");
  } else {
    swig::OctSwigIterator_T<vector< float >::iterator > *iter_t = dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter2);
    if (iter_t) {
      arg2 = iter_t->get_current();
    } else {
      SWIG_exception_fail(SWIG_ArgError(SWIG_TypeError), "in method '" "vector_float_insert" "', argument " "2"" of type '" "vector< float >::iterator""'");
    }
  }
  ecode3 = SWIG_AsVal_size_t(args(2), &val3);
  if (!SWIG_IsOK(ecode3)) {
    SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "vector_float_insert" "', argument " "3"" of type '" "vector< float >::size_type""'");
  } 
  arg3 = (vector< float >::size_type)(val3);
  ecode4 = SWIG_AsVal_float(args(3), &val4);
  if (!SWIG_IsOK(ecode4)) {
    SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "vector_float_insert" "', argument " "4"" of type '" "vector< float >::value_type""'");
  } 
  temp4 = (vector< float >::value_type)(val4);
  arg4 = &temp4;
  (arg1)->insert(arg2,arg3,(vector< float >::value_type const &)*arg4);
  _outv = octave_value();
  if (_outv.is_defined()) _outp = SWIG_Octave_AppendOutput(_outp, _outv);
fail:
  return _out;
}


SWIG_DEFUN( vector_float_insert, _wrap_vector_float_insert, std::string() ) {
  int argc = args.length();
  octave_value_ref argv[4]={
    octave_value_ref(args,0),octave_value_ref(args,1),octave_value_ref(args,2),octave_value_ref(args,3)
  };
  
  if (argc == 3) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter) != 0));
      if (_v) {
        {
          int res = SWIG_AsVal_float(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          return _wrap_vector_float_insert__SWIG_0(args, nargout);
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    void *vptr = 0;
    int res = SWIG_ConvertPtr(argv[0], &vptr, SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0);
    _v = SWIG_CheckState(res);
    if (_v) {
      swig::OctSwigIterator *iter = 0;
      int res = SWIG_ConvertPtr(argv[1], SWIG_as_voidptrptr(&iter), swig::OctSwigIterator::descriptor(), 0);
      _v = (SWIG_IsOK(res) && iter && (dynamic_cast<swig::OctSwigIterator_T<vector< float >::iterator > *>(iter) != 0));
      if (_v) {
        {
          int res = SWIG_AsVal_size_t(argv[2], NULL);
          _v = SWIG_CheckState(res);
        }
        if (_v) {
          {
            int res = SWIG_AsVal_float(argv[3], NULL);
            _v = SWIG_CheckState(res);
          }
          if (_v) {
            return _wrap_vector_float_insert__SWIG_1(args, nargout);
          }
        }
      }
    }
  }
  
  error("No matching function for overload");
  return octave_value_list();
}


SWIG_DEFUN( vector_float_reserve, _wrap_vector_float_reserve, std::string() ) {
  vector< float > *arg1 = (vector< float > *) 0 ;
  vector< float >::size_type arg2 ;
  void *argp1 = 0 ;
  int res1 = 0 ;
  size_t val2 ;
  int ecode2 = 0 ;
  octave_value_list _out;
  octave_value_list *_outp=&_out;
  octave_value _outv;
  
  if (!SWIG_check_num_args("vector_float_reserve",args.length(),2,2,0)) {
    SWIG_fail;
  }
  res1 = SWIG_ConvertPtr(args(0), &argp1,SWIGTYPE_p_std__vectorT_float_std__allocatorT_float_t_t, 0 |  0 );
  if (!SWIG_IsOK(res1)) {
    SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "vector_flo